/*
 * Decompiled with CFR 0.152.
 */
package com.alek.medieval_mobs.mobs.agressive;

import com.alek.medieval_mobs.config.Config;
import com.alek.medieval_mobs.mobs.agressive.BanditEntity;
import com.alek.medieval_mobs.mobs.agressive.BrigandEntity;
import com.alek.medieval_mobs.mobs.agressive.TribesmanEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class AgressiveMobHandler {
    public void register(Config c) {
        this.registerBrigand(c);
        this.registerBandit(c);
        this.registerTribesman(c);
    }

    private void registerBrigand(Config c) {
        EntityRegistry.registerGlobalEntityID(BrigandEntity.class, (String)"Brigand", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)7541931, (int)16770560);
        Object[] biomes = new BiomeGenBase[]{};
        if (c.agressiveMobs.newMobsSpawnEverywhere) {
            ArrayList all_biomesList = new ArrayList();
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                biomes = (BiomeGenBase[])ArrayUtils.add((Object[])biomes, (Object)biome);
            }
        } else {
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.DENSE));
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        }
        EntityRegistry.addSpawn(BrigandEntity.class, (int)c.agressiveMobs.brigandSpawnRate, (int)c.agressiveMobs.brigandMinGroupSize, (int)c.agressiveMobs.brigandMaxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])biomes);
    }

    private void registerBandit(Config c) {
        EntityRegistry.registerGlobalEntityID(BanditEntity.class, (String)"Bandit", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)7541931, (int)58880);
        Object[] biomes = new BiomeGenBase[]{};
        if (c.agressiveMobs.newMobsSpawnEverywhere) {
            ArrayList all_biomesList = new ArrayList();
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                biomes = (BiomeGenBase[])ArrayUtils.add((Object[])biomes, (Object)biome);
            }
        } else {
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.DENSE));
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        }
        EntityRegistry.addSpawn(BanditEntity.class, (int)c.agressiveMobs.banditSpawnRate, (int)c.agressiveMobs.banditMinGroupSize, (int)c.agressiveMobs.banditMaxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])biomes);
    }

    private void registerTribesman(Config c) {
        EntityRegistry.registerGlobalEntityID(TribesmanEntity.class, (String)"Tribesman", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)7541931, (int)59135);
        Object[] biomes = new BiomeGenBase[]{};
        if (c.agressiveMobs.newMobsSpawnEverywhere) {
            ArrayList all_biomesList = new ArrayList();
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                biomes = (BiomeGenBase[])ArrayUtils.add((Object[])biomes, (Object)biome);
            }
        } else {
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.COLD));
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
            BiomeGenBase[] woods = new BiomeGenBase[]{};
            woods = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.DENSE));
            woods = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SPARSE));
            biomes = AgressiveMobHandler.getIntersection(woods, (BiomeGenBase[])biomes);
        }
        EntityRegistry.addSpawn(TribesmanEntity.class, (int)c.agressiveMobs.tribesmanSpawnRate, (int)c.agressiveMobs.tribesmanMinGroupSize, (int)c.agressiveMobs.tribesmanMaxGroupSize, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])biomes);
    }

    public static BiomeGenBase[] getIntersection(BiomeGenBase[] array1, BiomeGenBase[] array2) {
        HashSet<BiomeGenBase> s1 = new HashSet<BiomeGenBase>(Arrays.asList(array1));
        HashSet<BiomeGenBase> s2 = new HashSet<BiomeGenBase>(Arrays.asList(array2));
        s1.retainAll(s2);
        BiomeGenBase[] result = s1.toArray(new BiomeGenBase[s1.size()]);
        return result;
    }
}

