/*
 * Decompiled with CFR 0.152.
 */
package com.alek.medieval_mobs.mobs;

import com.alek.medieval_mobs.config.Config;
import com.alek.medieval_mobs.mobs.agressive.BanditEntity;
import com.alek.medieval_mobs.mobs.agressive.BrigandEntity;
import com.alek.medieval_mobs.mobs.agressive.TribesmanEntity;
import java.util.ArrayList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class MonsterBlocker {
    private static double newMobsSpawnFactor;

    public MonsterBlocker(Config config) {
        newMobsSpawnFactor = config.agressiveMobs.newMobsSpawnFactor;
        ArrayList<BiomeGenBase> all_biomesList = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            all_biomesList.add(biome);
        }
        BiomeGenBase[] all_biomes_array = new BiomeGenBase[all_biomesList.size()];
        BiomeGenBase[] all_biomes = all_biomesList.toArray(all_biomes_array);
        if (config.vanillaMobs.disableZombie) {
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
        if (config.vanillaMobs.disableSkeleton) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
        if (config.vanillaMobs.disableSpiders) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
        if (config.vanillaMobs.disableSlimes) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
        if (config.vanillaMobs.disableCreepers) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
        if (config.vanillaMobs.disableEndermen) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
        if (config.vanillaMobs.disableWitches) {
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])all_biomes);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.entity instanceof BrigandEntity || event.entity instanceof BanditEntity || event.entity instanceof TribesmanEntity) {
            if (Math.random() > newMobsSpawnFactor) {
                event.setCanceled(true);
            }
        }
    }
}

