/*
 * Decompiled with CFR 0.152.
 */
package com.alek.medieval_mobs.config;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class AgressiveMobs {
    private Configuration config;
    public int banditSpawnRate;
    public int brigandSpawnRate;
    public int tribesmanSpawnRate;
    public double newMobsSpawnFactor;
    public boolean newMobsSpawnEverywhere;
    public int banditMinGroupSize;
    public int banditMaxGroupSize;
    public int brigandMinGroupSize;
    public int brigandMaxGroupSize;
    public int tribesmanMinGroupSize;
    public int tribesmanMaxGroupSize;

    public AgressiveMobs(Configuration config) {
        this.config = config;
    }

    public Configuration set() {
        Property banditSpawnRate = this.config.get("general", "Bandit spawn rate", 1);
        banditSpawnRate.comment = "Set probability of bandits spawning";
        this.banditSpawnRate = banditSpawnRate.getInt(1);
        Property banditMinGroupSize = this.config.get("general", "Bandit min.group size", 1);
        banditMinGroupSize.comment = "A minimum number of bandits in a spawned group";
        this.banditMinGroupSize = banditMinGroupSize.getInt(1);
        Property banditMaxGroupSize = this.config.get("general", "Bandit max.group size", 4);
        banditMaxGroupSize.comment = "A maxiumum number of bandits in a spawned group";
        this.banditMaxGroupSize = banditMaxGroupSize.getInt(4);
        Property brigandSpawnRate = this.config.get("general", "Brigand spawn rate", 1);
        brigandSpawnRate.comment = "Set probability of brigands spawning";
        this.brigandSpawnRate = brigandSpawnRate.getInt(1);
        Property brigandMinGroupSize = this.config.get("general", "Brigand min.group size", 1);
        brigandMinGroupSize.comment = "A minimum number of brigands in a spawned group";
        this.brigandMinGroupSize = brigandMinGroupSize.getInt(1);
        Property brigandMaxGroupSize = this.config.get("general", "Brigand max.group size", 4);
        brigandMaxGroupSize.comment = "A maxiumum number of brigands in a spawned group";
        this.brigandMaxGroupSize = brigandMaxGroupSize.getInt(4);
        Property tribesmanSpawnRate = this.config.get("general", "Tribesmen spawn rate", 1);
        tribesmanSpawnRate.comment = "Set probability of tribesmen spawning";
        this.tribesmanSpawnRate = tribesmanSpawnRate.getInt(1);
        Property tribesmanMinGroupSize = this.config.get("general", "Tribesmen min.group size", 3);
        tribesmanMinGroupSize.comment = "A minimum number of tribesmen in a spawned group";
        this.tribesmanMinGroupSize = tribesmanMinGroupSize.getInt(3);
        Property tribesmanMaxGroupSize = this.config.get("general", "Tribesmen max.group size", 8);
        tribesmanMaxGroupSize.comment = "A maxiumum number of tribesmen in a spawned group";
        this.tribesmanMaxGroupSize = tribesmanMaxGroupSize.getInt(8);
        Property newMobsSpawnFactor = this.config.get("general", "Spawn factor for new mobs", 0.5);
        newMobsSpawnFactor.comment = "general factor of added mobs spawning, given in percent, Java type is double";
        this.newMobsSpawnFactor = newMobsSpawnFactor.getDouble(0.5);
        Property newMobsSpawnEverywhere = this.config.get("general", "Should new mobs spawn everywhere ?", false);
        newMobsSpawnEverywhere.comment = "Should new mobs spawn everywhere ? (if false they will only spawn in biomes with tags FOREST or DENSE)";
        this.newMobsSpawnEverywhere = newMobsSpawnEverywhere.getBoolean(false);
        return this.config;
    }
}

