/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.management;

import com.tihyo.superheroes.management.SUMVec3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class SUMMathHelper {
    public static void flyToPlayer(Entity entity, SUMVec3 originalPosVector, float modifier) {
        SUMVec3 entityVector = SUMVec3.entityCenterPoint(entity);
        SUMVec3 finalVector = originalPosVector.copy().subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector.normalize();
        }
        entity.field_70159_w = finalVector.x * (double)modifier;
        entity.field_70181_x = finalVector.y * (double)modifier;
        entity.field_70179_y = finalVector.z * (double)modifier;
    }

    public static boolean isFlyingUp(Entity entity) {
        return entity.field_70163_u > entity.field_70167_r + 0.4;
    }

    public static boolean isFlyingDown(Entity entity) {
        return entity.field_70163_u + 0.4 < entity.field_70167_r && entity.func_70093_af();
    }

    public static boolean isBlockUnderneath(EntityPlayer player) {
        return SUMMathHelper.underBlockChecker(player);
    }

    private static boolean underBlockChecker(EntityPlayer player) {
        return player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 4, (int)player.field_70161_v) && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 3, (int)player.field_70161_v) && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 2, (int)player.field_70161_v) && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v) && !player.field_70124_G;
    }

    public static boolean isInDeepWater(EntityPlayer player) {
        return player.func_70090_H() && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 7, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 6, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 5, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 4, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 3, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 2, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v) == Blocks.field_150355_j && player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v) == Blocks.field_150355_j;
    }

    public static boolean altitudeCap(EntityPlayer player, int max) {
        return player.field_70163_u > (double)max;
    }

    public static boolean consumeItems(EntityPlayer player, IInventory inventory, Item item, int count, String upgradedCharacter, String materials, Item helmet, Item chest, Item legs, Item boots) {
        int slot;
        boolean flag = false;
        int remain = count;
        for (slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack itemstack = inventory.func_70301_a(slot);
            if (itemstack == null || !itemstack.func_77973_b().equals(item) || (remain -= itemstack.field_77994_a) > 0) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (slot = 0; count > 0 && slot < inventory.func_70302_i_(); ++slot) {
                ItemStack itemstack = inventory.func_70301_a(slot);
                if (itemstack == null || !itemstack.func_77973_b().equals(item)) continue;
                if ((count -= itemstack.field_77994_a) >= 0) {
                    inventory.func_70299_a(slot, (ItemStack)null);
                    continue;
                }
                itemstack.field_77994_a = -count;
                player.func_70062_b(4, new ItemStack(helmet));
                player.func_70062_b(3, new ItemStack(chest));
                player.func_70062_b(2, new ItemStack(legs));
                player.func_70062_b(1, new ItemStack(boots));
                player.field_70170_p.func_72956_a((Entity)player, "random.levelup", 2.0f, 1.0f);
            }
        } else {
            SUMMathHelper.upgradeMessage(player, upgradedCharacter, materials, count);
        }
        return flag;
    }

    private static void upgradeMessage(EntityPlayer player, String upgradedCharacter, String materials, int materialAmount) {
        ChatComponentText versionWarningChatComponent = new ChatComponentText("You need " + materialAmount + " " + materials + " to upgrade to " + upgradedCharacter + ".");
        player.func_145747_a((IChatComponent)versionWarningChatComponent);
    }
}

