/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.handlers;

import com.tihyo.legends.client.renders.EntityRendererModifier;
import com.tihyo.legends.common.Main;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.entities.EntityBullet;
import com.tihyo.legends.entities.ExtendedPlayer;
import com.tihyo.legends.management.IAnimation;
import com.tihyo.legends.management.IStealth;
import com.tihyo.superheroes.armors.ItemSUMCharacterArmor;
import com.tihyo.superheroes.characters.AntMan;
import com.tihyo.superheroes.characters.Darkseid;
import com.tihyo.superheroes.characters.GeneralZod;
import com.tihyo.superheroes.characters.IronMan;
import com.tihyo.superheroes.characters.SpiderMan;
import com.tihyo.superheroes.characters.Supergirl;
import com.tihyo.superheroes.characters.Superman;
import com.tihyo.superheroes.characters.Thor;
import com.tihyo.superheroes.characters.Ultron;
import com.tihyo.superheroes.client.ChangeTickRate;
import com.tihyo.superheroes.client.SuperheroesRenderHelper;
import com.tihyo.superheroes.entities.mobs.EntityAnt;
import com.tihyo.superheroes.handlers.IntangibilityEventHandler;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.handlers.UpgradeModeEventHandler;
import com.tihyo.superheroes.handlers.WeaponEventHandler;
import com.tihyo.superheroes.handlers.dc.BatmanEventHandler;
import com.tihyo.superheroes.handlers.dc.CatwomanEventHandler;
import com.tihyo.superheroes.handlers.dc.DarkseidEventHandler;
import com.tihyo.superheroes.handlers.dc.DeathstrokeEventHandler;
import com.tihyo.superheroes.handlers.dc.GeneralZodEventHandler;
import com.tihyo.superheroes.handlers.dc.NightwingEventHandler;
import com.tihyo.superheroes.handlers.dc.RobinEventHandler;
import com.tihyo.superheroes.handlers.dc.ScarecrowEventHandler;
import com.tihyo.superheroes.handlers.dc.SupergirlEventHandler;
import com.tihyo.superheroes.handlers.dc.SupermanEventHandler;
import com.tihyo.superheroes.handlers.marvel.AntManEventHandler;
import com.tihyo.superheroes.handlers.marvel.DeadpoolEventHandler;
import com.tihyo.superheroes.handlers.marvel.HulkEventHandler;
import com.tihyo.superheroes.handlers.marvel.RedHulkEventHandler;
import com.tihyo.superheroes.handlers.marvel.SpiderManEventHandler;
import com.tihyo.superheroes.handlers.marvel.WolverineEventHandler;
import com.tihyo.superheroes.management.IIntangible;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.ISlowMo;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.utils.SUMHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.AccessEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class SUMEventHandler {
    ChangeTickRate tickChanger = new ChangeTickRate();
    int tickTime = 20;
    private EntityRenderer prevRenderer;
    private EntityRendererModifier renderer;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.world;
        GameRules gameRules = world.func_82736_K();
        if (gameRules != null) {
            if (!gameRules.func_82765_e("slowMo")) {
                gameRules.func_82769_a("slowMo", "true");
            }
            if (!gameRules.func_82765_e("phantomZoneProjector")) {
                gameRules.func_82769_a("phantomZoneProjector", "true");
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        SUMSuitVersionUpdater.onUpdate(event);
        UpgradeModeEventHandler.onUpdate(event);
        WeaponEventHandler.onWeapons(event);
        IntangibilityEventHandler.onIntang(event);
        SupermanEventHandler.onSuperman(event);
        BatmanEventHandler.onBatman(event);
        SupergirlEventHandler.onSupergirl(event);
        RobinEventHandler.onRobin(event);
        NightwingEventHandler.onNightwing(event);
        HulkEventHandler.onHulk(event);
        AntManEventHandler.onAntMan(event);
        SpiderManEventHandler.onSpiderMan(event);
        WolverineEventHandler.onWolverine(event);
        DeadpoolEventHandler.onDeadpool(event);
        DarkseidEventHandler.onDarkseid(event);
        GeneralZodEventHandler.onGeneralZod(event);
        CatwomanEventHandler.onCatwoman(event);
        ScarecrowEventHandler.onScarecrow(event);
        RedHulkEventHandler.onRedHulk(event);
        DeathstrokeEventHandler.onDeathstroke(event);
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            SUMCharacter character = SUMHelper.getCharacter(player);
            if (event.source.func_76364_f() instanceof EntityBullet || event.source.func_76364_f() instanceof EntityArrow || event.source.func_76364_f() instanceof EntitySnowball) {
                if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && (character instanceof Darkseid || character instanceof Ultron || character instanceof IronMan) || SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && (character instanceof Superman || character instanceof Supergirl || character instanceof GeneralZod)) {
                    event.setCanceled(true);
                }
                if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && character instanceof Thor) {
                    event.setCanceled(true);
                }
            }
            if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof Darkseid && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("isShielding")) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent event) {
        HulkEventHandler.onAttackHulk(event);
        WolverineEventHandler.onAttackWolverine(event);
        DarkseidEventHandler.onAttackDarkseid(event);
        CatwomanEventHandler.onAttackCatwoman(event);
        ScarecrowEventHandler.onAttackScarecrow(event);
        RedHulkEventHandler.onAttackRedHulk(event);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        UpgradeModeEventHandler.onEntityDeath(event);
    }

    @SubscribeEvent
    public void fallDamage(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            SUMCharacter character = SUMHelper.getCharacter(player);
            if (player != null && character != null) {
                event.distance = character.getFallResistance() == 0.0f || character instanceof SpiderMan && player.func_70093_af() ? 0.0f : (event.distance /= character.getFallResistance());
            }
        }
    }

    @SubscribeEvent
    public void playerIntereact(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74779_i("Size").equals("big") && character instanceof AntMan) {
            event.world.func_147439_a(event.x, event.y, event.z).func_149697_b(event.world, event.x, event.y, event.z, event.world.func_72805_g(event.x, event.y, event.z), 0);
            event.world.func_147468_f(event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        EntityPlayer player = event.player;
        if (player.func_82169_q(2) != null && player.func_82169_q(2).func_77973_b() instanceof ItemSUMCharacterArmor) {
            float heightMod;
            if (player.func_82169_q(2) != null && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74764_b("Animation")) {
                float heightMod2 = ((ItemSUMCharacterArmor)player.func_82169_q(2).func_77973_b()).getHeight(player.func_82169_q(2));
                float aniHeightMod = player.func_82169_q(2).func_77978_p().func_74760_g("AnimationHeight");
                if (heightMod2 < 0.5f || aniHeightMod <= 0.5f) {
                    event.setCanceled(true);
                }
            } else if (player.func_82169_q(2) != null && player.func_82169_q(2).func_77942_o() && (heightMod = ((ItemSUMCharacterArmor)player.func_82169_q(2).func_77973_b()).getHeight(player.func_82169_q(2))) < 0.5f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        ExtendedPlayer extPlayer = ExtendedPlayer.get((EntityPlayer)player);
        SUMCharacter character = SUMHelper.getCharacter(player);
        ItemStack suit = player.func_82169_q(2);
        GameRules gameRules = player.field_70170_p.func_82736_K();
        if (player != null && gameRules.func_82766_b("slowMo")) {
            if (player.field_70170_p.field_72995_K && player.field_70128_L) {
                ChangeTickRate.updateClientTickrate(20.0f);
            }
            if (!player.field_70170_p.field_72995_K) {
                List list = player.field_70170_p.func_72839_b((Entity)player, player.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player1 = (EntityPlayer)entity;
                    ExtendedPlayer extPlayer1 = ExtendedPlayer.get((EntityPlayer)player1);
                    SUMCharacter character1 = SUMHelper.getCharacter(player1);
                    ItemStack suit1 = player1.func_82169_q(2);
                    if (suit1 == null || !(character1 instanceof ISlowMo) || !suit1.func_77942_o() || !suit1.func_77978_p().func_74764_b("SlowMo") || !suit1.func_77978_p().func_74767_n("SlowMo") || suit != null && suit.func_77942_o() && suit.func_77978_p().func_74764_b("SlowMo") && suit.func_77978_p().func_74767_n("SlowMo")) continue;
                    player.func_70690_d(new PotionEffect(Main.slownessPotion.field_76415_H, 10, 5));
                }
            }
            if (PowersHandlerSuperheroes.allPlayersInSlowMo(player.field_70170_p)) {
                ChangeTickRate.updateServerTickrate(3.0f);
            } else {
                ChangeTickRate.updateServerTickrate(20.0f);
            }
        } else if (player.field_70170_p.field_72995_K) {
            ChangeTickRate.updateClientTickrate(20.0f);
        }
    }

    @SubscribeEvent
    public void sizeChange(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayer) {
            EntityPlayer player = event.player;
            ExtendedPlayer extPlayer = ExtendedPlayer.get((EntityPlayer)player);
            SUMCharacter character = SUMHelper.getCharacter(player);
            float defaultWidth = 0.6f;
            float defaultHeight = 1.8f;
            float eyeHeight = event.player.getDefaultEyeHeight();
            ItemStack chest = event.player.func_82169_q(2);
            if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && chest.func_77973_b() instanceof ItemSUMCharacterArmor) {
                float heightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getHeight(chest);
                float widthMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getWidth(chest);
                float eyeHeightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getEyeHeight(chest);
                if (heightMod != 1.0f || widthMod != 1.0f) {
                    AccessEntity.setSize((Entity)event.player, defaultWidth * widthMod, defaultHeight * heightMod, eyeHeight * eyeHeightMod);
                } else {
                    AccessEntity.resetSize((Entity)event.player, defaultWidth, defaultHeight);
                }
            } else {
                AccessEntity.resetSize((Entity)event.player, defaultWidth, defaultHeight);
            }
        }
    }

    @SubscribeEvent
    public void playerCrafting(PlayerEvent.ItemCraftedEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void resizePre(RenderLivingEvent.Pre event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            SUMCharacter character = SUMHelper.getCharacter(player);
            ItemStack chest = player.func_82169_q(2);
            if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && chest.func_77973_b() instanceof ItemSUMCharacterArmor) {
                float heightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getHeight(chest);
                float widthMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getWidth(chest);
                if (heightMod != 1.0f || widthMod != 1.0f) {
                    GL11.glPushMatrix();
                    if (minecraft.field_71474_y.field_74320_O > 0 && player == Minecraft.func_71410_x().field_71439_g) {
                        double modifier = 1.62;
                        GL11.glTranslated((double)event.x, (double)(event.y + modifier), (double)event.z);
                        if (character instanceof IAnimation) {
                            GL11.glScalef((float)widthMod, (float)((IAnimation)character).getDefaultHeight(player), (float)widthMod);
                            if (chest.func_77942_o() && chest.func_77978_p().func_74760_g("Height") != ((IAnimation)character).getDefaultHeight(player)) {
                                GL11.glTranslated((double)(-event.x), (double)(-(event.y + modifier + (double)0.45f)), (double)(-event.z));
                            } else {
                                GL11.glTranslated((double)(-event.x), (double)(-(event.y + modifier)), (double)(-event.z));
                            }
                        } else {
                            GL11.glScalef((float)widthMod, (float)heightMod, (float)widthMod);
                            GL11.glTranslated((double)(-event.x), (double)(-(event.y + modifier)), (double)(-event.z));
                        }
                    } else {
                        GL11.glTranslated((double)event.x, (double)event.y, (double)event.z);
                        if (character instanceof IAnimation) {
                            GL11.glScalef((float)widthMod, (float)((IAnimation)character).getDefaultHeight(player), (float)widthMod);
                            if (chest.func_77942_o() && chest.func_77978_p().func_74760_g("Height") != ((IAnimation)character).getDefaultHeight(player)) {
                                GL11.glTranslated((double)(-event.x), (double)(-event.y - (double)1.2f), (double)(-event.z));
                            } else {
                                GL11.glTranslated((double)(-event.x), (double)(-event.y), (double)(-event.z));
                            }
                        } else {
                            GL11.glScalef((float)widthMod, (float)heightMod, (float)widthMod);
                            GL11.glTranslated((double)(-event.x), (double)(-event.y), (double)(-event.z));
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void resizePost(RenderLivingEvent.Post event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack chest = player.func_82169_q(2);
            if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && chest.func_77973_b() instanceof ItemSUMCharacterArmor) {
                float heightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getHeight(chest);
                float widthMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getWidth(chest);
                if (heightMod != 1.0f || widthMod != 1.0f) {
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderEvent(TickEvent.RenderTickEvent event) {
        EntityClientPlayerMP player;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && (player = minecraft.field_71439_g) != null && minecraft.field_71462_r == null) {
            ItemStack chest = player.func_82169_q(2);
            if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && chest.func_77973_b() instanceof ItemSUMCharacterArmor && chest.func_77942_o()) {
                float heightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getHeight(chest);
                if (heightMod != 1.0f) {
                    if (this.renderer == null) {
                        this.renderer = new EntityRendererModifier(minecraft);
                    }
                    if (minecraft.field_71460_t != this.renderer) {
                        this.prevRenderer = minecraft.field_71460_t;
                        minecraft.field_71460_t = this.renderer;
                    }
                    if (heightMod < 1.0f) {
                        float shift = 1.62f * (1.0f - heightMod);
                        this.renderer.setYShift(shift);
                    } else {
                        float shift = -(1.62f * heightMod - 1.62f);
                        this.renderer.setYShift(shift);
                    }
                } else if (this.prevRenderer != null && minecraft.field_71460_t != this.prevRenderer) {
                    if (this.renderer != null) {
                        this.renderer.setYShift(0.0f);
                    }
                    minecraft.field_71460_t = this.prevRenderer;
                }
            } else if (this.prevRenderer != null && minecraft.field_71460_t != this.prevRenderer) {
                if (this.renderer != null) {
                    this.renderer.setYShift(0.0f);
                }
                minecraft.field_71460_t = this.prevRenderer;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = event.entityPlayer;
            SUMCharacter character = SUMHelper.getCharacter(player);
            if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof IStealth) {
                if (player.func_82169_q(2).func_77942_o() && (player.func_82169_q(2).func_77978_p().func_74767_n("Invisible") || player.func_82169_q(2).func_77978_p().func_74767_n("Stealth"))) {
                    event.setCanceled(true);
                } else {
                    event.setCanceled(false);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLiving(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            SUMCharacter character = SUMHelper.getCharacter(player);
            ItemStack chest = player.func_82169_q(2);
            if (chest != null && character instanceof IAnimation) {
                float heightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getHeight(chest);
                if (heightMod != ((IAnimation)character).getDefaultHeight(player) && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v)) {
                    GL11.glPushMatrix();
                    SuperheroesRenderHelper.setLighting(62640);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                }
            } else if (chest != null && character instanceof ISize && chest.func_77942_o() && chest.func_77978_p().func_74760_g("Height") <= 0.5f && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v)) {
                GL11.glPushMatrix();
                SuperheroesRenderHelper.setLighting(62640);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            }
            if (character instanceof IIntangible && chest.func_77942_o() && chest.func_77978_p().func_74767_n("Phasing")) {
                GL11.glPushMatrix();
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            }
            if (character instanceof AntMan && player.field_70154_o instanceof EntityAnt) {
                GL11.glPushMatrix();
                SuperheroesRenderHelper.setLighting(62640);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                if (player != Minecraft.func_71410_x().field_71439_g) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)14.9f, (float)0.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLivingPost(RenderLivingEvent.Post event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            SUMCharacter character = SUMHelper.getCharacter(player);
            ItemStack chest = player.func_82169_q(2);
            if (chest != null && character instanceof IAnimation) {
                float heightMod = ((ItemSUMCharacterArmor)chest.func_77973_b()).getHeight(chest);
                if (heightMod != ((IAnimation)character).getDefaultHeight(player) && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v)) {
                    SuperheroesRenderHelper.resetLighting();
                    GL11.glPopMatrix();
                }
            } else if (chest != null && character instanceof ISize && chest.func_77942_o() && chest.func_77978_p().func_74760_g("Height") <= 0.5f && player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v)) {
                SuperheroesRenderHelper.resetLighting();
                GL11.glPopMatrix();
            }
            if (character instanceof IIntangible && chest.func_77942_o() && chest.func_77978_p().func_74767_n("Phasing")) {
                GL11.glPopMatrix();
            }
            if (character instanceof AntMan && player.field_70154_o instanceof EntityAnt) {
                SuperheroesRenderHelper.resetLighting();
                GL11.glPopMatrix();
                if (player != Minecraft.func_71410_x().field_71439_g) {
                    GL11.glPopMatrix();
                }
            }
        }
    }
}

