/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.handlers;

import com.tihyo.superheroes.client.renders.AbstractRenderLightning;
import com.tihyo.superheroes.client.renders.RenderLightningStream;
import com.tihyo.superheroes.entities.EntityLightningStream;
import com.tihyo.superheroes.management.ILightning;
import com.tihyo.superheroes.management.LightningDataInfo;
import com.tihyo.superheroes.management.LightningStream;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.utils.SUMHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class LightningEventHandler {
    public static HashMap<EntityPlayer, LinkedList<EntityLightningStream>> streamDataMap = new HashMap();
    public static HashMap<EntityPlayer, LinkedList<LightningDataInfo>> lightningDataMap = new HashMap();

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            if (!lightningDataMap.containsKey(player)) {
                lightningDataMap.put(player, new LinkedList());
            } else {
                LinkedList<LightningDataInfo> list = lightningDataMap.get(player);
                for (int i = 0; i < list.size(); ++i) {
                    LightningDataInfo data = list.get(i);
                    data.onUpdate(player, player.field_70170_p);
                }
            }
            SUMCharacter character = SUMHelper.getCharacter(player);
            if (character instanceof ILightning) {
                ItemStack chest = player.func_82169_q(2);
                if (!streamDataMap.containsKey(player)) {
                    streamDataMap.put(player, new LinkedList());
                }
                if (chest != null && chest.func_77942_o() && chest.func_77978_p().func_74764_b("LightningStream") && chest.func_77978_p().func_74762_e("LightningStream") < 5) {
                    EntityLightningStream entity = new EntityLightningStream(player.field_70170_p, player);
                    player.field_70170_p.func_72838_d((Entity)entity);
                    this.addLightningStreamToList(player, entity);
                }
            }
        }
    }

    public static boolean areVec3Equal(Vec3 vec1, Vec3 vec2) {
        if (vec1 == null || vec2 == null) {
            return false;
        }
        return vec1.field_72450_a != vec2.field_72450_a || vec1.field_72448_b != vec2.field_72448_b || vec1.field_72449_c != vec2.field_72449_c;
    }

    public void addLightningStreamToList(EntityPlayer player, EntityLightningStream entity) {
        LinkedList<EntityLightningStream> list = streamDataMap.get(player);
        if (list.size() >= 10) {
            list.remove(0);
            list.add(entity);
        } else {
            list.add(entity);
        }
        streamDataMap.put(player, list);
    }

    public static LinkedList<EntityLightningStream> getLightningFromPlayer(EntityPlayer player) {
        if (streamDataMap.get(player) == null) {
            streamDataMap.put(player, new LinkedList());
        }
        return streamDataMap.get(player);
    }

    public static void addLightningDataToList(EntityPlayer player, LightningDataInfo data) {
        LinkedList<LightningDataInfo> list = LightningEventHandler.getLightningDataFromPlayer(player);
        list.add(data);
        lightningDataMap.put(player, list);
    }

    public static LinkedList<LightningDataInfo> getLightningDataFromPlayer(EntityPlayer player) {
        if (lightningDataMap.get(player) == null) {
            lightningDataMap.put(player, new LinkedList());
        }
        return lightningDataMap.get(player);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.entityPlayer;
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (character instanceof ILightning) {
            LightningStream trail = LightningStream.getType(player);
            trail.getLightningRenderer().renderLightning((EntityLivingBase)player, trail);
            trail.getLightningRenderer().renderFlickering((EntityLivingBase)player, trail);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        if (event.entity instanceof EntityLightningStream) {
            EntityLightningStream entity = (EntityLightningStream)event.entity;
            RenderLightningStream renderer = entity.type.getLightningRenderer();
            if (!((AbstractRenderLightning)renderer).shouldRenderLightningStream(entity, entity.type)) {
                event.setCanceled(true);
                return;
            }
            ((AbstractRenderLightning)renderer).preRenderLightningStream(entity, entity.type);
        }
    }
}

