/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.entities;

import com.tihyo.legends.entities.EntityStand;
import com.tihyo.legends.management.ILightningProperty;
import com.tihyo.superheroes.handlers.LightningEventHandler;
import com.tihyo.superheroes.management.LightningStream;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityLightningStream
extends EntityThrowable
implements IEntityAdditionalSpawnData,
ILightningProperty {
    public EntityPlayer shootingEntity;
    private float damage = 18.0f;
    public LightningStream type;
    public float[] lightningFactor;
    public int progress;

    public EntityLightningStream(World par1World) {
        super(par1World);
        this.field_70155_l = 10.0;
        this.field_70158_ak = true;
    }

    public EntityLightningStream(World par1World, EntityPlayer player) {
        super(par1World, (EntityLivingBase)player);
        this.func_70105_a(0.5f, 0.5f);
        this.shootingEntity = player;
        this.field_70145_X = true;
        this.field_70155_l = 10.0;
        this.field_70158_ak = true;
        if (this.shootingEntity != null) {
            this.type = LightningStream.getType(this.shootingEntity);
        }
        this.lightningFactor = new float[20];
        for (int i = 0; i < this.lightningFactor.length; ++i) {
            this.lightningFactor[i] = this.field_70146_Z.nextFloat();
        }
    }

    public EntityLightningStream(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
        this.field_70155_l = 10.0;
        this.field_70158_ak = true;
    }

    protected float func_70182_d() {
        return 3.0f;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public Vec3 getLightningPosVector(int i) {
        float halfWidth = this.field_70130_N / 2.0f;
        return Vec3.func_72443_a((double)(this.field_70165_t - (double)halfWidth + (double)(this.lightningFactor[i] * this.field_70130_N)), (double)this.field_70163_u, (double)(this.field_70161_v - (double)halfWidth + (double)(this.lightningFactor[10 + i] * this.field_70130_N)));
    }

    protected void func_70184_a(MovingObjectPosition hitPos) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_85052_h() != null) {
                List list2 = this.field_70170_p.func_72839_b((Entity)this.func_85052_h(), this.field_70121_D.func_72314_b(5.0, 5.0, 5.0));
                for (int i1 = 0; i1 < list2.size(); ++i1) {
                    Entity entity1 = (Entity)list2.get(i1);
                    if (!(entity1 instanceof EntityLivingBase) || entity1 instanceof EntityStand) continue;
                    entity1.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.progress++ > 30) {
            this.func_70106_y();
            LinkedList<EntityLightningStream> list = LightningEventHandler.getLightningFromPlayer(this.shootingEntity);
            if (list.contains((Object)this)) {
                list.remove((Object)this);
                LightningEventHandler.streamDataMap.put(this.shootingEntity, list);
            }
            return;
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getPosition(float p_70666_1_) {
        if (p_70666_1_ == 1.0f) {
            return Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        }
        double d0 = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)p_70666_1_;
        double d1 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)p_70666_1_;
        double d2 = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)p_70666_1_;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.shootingEntity != null ? this.shootingEntity.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf buffer) {
        Entity shooter = this.field_70170_p.func_73045_a(buffer.readInt());
        if (shooter instanceof EntityPlayer) {
            this.shootingEntity = (EntityPlayer)shooter;
        }
    }
}

