/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.entities.EntitySpeedsterTrail;
import com.tihyo.superheroes.entities.EntityWebShoot;
import com.tihyo.superheroes.entities.EntityWebShootProj;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.MethodsHandlerSuperheroes;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SUMGameRules;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SpiderMan
implements SUMCharacter {
    public static final ResourceLocation spiderSenseHud = new ResourceLocation("sus", "textures/gui/spidersense.png");
    private int senseTingling = 0;
    public static Item spidermanHelmet;
    public static Item spidermanChest;
    public static Item spidermanLegs;
    public static Item spidermanBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 1;
    private int ability1CoolMaxTime = 20;
    private int ability4MaxTime = 2;
    private int ability4CoolMaxTime = 350;
    private int ability5MaxTime = 1;
    private int ability5CoolMaxTime = 30;
    private String ability1Tag = "WebSlinging";
    private String ability1CooldownTag = "WebSlingingCooldown";
    private String ability4Tag = "SpeedBlitz";
    private String ability4CooldownTag = "SpeedBlitzCooldown";
    private String ability5Tag = "WebNet";
    private String ability5CooldownTag = "WebNetCooldown";

    @Override
    public String getName() {
        return "spiderman";
    }

    @Override
    public String getDisplayName() {
        return "Spider-Man";
    }

    @Override
    public String getAltEgoText() {
        return "Peter Parker";
    }

    @Override
    public String getDefenseText() {
        return "High";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "015";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.highDur, SuitDefenseTypes.high, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 28.0f;
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Climbing", false);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingSpiderMan((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 0;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 20");
        powers.add("Speed: 9 (When Sprinting)");
        powers.add("Acrobatics: 8");
        powers.add("Spider-Sense:");
        powers.add("- Red Tint When Danger Is Nearby");
        powers.add("Negates Fall Damage (Hold Shift To Absorb = No Fall Damage)");
        powers.add("Web-Sling: Suit Ability 1");
        powers.add("- Can Pull Mobs/Items");
        powers.add("- Hold Shift To Break Line");
        powers.add("- Shift On Impact To Break Glass");
        powers.add("Gliding (Homecoming): Suit Ability 2");
        powers.add("Wall Climbing: Hold Suit Ability 3");
        powers.add("Speed Blitz: Suit Ability 4");
        powers.add("- Lasts 10 sec");
        powers.add("Web-Net: Suit Ability 5");
        powers.add("- Can Pull Mobs/Items");
        powers.add("- Hold Shift To Break Line");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList immunities = new ArrayList();
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingSpiderMan((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
            int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability4Cool < this.ability4CoolMaxTime) {
                    ++ability4Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                MethodsHandlerSuperheroes.webSlinging(player);
                ++ability1;
            }
            if (ability4 < this.ability4MaxTime) {
                PowersHandlerSuperheroes.dash(player, 20);
                ++ability4;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.webNet(player);
                ++ability5;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
            itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            PowersHandlerSuperheroes.healthBoost(player, 4);
            PowersHandlerSuperheroes.strength(player, 20);
            PowersHandlerSuperheroes.speed(player, 9, -1);
            PowersHandlerSuperheroes.acrobatics(player, 8);
            PowersHandlerSuperheroes.spiderSense(player);
            PowersHandlerSuperheroes.acrobatics(player, 6);
            List list2 = player.field_70170_p.func_72839_b((Entity)player, player.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
            for (int i1 = 0; i1 < list2.size(); ++i1) {
                Entity entity1 = (Entity)list2.get(i1);
                if (entity1 != null) {
                    if (entity1 instanceof EntityMob) {
                        this.senseTingling = 1;
                        continue;
                    }
                    if (entity1 instanceof EntityThrowable) {
                        if (entity1 instanceof EntityWebShoot || entity1 instanceof EntityWebShootProj || entity1 instanceof EntitySpeedsterTrail) continue;
                        this.senseTingling = 1;
                        continue;
                    }
                    if (entity1 instanceof EntityArrow) {
                        this.senseTingling = 1;
                        continue;
                    }
                    if (entity1 instanceof EntityPotion) {
                        this.senseTingling = 1;
                        continue;
                    }
                    this.senseTingling = 0;
                    continue;
                }
                this.senseTingling = 0;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingSpiderMan((EntityPlayer)player)) {
            if (!hasScreen && this.senseTingling == 1 && SUMGameRules.hud) {
                GL11.glEnable((int)3042);
                GL11.glClearDepth((double)1.0);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3008);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(spiderSenseHud);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), -90.0, 0.0, 1.0);
                tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), -90.0, 1.0, 1.0);
                tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
                tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
            }
        } else {
            return;
        }
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("homecoming");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 42;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) || i != 0) continue;
            altName = "Homecoming";
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        spidermanHelmet = item;
        return spidermanHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        spidermanChest = item;
        return spidermanChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        spidermanLegs = item;
        return spidermanLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        spidermanBoots = item;
        return spidermanBoots;
    }

    @Override
    public Item getHelmetItem() {
        return spidermanHelmet;
    }

    @Override
    public Item getChestItem() {
        return spidermanChest;
    }

    @Override
    public Item getLegsItem() {
        return spidermanLegs;
    }

    @Override
    public Item getBootsItem() {
        return spidermanBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int webSlinging = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int webSlingingCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (webSlingingCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (webSlinging == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int speedBlitz = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int speedBlitzCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (speedBlitzCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (speedBlitz == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int webNet = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int webNetCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (webNetCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (webNet == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 4;
    }
}

