/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.Main;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.management.IAnimation;
import com.tihyo.legends.management.IStealth;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.IBatfamily;
import com.tihyo.superheroes.management.ICombat;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.IUpgradeableSuit;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SUMHelper;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RobinGrayson
implements SUMCharacter,
IBatfamily,
IAnimation,
ISize,
ICombat,
IStealth,
IUpgradeableSuit {
    public static Item robinHelmet;
    public static Item robinChest;
    public static Item robinLegs;
    public static Item robinBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 1;
    private int ability1CoolMaxTime = 10;
    private int ability2MaxTime = 2;
    private int ability2CoolMaxTime = 350;
    private int ability4MaxTime = 200;
    private int ability4CoolMaxTime = 300;
    private String ability1Tag = "UseGadget";
    private String ability1CooldownTag = "UseGadgetCooldown";
    private String ability2Tag = "Dash";
    private String ability2CooldownTag = "DashCooldown";
    private String ability4Tag = "Combat";
    private String ability4CooldownTag = "CombatCooldown";
    private String gadget1Tag = "ThrowingBird";
    private String gadget2Tag = "GasPellet";
    private String gadget3Tag = "FreezeGrenade";
    private String gadget4Tag = "Handlink";

    @Override
    public String getName() {
        return "robin_grayson";
    }

    @Override
    public String getDisplayName() {
        return "Robin (" + this.getAltEgoText() + ")";
    }

    @Override
    public String getAltEgoText() {
        return "Dick Grayson";
    }

    @Override
    public String getDefenseText() {
        return "Low";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "016";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.lowDur, SuitDefenseTypes.low, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 22.0f;
    }

    @Override
    public float getFallResistance() {
        return 7.5f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public float getDefaultHeight(EntityPlayer player) {
        return 0.937f;
    }

    @Override
    public float getStandWidth(SUMCharacter stand) {
        return 0.937f;
    }

    @Override
    public float getStandHeight(SUMCharacter stand) {
        return 0.937f;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Invisible", false);
            itemstack.func_77978_p().func_74757_a("Stealth", false);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74778_a("CurrentGadget", "");
            itemstack.func_77978_p().func_74778_a("Animation", "default");
            itemstack.func_77978_p().func_74776_a("Width", 0.937f);
            itemstack.func_77978_p().func_74776_a("Height", 0.937f);
            itemstack.func_77978_p().func_74776_a("EyeHeight", 0.937f);
            itemstack.func_77978_p().func_74776_a("SizeRatio", 1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        ResourceLocation gadgetsTexture = new ResourceLocation("sus", "textures/gui/batgadgets/gadgetsicon.png");
        int length = 0;
        SUMCharacter character = SUMHelper.getCharacter(player);
        ScaledResolution resolution = new ScaledResolution(gui.minecraft, gui.minecraft.field_71443_c, gui.minecraft.field_71440_d);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int x = width - 23;
        int y = height - 23;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingRobinGrayson((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
                if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget1Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 29, posY - 23, 182, 0, 38, 100);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget2Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 5, posY - 21, 153, 0, 14, 100);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget3Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 5, posY - 21, 167, 0, 14, 100);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget4Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 14, posY - 38, 45, 14, 23, 100);
                }
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/robin/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName().substring(4) + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/robin/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Tights";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return "Robin's (" + altName + ") " + extension;
            }
            return "Robin's (" + this.getAltEgoText() + ") " + extension;
        }
        return "Robin's (" + this.getAltEgoText() + ") " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 10;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 3");
        powers.add("Speed: 2 (When Sprinting)");
        powers.add("Acrobatics: 4");
        powers.add("Stealth");
        powers.add("Negates Fall Damage");
        powers.add("Use Gadget: Suit Ability 1");
        powers.add("Dash: Suit Ability 2");
        powers.add("Crawling: Suit Ability 3");
        powers.add("Combat: Suit Ability 4");
        powers.add("Toggle Gadget: Suit Ability 5");
        powers.add("Staff: Weapons Equip");
        powers.add("N/A: Special Ability");
        powers.add("");
        powers.add("Default Gadgets: (Built-In)");
        powers.add("- Throwing Bird");
        powers.add("- Gas Pellet");
        powers.add("- Freeze Grenade");
        powers.add("- Handlink");
        powers.add("");
        powers.add("Add-On Gadgets: (Must Be Crafted)");
        powers.add("- Smoke Pellets");
        powers.add("- Grappling Gun");
        powers.add("- Explosive Gel Gun");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList immunities = new ArrayList();
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingRobinGrayson((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
            int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability2Cool < this.ability2CoolMaxTime) {
                    ++ability2Cool;
                }
                if (ability4Cool < this.ability4CoolMaxTime) {
                    ++ability4Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                PowersHandlerSuperheroes.robinGadgets(player, world, player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget"));
                ++ability1;
            }
            if (ability2 < this.ability2MaxTime) {
                if (player.func_82169_q(2).func_77942_o() && !player.func_82169_q(2).func_77978_p().func_74779_i("Animation").equals("crawling")) {
                    PowersHandlerSuperheroes.dash(player, 8);
                }
                ++ability2;
            }
            if (ability4 < this.ability4MaxTime) {
                ++ability4;
            }
            if (player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74779_i("Animation").equals("crawling")) {
                player.func_82170_o(Main.speedPotion.field_76415_H);
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
            itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
            if (player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74779_i("Animation").equals("crawling")) {
                PowersHandlerSuperheroes.speed(player, -2, -3);
                PowersHandlerSuperheroes.acrobatics(player, -5);
            } else {
                PowersHandlerSuperheroes.speed(player, 2, -1);
                PowersHandlerSuperheroes.acrobatics(player, 4);
            }
            PowersHandlerSuperheroes.healthBoost(player, 1);
            PowersHandlerSuperheroes.strength(player, 3);
            PowersHandlerSuperheroes.stealth(player, itemStack);
            PowersHandlerSuperheroes.invisChecker(player, itemStack);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList altSuit = new ArrayList();
        if (this.hasAlts()) {
            // empty if block
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 10;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) && i != 0) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        robinHelmet = item;
        return robinHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        robinChest = item;
        return robinChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        robinLegs = item;
        return robinLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        robinBoots = item;
        return robinBoots;
    }

    @Override
    public Item getHelmetItem() {
        return robinHelmet;
    }

    @Override
    public Item getChestItem() {
        return robinChest;
    }

    @Override
    public Item getLegsItem() {
        return robinLegs;
    }

    @Override
    public Item getBootsItem() {
        return robinBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals("")) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget1Tag);
            }
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int useGadget = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int useGadgetCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (useGadgetCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (useGadget == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int dash = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int dashCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (dashCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (dash == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            PowersHandlerSuperheroes.crawling(player, 0.5f);
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int combat = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int combatCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (combatCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (combat == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals("")) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget1Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget1Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget2Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget2Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget3Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget3Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget4Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget4Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget1Tag);
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (!player.field_71071_by.func_146028_b(RegisterItemsSUM.robinStaff)) {
            player.field_71071_by.func_70441_a(new ItemStack(RegisterItemsSUM.robinStaff, 1));
        } else {
            player.field_71071_by.func_146026_a(RegisterItemsSUM.robinStaff);
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 1;
    }
}

