/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.common.SuitInstanceHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.client.SuperheroesRenderHelper;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.IIronMan;
import com.tihyo.superheroes.management.IJarvis;
import com.tihyo.superheroes.management.ILaser;
import com.tihyo.superheroes.management.IRepulsor;
import com.tihyo.superheroes.management.IUtility;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SUMGameRules;
import com.tihyo.superheroes.management.SUMMathHelper;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SUMHelper;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class IronMan
implements SUMCharacter,
IIronMan,
IUtility,
IRepulsor,
ILaser,
IJarvis {
    public static final ResourceLocation hud = new ResourceLocation("sus", "textures/gui/ironman/hud43.png");
    public static final ResourceLocation energy100 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel10.png");
    public static final ResourceLocation energy90 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel09.png");
    public static final ResourceLocation energy80 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel08.png");
    public static final ResourceLocation energy70 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel07.png");
    public static final ResourceLocation energy60 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel06.png");
    public static final ResourceLocation energy50 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel05.png");
    public static final ResourceLocation energy40 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel04.png");
    public static final ResourceLocation energy30 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel03.png");
    public static final ResourceLocation energy20 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel02.png");
    public static final ResourceLocation energy10 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel01.png");
    public static final ResourceLocation energy0 = new ResourceLocation("sus", "textures/gui/ironman/fuel/new/fuel0.png");
    public static final ResourceLocation errorenviro = new ResourceLocation("sus", "textures/gui/ironman/errorenvironment.png");
    public static final ResourceLocation errortemp = new ResourceLocation("sus", "textures/gui/ironman/errortemp.png");
    public static final ResourceLocation vitals = new ResourceLocation("sus", "textures/gui/ironman/vitals.png");
    public static Item ironmanHelmet;
    public static Item ironmanChest;
    public static Item ironmanLegs;
    public static Item ironmanBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 5;
    private int ability1CoolMaxTime = 20;
    private int ability2MaxTime = 10;
    private int ability2CoolMaxTime = 35;
    private int ability3MaxTime = 5;
    private int ability3CoolMaxTime = 100;
    private int ability4MaxTime = 1;
    private int ability4CoolMaxTime = 100;
    private int ability5MaxTime = 100;
    private int ability5CoolMaxTime = 450;
    private double energyMax = 3600.0;
    private double rechargeEnergyMax = 3600.0;
    private String ability1Tag = "Repulsor";
    private String ability1CooldownTag = "RepulsorCooldown";
    private String ability2Tag = "ShoulderGun";
    private String ability2CooldownTag = "ShoulderGunCooldown";
    private String ability3Tag = "Laser";
    private String ability3CooldownTag = "LaserCooldown";
    private String ability4Tag = "Rocket";
    private String ability4CooldownTag = "RocketCooldown";
    private String ability5Tag = "Unibeam";
    private String ability5CooldownTag = "UnibeamCooldown";

    @Override
    public String getName() {
        return "ironman";
    }

    @Override
    public String getDisplayName() {
        return "Iron Man";
    }

    @Override
    public String getAltEgoText() {
        return "Tony Stark";
    }

    @Override
    public String getDefenseText() {
        return "High";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Villain";
    }

    @Override
    public String getSuperDexIndex() {
        return "007";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.highDur, SuitDefenseTypes.high, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 40.0f;
    }

    @Override
    public float getFallResistance() {
        return 0.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public Vec3 getRepulsorColor(EntityPlayer player) {
        return SuperheroesRenderHelper.getColorFromHex("FFA500");
    }

    @Override
    public Vec3 getLaserColor(EntityPlayer player) {
        return SuperheroesRenderHelper.getColorFromHex("ff0000");
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("FlightType3", false);
            itemstack.func_77978_p().func_74757_a("FlightParticles", true);
            itemstack.func_77978_p().func_74757_a("Lights", false);
            itemstack.func_77978_p().func_74768_a("MaskStage", 0);
            itemstack.func_77978_p().func_74757_a("Aim", false);
            itemstack.func_77978_p().func_74757_a("isUnibeam", false);
            itemstack.func_77978_p().func_74757_a("isShoulderGun", false);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74780_a("Energy", this.energyMax);
            itemstack.func_77978_p().func_74780_a("RechargeEnergy", 0.0);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof IronMan && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 9, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_mark43_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Helmet";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Chestplate";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s (Mark 43) " + extension;
        }
        return this.getDisplayName() + "'s (Mark 43) " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 41;
        int defaultArmorModelMask1ID = 43;
        int defaultArmorModelMask2ID = 44;
        int defaultArmorModelMask3ID = 45;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                EntityPlayer player;
                armorModel = entityLiving instanceof EntityPlayer ? ((player = (EntityPlayer)entityLiving).func_82169_q(3) != null && player.func_82169_q(3).func_77973_b().func_77658_a().contains(SuitInstanceHelper.ironman) ? (player.func_82169_q(3).func_77942_o() && player.func_82169_q(3).func_77978_p().func_74764_b("MaskStage") ? (player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") == 1 ? (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelMask1ID) : (player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") == 2 ? (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelMask2ID) : (player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") == 3 ? (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelMask3ID) : (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID)))) : (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID)) : (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID)) : (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 22");
        powers.add("Speed: 4 (When Sprinting)");
        powers.add("Jump Boost: 2");
        powers.add("Minor-Fire Resistance");
        powers.add("Flight: 3 (With Sufficient Energy)");
        powers.add("No Fall Damage");
        powers.add("J.A.R.V.I.S. OS");
        powers.add("Energy Systems: Advanced");
        powers.add("Repulsor Tier 3: Suit Ability 1 (When Aiming)");
        powers.add("Shoulder-Mounted Gun: Suit Ability 2");
        powers.add("Laser: Suit Ability 3 (When Aiming)");
        powers.add("Rocket: Suit Ability 4 (When Aiming)");
        powers.add("Unibeam Tier 3: Suit Ability 5");
        powers.add("Aim: Weapons Equip");
        powers.add("Mask Lift: Utility Ability");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Bullets");
        immunities.add("Arrows");
        immunities.add("Snowballs");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        block33: {
            int stage;
            block34: {
                SUMCharacter character = SUMHelper.getCharacter(player);
                if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof IronMan) {
                    this.setTags(itemStack, player, world);
                    int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
                    int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
                    int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
                    int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
                    int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
                    int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
                    int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
                    int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
                    int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
                    int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
                    double energy = itemStack.func_77978_p().func_74769_h("Energy");
                    double recharge = itemStack.func_77978_p().func_74769_h("RechargeEnergy");
                    boolean lights = itemStack.func_77978_p().func_74767_n("Lights");
                    if (!world.field_72995_K) {
                        if (player.field_70173_aa % 10 == 0) {
                            if (energy >= 1.0) {
                                energy -= 1.0;
                            }
                            if (energy < 0.0) {
                                energy = 0.0;
                                recharge = 0.0;
                            }
                            if (recharge < this.rechargeEnergyMax) {
                                recharge += 50.0;
                            }
                            if (recharge >= this.rechargeEnergyMax) {
                                recharge = this.rechargeEnergyMax;
                            }
                            if (recharge >= this.rechargeEnergyMax && energy < this.energyMax) {
                                energy = energy > 2000.0 ? (energy += 10.0) : (energy += 25.0);
                            }
                        }
                        lights = energy > 0.0;
                        if (ability1Cool < this.ability1CoolMaxTime) {
                            ++ability1Cool;
                        }
                        if (ability2Cool < this.ability2CoolMaxTime) {
                            ++ability2Cool;
                        } else if (player.field_70173_aa % 10 == 0 && player.func_82169_q(2) != null && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74764_b("isShoulderGun")) {
                            player.func_82169_q(2).func_77978_p().func_74757_a("isShoulderGun", false);
                        }
                        if (ability3Cool < this.ability3CoolMaxTime) {
                            ++ability3Cool;
                        }
                        if (ability4Cool < this.ability4CoolMaxTime) {
                            ++ability4Cool;
                        }
                        if (ability5Cool < this.ability5CoolMaxTime) {
                            ++ability5Cool;
                        } else if (player.func_82169_q(2) != null && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74764_b("isUnibeam")) {
                            player.func_82169_q(2).func_77978_p().func_74757_a("isUnibeam", false);
                        }
                    }
                    if (ability1 < this.ability1MaxTime) {
                        PowersHandlerSuperheroes.repulsor(player, 10.0f);
                        ++ability1;
                        if (energy > 1000.0) {
                            energy -= 10.0;
                        }
                    }
                    if (ability2 < this.ability2MaxTime) {
                        PowersHandlerSuperheroes.shoulderGun(player);
                        ++ability2;
                        if (energy > 1000.0) {
                            energy -= 15.0;
                        }
                    }
                    if (ability3 < this.ability3MaxTime) {
                        PowersHandlerSuperheroes.wristLaser(player, 15.0f);
                        ++ability3;
                        if (energy > 1000.0) {
                            energy -= 20.0;
                        }
                    }
                    if (ability4 < this.ability4MaxTime) {
                        PowersHandlerSuperheroes.rocket(player);
                        ++ability4;
                        if (energy > 1000.0) {
                            energy -= 12.0;
                        }
                    }
                    if (ability5 < this.ability5MaxTime) {
                        if (ability5 > 15 && ability5 < 40) {
                            PowersHandlerSuperheroes.unibeam(player, 30.0f);
                            if (energy > 100.0) {
                                energy -= 100.0;
                            }
                        }
                        ++ability5;
                    }
                    if (ability5Cool == 70) {
                        player.field_70170_p.func_72956_a((Entity)player, "sus:unibeampowerdown", 1.0f, 1.0f);
                    }
                    itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
                    itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
                    itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
                    itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
                    itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
                    itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
                    itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
                    itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
                    itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
                    itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
                    itemStack.func_77978_p().func_74780_a("Energy", energy);
                    itemStack.func_77978_p().func_74780_a("RechargeEnergy", recharge);
                    itemStack.func_77978_p().func_74757_a("Lights", lights);
                    PowersHandlerSuperheroes.healthBoost(player, 10, 100);
                    PowersHandlerSuperheroes.strength(player, 22);
                    PowersHandlerSuperheroes.jumpBoost(player, 5);
                    PowersHandlerSuperheroes.speed(player, 4, -1);
                    if (player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 300.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
                        PowersHandlerSuperheroes.flight(player, 3);
                    }
                    PowersHandlerSuperheroes.minorFireResist(player, world);
                    if (player.func_82169_q(3).func_77942_o() && player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") == 0) {
                        PowersHandlerSuperheroes.waterBreathing(player);
                    }
                }
                if (player.func_82169_q(3) == null || !player.func_82169_q(3).func_77973_b().func_77658_a().contains(SuitInstanceHelper.ironman) || !player.func_82169_q(3).func_77942_o() || !player.func_82169_q(3).func_77978_p().func_74764_b("MaskStage") || player.field_70173_aa % 5 != 0) break block33;
                if (player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") == 0 || player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") >= 4) break block34;
                for (stage = 1; stage <= 3; ++stage) {
                    player.func_82169_q(3).func_77978_p().func_74768_a("MaskStage", stage);
                }
                break block33;
            }
            if (player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") < 0 || player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") > 4) break block33;
            for (stage = 3; stage >= 0; --stage) {
                player.func_82169_q(3).func_77978_p().func_74768_a("MaskStage", stage);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        ItemStack helmet = player.func_82169_q(3);
        if (helmet != null && helmet.func_77973_b().func_77658_a().contains(SuitInstanceHelper.ironman) && helmet.func_77942_o()) {
            if (!hasScreen && SUMGameRules.hud && helmet.func_77978_p().func_74764_b("MaskStage") && helmet.func_77978_p().func_74762_e("MaskStage") == 0) {
                GL11.glEnable((int)3042);
                GL11.glClearDepth((double)1.0);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3008);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(hud);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                tessellator.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3042);
                GL11.glClearDepth((double)1.0);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3008);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingIronMan((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74764_b("Energy")) {
                    double energy = player.func_82169_q(2).func_77978_p().func_74769_h("Energy");
                    if (energy >= 3240.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy100);
                    } else if (energy < 3240.0 && energy >= 2880.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy90);
                    } else if (energy < 2880.0 && energy >= 2520.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy80);
                    } else if (energy < 2520.0 && energy >= 2160.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy70);
                    } else if (energy < 2160.0 && energy >= 1800.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy60);
                    } else if (energy < 1800.0 && energy >= 1440.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy50);
                    } else if (energy < 1440.0 && energy >= 1080.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy40);
                    } else if (energy < 1080.0 && energy >= 720.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy30);
                    } else if (energy < 720.0 && energy >= 360.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy20);
                    } else if (energy < 360.0 && energy > 0.0) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy10);
                    } else {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(energy0);
                    }
                    Tessellator tessellator1 = Tessellator.field_78398_a;
                    tessellator1.func_78382_b();
                    tessellator1.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator1.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator1.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                }
                if (SUMMathHelper.isInDeepWater(player)) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(errorenviro);
                    Tessellator tessellator1 = Tessellator.field_78398_a;
                    tessellator1.func_78382_b();
                    tessellator1.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator1.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator1.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                }
                if (SUMMathHelper.altitudeCap(player, 500)) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(errorenviro);
                    Tessellator tessellator1 = Tessellator.field_78398_a;
                    tessellator1.func_78382_b();
                    tessellator1.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator1.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator1.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                }
                if (player.func_110143_aJ() < 4.0f) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(vitals);
                    Tessellator tessellator1 = Tessellator.field_78398_a;
                    tessellator1.func_78382_b();
                    tessellator1.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator1.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator1.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator1.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                }
            }
        } else {
            return;
        }
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList altSuit = new ArrayList();
        if (this.hasAlts()) {
            // empty if block
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 7;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) && i != 0) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        ironmanHelmet = item;
        return ironmanHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        ironmanChest = item;
        return ironmanChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        ironmanLegs = item;
        return ironmanLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        ironmanBoots = item;
        return ironmanBoots;
    }

    @Override
    public Item getHelmetItem() {
        return ironmanHelmet;
    }

    @Override
    public Item getChestItem() {
        return ironmanChest;
    }

    @Override
    public Item getLegsItem() {
        return ironmanLegs;
    }

    @Override
    public Item getBootsItem() {
        return ironmanBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Aim") && player.func_71045_bC() == null && !player.field_82175_bq && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 180.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int repulsor = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int repulsorCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (repulsorCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (repulsor == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                    player.field_70170_p.func_72956_a((Entity)player, "sus:repulsorblast", 2.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 180.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int shoulderGun = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int shoulderGunCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (shoulderGunCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (shoulderGun == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                    player.field_70170_p.func_72956_a((Entity)player, "sus:ironmanmove", 3.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Aim") && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 180.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int laser = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int laserCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (laserCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (laser == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Aim") && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 180.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int rocket = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int rocketCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (rocketCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (rocket == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 1200.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int unibeam = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int unibeamCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (unibeamCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (unibeam == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
                if (unibeam == 100) {
                    player.field_70170_p.func_72956_a((Entity)player, "sus:unibeam", 2.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            if (player.func_82169_q(2).func_77942_o() && !player.func_82169_q(2).func_77978_p().func_74767_n("Aim") && player.func_82169_q(2).func_77978_p().func_74769_h("Energy") > 180.0 && !SUMMathHelper.isInDeepWater(player) && !SUMMathHelper.altitudeCap(player, 500)) {
                PowersHandlerSuperheroes.aim(player, true);
                player.field_70170_p.func_72956_a((Entity)player, "sus:repulsor", 1.0f, 1.0f);
            } else {
                PowersHandlerSuperheroes.aim(player, false);
                player.field_70170_p.func_72956_a((Entity)player, "sus:ironmanpowerdown", 0.5f, 1.0f);
            }
        }
    }

    @Override
    public void utilityAbility(EntityPlayer player) {
        if (player.func_82169_q(3) != null && player.func_82169_q(3).func_77942_o() && player.func_82169_q(3).func_77978_p().func_74764_b("MaskStage")) {
            if (player.func_82169_q(3).func_77978_p().func_74762_e("MaskStage") == 0) {
                player.func_82169_q(3).func_77978_p().func_74768_a("MaskStage", 1);
                player.field_70170_p.func_72956_a((Entity)player, "sus:ironmanhelmetopen", 2.0f, 1.0f);
            } else {
                player.func_82169_q(3).func_77978_p().func_74768_a("MaskStage", 4);
                player.field_70170_p.func_72956_a((Entity)player, "sus:ironmanhelmetclose", 2.0f, 1.0f);
            }
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 5;
    }
}

