/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SUMGameRules;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class Hulk
implements SUMCharacter,
ISize {
    public static final ResourceLocation rage0 = new ResourceLocation("sus", "textures/gui/hulk/rage0.png");
    public static final ResourceLocation rage1 = new ResourceLocation("sus", "textures/gui/hulk/rage1.png");
    public static final ResourceLocation rage2 = new ResourceLocation("sus", "textures/gui/hulk/rage2.png");
    public static final ResourceLocation rage3 = new ResourceLocation("sus", "textures/gui/hulk/rage3.png");
    public static Item hulkHelmet;
    public static Item hulkChest;
    public static Item hulkLegs;
    public static Item hulkBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability2MaxTime = 4;
    private int ability2CoolMaxTime = 200;
    private int ability3MaxTime = 2;
    private int ability3CoolMaxTime = 350;
    private int ability4MaxTime = 4;
    private int ability4CoolMaxTime = 180;
    private int ability5MaxTime = 2;
    private int ability5CoolMaxTime = 40;
    private int rageMax = 1000;
    private String ability2Tag = "HulkSmash";
    private String ability2CooldownTag = "HulkSmashCooldown";
    private String ability3Tag = "Dash";
    private String ability3CooldownTag = "DashCooldown";
    private String ability4Tag = "ThunderClap";
    private String ability4CooldownTag = "ThunderClapCooldown";
    private String ability5Tag = "GroundPound";
    private String ability5CooldownTag = "GroundPoundCooldown";
    private String rage = "Rage";

    @Override
    public String getName() {
        return "hulk";
    }

    @Override
    public String getDisplayName() {
        return "Hulk";
    }

    @Override
    public String getAltEgoText() {
        return "Bruce Banner";
    }

    @Override
    public String getDefenseText() {
        return "Extreme";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "010";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.extremeDur, SuitDefenseTypes.extreme, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 40.0f;
    }

    @Override
    public float getFallResistance() {
        return 0.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public float getStandWidth(SUMCharacter stand) {
        return 1.6f;
    }

    @Override
    public float getStandHeight(SUMCharacter stand) {
        return 1.5f;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74768_a(this.rage, 0);
            itemstack.func_77978_p().func_74776_a("Width", 1.6f);
            itemstack.func_77978_p().func_74776_a("Height", 1.5f);
            itemstack.func_77978_p().func_74776_a("EyeHeight", 1.05f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingHulk((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 18, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Head";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Body";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Legs";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Feet";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 25;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 26 (30 Max Anger)");
        powers.add("Speed: 3 (10 When Sprinting)");
        powers.add("Jump Boost: 6");
        powers.add("Regeneration: 4 (6 Max Anger)");
        powers.add("Knockback");
        powers.add("No Fall Damage");
        powers.add("Rage: Constant fighting raises anger");
        powers.add("Leap: Hold Suit Ability 1 + Space");
        powers.add("Hulk Smash: Suit Ability 2");
        powers.add("Dash: Suit Ability 3");
        powers.add("Thunder Clap: Suit Ability 4");
        powers.add("Ground Pound: Suit Ability 5");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Poison");
        immunities.add("Radiation Poisoning");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingHulk((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
            int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            int rageMeter = itemStack.func_77978_p().func_74762_e(this.rage);
            if (!world.field_72995_K) {
                if (ability2Cool < this.ability2CoolMaxTime) {
                    ++ability2Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
                if (ability4Cool < this.ability4CoolMaxTime) {
                    ++ability4Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability2 < this.ability2MaxTime) {
                PowersHandlerSuperheroes.groundPound(player, 4.5f);
                ++ability2;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.dash(player, 20);
                ++ability3;
            }
            if (ability4 < this.ability4MaxTime) {
                PowersHandlerSuperheroes.thunderClap(player);
                ++ability4;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.groundPound(player, 2.0f);
                ++ability5;
            }
            if (player.field_82175_bq) {
                rageMeter = rageMeter < this.rageMax ? (rageMeter += 2) : this.rageMax;
            } else if (rageMeter > 0) {
                --rageMeter;
            }
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
            itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            itemStack.func_77978_p().func_74768_a(this.rage, rageMeter);
            PowersHandlerSuperheroes.healthBoost(player, 10);
            PowersHandlerSuperheroes.speed(player, 5, 3);
            PowersHandlerSuperheroes.jumpBoost(player, 6);
            PowersHandlerSuperheroes.immuneToPoison(player);
            PowersHandlerSuperheroes.immuneToSuffocation(player);
            if (rageMeter <= 100) {
                PowersHandlerSuperheroes.strength(player, 24);
                PowersHandlerSuperheroes.regeneration(player, 4);
            } else if (rageMeter >= 100 && rageMeter <= 400) {
                PowersHandlerSuperheroes.strength(player, 26);
                PowersHandlerSuperheroes.regeneration(player, 4);
            } else if (rageMeter >= 400 && rageMeter <= 700) {
                PowersHandlerSuperheroes.strength(player, 28);
                PowersHandlerSuperheroes.regeneration(player, 5);
            } else if (rageMeter >= 700) {
                PowersHandlerSuperheroes.strength(player, 30);
                PowersHandlerSuperheroes.regeneration(player, 6);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingHulk((EntityPlayer)player)) {
            int rageMeter = itemstack.func_77978_p().func_74762_e(this.rage);
            if (!hasScreen) {
                if (SUMGameRules.hud && rageMeter <= 100) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(rage0);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                } else if (SUMGameRules.hud && rageMeter >= 100 && rageMeter <= 400) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(rage1);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                } else if (SUMGameRules.hud && rageMeter >= 400 && rageMeter <= 700) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(rage2);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                } else if (SUMGameRules.hud && rageMeter >= 700) {
                    GL11.glEnable((int)3042);
                    GL11.glClearDepth((double)1.0);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(rage3);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), 90.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 90.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, 90.0, 1.0, 0.0);
                    tessellator.func_78374_a(0.0, 0.0, 90.0, 0.0, 0.0);
                    tessellator.func_78381_a();
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                }
            }
        } else {
            return;
        }
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList altSuit = new ArrayList();
        if (this.hasAlts()) {
            // empty if block
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 12;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
            if (i == 0) {
                altName = "New 52";
                continue;
            }
            if (i != 1) continue;
            altName = "SMU";
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        hulkHelmet = item;
        return hulkHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        hulkChest = item;
        return hulkChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        hulkLegs = item;
        return hulkLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        hulkBoots = item;
        return hulkBoots;
    }

    @Override
    public Item getHelmetItem() {
        return hulkHelmet;
    }

    @Override
    public Item getChestItem() {
        return hulkChest;
    }

    @Override
    public Item getLegsItem() {
        return hulkLegs;
    }

    @Override
    public Item getBootsItem() {
        return hulkBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.field_70122_E) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int hulkSmash = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int hulkSmashCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (hulkSmashCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (hulkSmash == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int dash = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int dashCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (dashCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (dash == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int thunderClap = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int thunderClapCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (thunderClapCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (thunderClap == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.field_70122_E) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int groundPound = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int groundPoundCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (groundPoundCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (groundPound == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 5;
    }
}

