/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.management.I3SlotSuit;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.IHeatVision;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GeneralZod
implements SUMCharacter,
I3SlotSuit,
IHeatVision {
    public static Item generalzodChest;
    public static Item generalzodLegs;
    public static Item generalzodBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 4;
    private int ability1CoolMaxTime = 30;
    private int ability2MaxTime = 4;
    private int ability2CoolMaxTime = 200;
    private int ability3MaxTime = 2;
    private int ability3CoolMaxTime = 100;
    private int ability4MaxTime = 4;
    private int ability4CoolMaxTime = 200;
    private int ability5MaxTime = 2;
    private int ability5CoolMaxTime = 40;
    private String ability1Tag = "LaserVision";
    private String ability1CooldownTag = "LaserVisionCooldown";
    private String ability2Tag = "FreezeBreath";
    private String ability2CooldownTag = "FreezeBreathCooldown";
    private String ability3Tag = "SuperBreath";
    private String ability3CooldownTag = "SuperBreathCooldown";
    private String ability4Tag = "XRay";
    private String ability4CooldownTag = "XRayCooldown";
    private String ability5Tag = "GroundPound";
    private String ability5CooldownTag = "GroundPoundCooldown";

    @Override
    public String getName() {
        return "generalzod";
    }

    @Override
    public String getDisplayName() {
        return "General Zod";
    }

    @Override
    public String getAltEgoText() {
        return "Dru-Zod";
    }

    @Override
    public String getDefenseText() {
        return "Extreme";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Villain";
    }

    @Override
    public String getSuperDexIndex() {
        return "040";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.extremeDur, SuitDefenseTypes.extreme, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 40.0f;
    }

    @Override
    public float getFallResistance() {
        return 0.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public Color getHeatVisionColor(EntityPlayer player) {
        return Color.RED;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Flight", false);
            itemstack.func_77978_p().func_74757_a("SlowMo", false);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingGeneralZod((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 5;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 28");
        powers.add("Speed: 6 (20 When Sprinting)");
        powers.add("Jump Boost: 3");
        powers.add("Night-Vision (In Dark Areas)");
        powers.add("Flight: 3");
        powers.add("Regeneration: 3");
        powers.add("Water Breathing");
        powers.add("Fire Resistance");
        powers.add("No Fall Damage");
        powers.add("Water Running (When Sprinting)");
        powers.add("Laser Vision: Suit Ability 1");
        powers.add("Freeze Breath: Suit Ability 2");
        powers.add("Super Breath: Suit Ability 3");
        powers.add("N/A: Suit Ability 4");
        powers.add("Ground Pound: Suit Ability 5");
        powers.add("Heightened Perception: Utility Ability");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Suffocation");
        immunities.add("Poison");
        immunities.add("Hunger");
        immunities.add("Bullets");
        immunities.add("Arrows");
        immunities.add("Snowballs");
        immunities.add("Blindness");
        immunities.add("Smokescreen");
        immunities.add("Can Breathe In Space");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList<String> weaknesses = new ArrayList<String>();
        weaknesses.add("Weaknesses:");
        weaknesses.add("Kryptonite");
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingGeneralZod((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
            int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability2Cool < this.ability2CoolMaxTime) {
                    ++ability2Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
                if (ability4Cool < this.ability4CoolMaxTime) {
                    ++ability4Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                PowersHandlerSuperheroes.laserBeam(player, 0);
                ++ability1;
            }
            if (ability2 < this.ability2MaxTime) {
                PowersHandlerSuperheroes.freezeBreath(player);
                ++ability2;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.superBreath(player);
                ++ability3;
            }
            if (ability4 < this.ability4MaxTime) {
                ++ability4;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.groundPound(player, 2.0f);
                ++ability5;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
            itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            if (PowersHandlerSuperheroes.isWeakToKryptonite(player)) {
                PowersHandlerSuperheroes.healthBoost(player, 10);
                PowersHandlerSuperheroes.strength(player, 30);
                PowersHandlerSuperheroes.speed(player, 20, 6);
                PowersHandlerSuperheroes.jumpBoost(player, 3);
                PowersHandlerSuperheroes.nightVisionInDark(player, world);
                PowersHandlerSuperheroes.flight(player, 4);
                PowersHandlerSuperheroes.regeneration(player, 3);
                PowersHandlerSuperheroes.waterBreathing(player);
                PowersHandlerSuperheroes.fireResistance(player);
                PowersHandlerSuperheroes.laserVisionStatus(player);
                PowersHandlerSuperheroes.freezeBreathStatus(player);
                PowersHandlerSuperheroes.immuneToSuffocation(player);
                PowersHandlerSuperheroes.immuneToPoison(player);
                PowersHandlerSuperheroes.immuneToHunger(player);
                PowersHandlerSuperheroes.immuneToSmokescreen(player);
                int x = (int)Math.floor(player.field_70165_t);
                int y = (int)(player.field_70163_u - player.func_70033_W());
                int z = (int)Math.floor(player.field_70161_v);
                if (player.func_70051_ag() && player.field_70170_p.func_72899_e(x, y - 1, z) && player.field_70170_p.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151586_h && !player.func_70093_af() && player.field_70701_bs > 0.0f) {
                    player.field_70181_x = 0.0;
                    player.field_70122_E = true;
                    if (player.field_70701_bs >= 0.1f && !player.func_70090_H()) {
                        for (int i1 = 0; i1 < 10; ++i1) {
                            player.field_70170_p.func_72869_a("splash", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, 0.0, 0.0, 0.0);
                        }
                    }
                }
            } else {
                PowersHandlerSuperheroes.healthBoost(player, 10);
                PowersHandlerSuperheroes.regeneration(player, 1);
                PowersHandlerSuperheroes.strength(player, 10);
                PowersHandlerSuperheroes.speed(player, 3, 3);
            }
            PowersHandlerSuperheroes.canSurviveInSpace(player);
        }
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList altSuit = new ArrayList();
        if (this.hasAlts()) {
            // empty if block
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts()) {
            // empty if block
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        return null;
    }

    @Override
    public Item setChestItem(Item item) {
        generalzodChest = item;
        return generalzodChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        generalzodLegs = item;
        return generalzodLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        generalzodBoots = item;
        return generalzodBoots;
    }

    @Override
    public Item getHelmetItem() {
        return null;
    }

    @Override
    public Item getChestItem() {
        return generalzodChest;
    }

    @Override
    public Item getLegsItem() {
        return generalzodLegs;
    }

    @Override
    public Item getBootsItem() {
        return generalzodBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (player.func_82169_q(3) == null && SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && PowersHandlerSuperheroes.isWeakToKryptonite(player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int laserVision = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int laserVisionCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (laserVisionCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (laserVision == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (player.func_82169_q(3) == null && SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && PowersHandlerSuperheroes.isWeakToKryptonite(player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int freezeBreath = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int freezeBreathCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (freezeBreathCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (freezeBreath == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (player.func_82169_q(3) == null && SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && PowersHandlerSuperheroes.isWeakToKryptonite(player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int superBreath = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int superBreathCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (superBreathCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (superBreath == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (player.func_82169_q(3) == null && SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && PowersHandlerSuperheroes.isWeakToKryptonite(player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int xrRay = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int xrRayCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (xrRayCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (xrRay == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (player.func_82169_q(3) == null && SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && player.field_70122_E && PowersHandlerSuperheroes.isWeakToKryptonite(player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int groundPound = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int groundPoundCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (groundPoundCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (groundPound == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 5;
    }
}

