/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.management.IAnimation;
import com.tihyo.legends.management.IStealth;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ICombat;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SUMHelper;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Catwoman
implements SUMCharacter,
IAnimation,
ISize,
ICombat,
IStealth {
    public static Item catwomanHelmet;
    public static Item catwomanChest;
    public static Item catwomanLegs;
    public static Item catwomanBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability2MaxTime = 200;
    private int ability2CoolMaxTime = 300;
    private String ability2Tag = "Combat";
    private String ability2CooldownTag = "CombatCooldown";

    @Override
    public String getName() {
        return "catwoman";
    }

    @Override
    public String getDisplayName() {
        return "Catwoman";
    }

    @Override
    public String getAltEgoText() {
        return "Selina Kyle";
    }

    @Override
    public String getDefenseText() {
        return "Low";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Villain";
    }

    @Override
    public String getSuperDexIndex() {
        return "042";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.lowDur, SuitDefenseTypes.low, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 22.0f;
    }

    @Override
    public float getFallResistance() {
        return 7.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public float getDefaultHeight(EntityPlayer player) {
        return 0.91f;
    }

    @Override
    public float getStandWidth(SUMCharacter stand) {
        return 0.89f;
    }

    @Override
    public float getStandHeight(SUMCharacter stand) {
        return 0.91f;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Invisible", false);
            itemstack.func_77978_p().func_74757_a("Stealth", false);
            itemstack.func_77978_p().func_74757_a("Block", false);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74778_a("Animation", "default");
            itemstack.func_77978_p().func_74776_a("Width", 0.89f);
            itemstack.func_77978_p().func_74776_a("Height", 0.91f);
            itemstack.func_77978_p().func_74776_a("EyeHeight", 0.91f);
            itemstack.func_77978_p().func_74776_a("SizeRatio", 1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof Catwoman && player.func_82169_q(2).func_77942_o()) {
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 24, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 14;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 8");
        powers.add("Speed: 5 (When Sprinting)");
        powers.add("Acrobatics: 4");
        powers.add("Stealth");
        powers.add("Negates Fall Damage");
        powers.add("Claws: Suit Ability 1");
        powers.add("- Can Cause Bleeding");
        powers.add("Combat: Suit Ability 2");
        powers.add("Crawling: Suit Ability 3");
        powers.add("Whip: Weapons Equip");
        powers.add("- Can Pull Items");
        powers.add("- Crack Upward While Running To Swing");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList immunities = new ArrayList();
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof Catwoman) {
            this.setTags(itemStack, player, world);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (!world.field_72995_K && ability2Cool < this.ability2CoolMaxTime) {
                ++ability2Cool;
            }
            if (ability2 < this.ability2MaxTime) {
                ++ability2;
            }
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            PowersHandlerSuperheroes.healthBoost(player, 1);
            PowersHandlerSuperheroes.strength(player, 8);
            if (player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74779_i("Animation").equals("crawling")) {
                PowersHandlerSuperheroes.speed(player, -2, -3);
                PowersHandlerSuperheroes.acrobatics(player, -5);
            } else {
                PowersHandlerSuperheroes.speed(player, 5, -1);
                PowersHandlerSuperheroes.acrobatics(player, 4);
            }
            PowersHandlerSuperheroes.stealth(player, itemStack);
            PowersHandlerSuperheroes.invisChecker(player, itemStack);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList altSuit = new ArrayList();
        if (this.hasAlts()) {
            // empty if block
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 12;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) && i != 0) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        catwomanHelmet = item;
        return catwomanHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        catwomanChest = item;
        return catwomanChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        catwomanLegs = item;
        return catwomanLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        catwomanBoots = item;
        return catwomanBoots;
    }

    @Override
    public Item getHelmetItem() {
        return catwomanHelmet;
    }

    @Override
    public Item getChestItem() {
        return catwomanChest;
    }

    @Override
    public Item getLegsItem() {
        return catwomanLegs;
    }

    @Override
    public Item getBootsItem() {
        return catwomanBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int combat = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int combatCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (combatCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (combat == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            PowersHandlerSuperheroes.crawling(player, 0.5f);
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (!player.field_71071_by.func_146028_b(RegisterItemsSUM.catwomanWhip)) {
            player.field_71071_by.func_70441_a(new ItemStack(RegisterItemsSUM.catwomanWhip, 1));
        } else {
            player.field_71071_by.func_146026_a(RegisterItemsSUM.catwomanWhip);
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 1;
    }
}

