/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SUMHelper;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AntMan
implements SUMCharacter,
ISize {
    boolean giantMan = false;
    public static Item antmanHelmet;
    public static Item antmanChest;
    public static Item antmanLegs;
    public static Item antmanBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability3MaxTime = 25;
    private int ability3CoolMaxTime = 150;
    private String ability3Tag = "SummonAnts";
    private String ability3CooldownTag = "SummonAntsCooldown";

    @Override
    public String getName() {
        return "antman";
    }

    @Override
    public String getDisplayName() {
        return "Ant-Man";
    }

    @Override
    public String getAltEgoText() {
        return "Hank Pym";
    }

    @Override
    public String getDefenseText() {
        return "Medium";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "011";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.mediumDur, SuitDefenseTypes.medium, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 28.0f;
    }

    @Override
    public float getFallResistance() {
        return 5.0f;
    }

    @Override
    public float getStandWidth(SUMCharacter stand) {
        return 1.0f;
    }

    @Override
    public float getStandHeight(SUMCharacter stand) {
        return 1.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74776_a("Width", 1.0f);
            itemstack.func_77978_p().func_74776_a("Height", 1.0f);
            itemstack.func_77978_p().func_74776_a("EyeHeight", 1.0f);
            itemstack.func_77978_p().func_74776_a("SizeRatio", 1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingAntMan((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        String giantManTexture = "";
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (itemStack.func_77942_o()) {
            this.giantMan = itemStack.func_77978_p().func_74760_g("SizeRatio") > 1.0f;
            giantManTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_giantman_" + layer + ".png";
        }
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    if (this.giantMan) {
                        return giantManTexture;
                    }
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    if (this.giantMan) {
                        return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_giantman_" + layer + ".png";
                    }
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            if (this.giantMan) {
                return giantManTexture;
            }
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (itemStack.func_77942_o()) {
            this.giantMan = itemStack.func_77978_p().func_74760_g("SizeRatio") > 1.0f;
        }
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Head";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Legs";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            if (this.giantMan) {
                return "Giant-Man's " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        if (this.giantMan) {
            return "Giant-Man's " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        if (itemStack.func_77942_o()) {
            this.giantMan = itemStack.func_77978_p().func_74760_g("SizeRatio") > 1.0f;
        }
        int defaultArmorModelID = 18;
        int giantManArmorModelID = 19;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = this.giantMan ? (ModelPlayer)ClientProxy.getArmorModel(giantManArmorModelID) : (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = this.giantMan ? (ModelPlayer)ClientProxy.getArmorModel(this.getGiantManArmorModelID(i)) : (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = this.giantMan ? (ModelPlayer)ClientProxy.getArmorModel(giantManArmorModelID) : (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 8 (10 When Shrunk)");
        powers.add("Speed: 2 (When Sprinting)");
        powers.add("Jump Boost: 1");
        powers.add("Negates Fall Damage");
        powers.add("Leap: Suit Ability 1 (When Shrunk)");
        powers.add("Ant-Selection: Suit Ability 2");
        powers.add("Summon Ants: Suit Ability 3");
        powers.add("Size Reduction: Suit Ability 4");
        powers.add("Size Enhancement: Suit Ability 5");
        powers.add("N/A: Special Ability");
        powers.add("");
        powers.add("Giant-Man: (Must Have 2 Pym Particles To Transform)");
        powers.add("Health: 28");
        powers.add("Attack Damage: 20");
        powers.add("Slowness: 1");
        powers.add("Jump Boost: 5");
        powers.add("Regeneration: 2");
        powers.add("No Fall Damage");
        powers.add("Ant-Selection: Suit Ability 2");
        powers.add("Summon Ants: Suit Ability 3");
        powers.add("Size Reduction: Suit Ability 4");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Suffocation (When Shrunk)");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof AntMan) {
            this.setTags(itemStack, player, world);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            float size = itemStack.func_77978_p().func_74760_g("SizeRatio");
            if (!world.field_72995_K && ability3Cool < this.ability3CoolMaxTime) {
                ++ability3Cool;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.spawnAnt(player);
                ++ability3;
            }
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            PowersHandlerSuperheroes.healthBoost(player, 4);
            if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74760_g("SizeRatio") == 0.1f) {
                PowersHandlerSuperheroes.strength(player, 10);
                PowersHandlerSuperheroes.speed(player, 2, -1);
                PowersHandlerSuperheroes.immuneToSuffocation(player);
            } else if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74760_g("SizeRatio") == 5.0f) {
                player.field_70143_R = 0.0f;
                PowersHandlerSuperheroes.strength(player, 20);
                PowersHandlerSuperheroes.jumpBoost(player, 5);
                PowersHandlerSuperheroes.speed(player, -1, -1);
                PowersHandlerSuperheroes.regeneration(player, 2);
            } else {
                PowersHandlerSuperheroes.strength(player, 8);
                PowersHandlerSuperheroes.jumpBoost(player, 1);
                PowersHandlerSuperheroes.speed(player, 2, -1);
            }
            PowersHandlerSuperheroes.sizeReduction(player);
            PowersHandlerSuperheroes.sizeEnhancement(player);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return true;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("civilwar");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 40;
        }
        return modelID;
    }

    public int getGiantManArmorModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 40;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) || i != 0) continue;
            altName = "Civil War";
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        antmanHelmet = item;
        return antmanHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        antmanChest = item;
        return antmanChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        antmanLegs = item;
        return antmanLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        antmanBoots = item;
        return antmanBoots;
    }

    @Override
    public Item getHelmetItem() {
        return antmanHelmet;
    }

    @Override
    public Item getChestItem() {
        return antmanChest;
    }

    @Override
    public Item getLegsItem() {
        return antmanLegs;
    }

    @Override
    public Item getBootsItem() {
        return antmanBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int summonAnts = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int summonAntsCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (summonAntsCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (summonAnts == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74760_g("SizeRatio") != 5.0f) {
            PowersHandlerSuperheroes.sizeManipulationFull(player, 0.1f);
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74760_g("SizeRatio") != 0.1f) {
            if (player.field_71071_by.func_146028_b(RegisterItemsSUM.pymParticle)) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack == null || !stack.func_77973_b().equals(RegisterItemsSUM.pymParticle)) continue;
                    if (stack.field_77994_a >= 2 && player.func_82169_q(2).func_77978_p().func_74760_g("SizeRatio") != 5.0f) {
                        PowersHandlerSuperheroes.sizeManipulationFull(player, 5.0f);
                        player.field_70170_p.func_72956_a((Entity)player, "sus:grow", 2.0f, 1.0f);
                        for (int i1 = 0; i1 < 2; ++i1) {
                            player.field_71071_by.func_146026_a(RegisterItemsSUM.pymParticle);
                        }
                        continue;
                    }
                    if (player.func_82169_q(2).func_77978_p().func_74760_g("SizeRatio") != 5.0f) {
                        ChatComponentText versionWarningChatComponent = new ChatComponentText("\u00a7cYou need 2 Pym Particles to grow...");
                        player.func_145747_a((IChatComponent)versionWarningChatComponent);
                        continue;
                    }
                    PowersHandlerSuperheroes.sizeManipulationFull(player, 5.0f);
                }
            } else if (player.func_82169_q(2).func_77978_p().func_74760_g("SizeRatio") == 5.0f) {
                PowersHandlerSuperheroes.sizeManipulationFull(player, 5.0f);
            } else {
                ChatComponentText versionWarningChatComponent = new ChatComponentText("\u00a7cYou need 2 Pym Particles to grow...");
                player.func_145747_a((IChatComponent)versionWarningChatComponent);
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 4;
    }
}

