/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.management;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tihyo.superheroes.armors.ItemSUMCharacterArmor;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.util.EnumHelper;

public class SUMCharacterManager {
    private List<SUMCharacter> allCharacters = Lists.newArrayList();
    public final BiMap<SuitInfo, SUMCharacter> characters = HashBiMap.create();
    private final Map<String, SUMCharacter> characterNames = Maps.newHashMap();
    private List<String> allAltSuits = Lists.newArrayList();
    private boolean initialized;

    public void createCharacter(SUMCharacter character) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Attempted to register suit after startup!");
        Preconditions.checkNotNull((Object)character, (Object)"character");
        this.allCharacters.add(character);
        this.characterNames.put(character.getName().toLowerCase(), character);
        SuitInfo suitInfo = new SuitInfo(character.getSuitInfo().durability, character.getSuitInfo().reductionAmounts, character.getSuitInfo().enchantability);
        this.characters.put((Object)suitInfo, (Object)character);
        this.generateSuit(character, 4);
        if (character.hasAlts()) {
            for (int i = 0; i < character.getAltSuits().size(); ++i) {
                this.generateAltSuit(character, 4, character.getAltSuits().get(i).toString());
            }
        }
    }

    public void createCharacter3Slots(SUMCharacter character) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Attempted to register suit after startup!");
        Preconditions.checkNotNull((Object)character, (Object)"character");
        this.allCharacters.add(character);
        this.characterNames.put(character.getName().toLowerCase(), character);
        SuitInfo suitInfo = new SuitInfo(character.getSuitInfo().durability, character.getSuitInfo().reductionAmounts, character.getSuitInfo().enchantability);
        this.characters.put((Object)suitInfo, (Object)character);
        this.generateSuit(character, 3);
        if (character.hasAlts()) {
            for (int i = 0; i < character.getAltSuits().size(); ++i) {
                this.generateAltSuit(character, 3, character.getAltSuits().get(i).toString());
            }
        }
    }

    private void generateSuit(SUMCharacter character, int numOfSlots) {
        String name = character.getName();
        SuitInfo suitData = character.getSuitInfo();
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)name, (int)suitData.durability, (int[])suitData.reductionAmounts, (int)suitData.enchantability);
        if (numOfSlots >= 4) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.HELMET, character), character, ArmorType.HELMET, character.getCreativeTab());
        }
        if (numOfSlots >= 3) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.CHESTPLATE, character), character, ArmorType.CHESTPLATE, character.getCreativeTab());
        }
        if (numOfSlots >= 2) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.LEGGINGS, character), character, ArmorType.LEGGINGS, character.getCreativeTab());
        }
        if (numOfSlots >= 1) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.BOOTS, character), character, ArmorType.BOOTS, character.getCreativeTab());
        }
    }

    private void generateAltSuit(SUMCharacter character, int numOfSlots, String altName) {
        String name = character.getName();
        SuitInfo suitData = character.getSuitInfo();
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)name, (int)suitData.durability, (int[])suitData.reductionAmounts, (int)suitData.enchantability);
        if (numOfSlots >= 4) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.HELMET, character), character, altName, ArmorType.HELMET, SUMCreativeTabs.suitsAltTab);
        }
        if (numOfSlots >= 3) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.CHESTPLATE, character), character, altName, ArmorType.CHESTPLATE, SUMCreativeTabs.suitsAltTab);
        }
        if (numOfSlots >= 2) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.LEGGINGS, character), character, altName, ArmorType.LEGGINGS, SUMCreativeTabs.suitsAltTab);
        }
        if (numOfSlots >= 1) {
            this.newArmorItem(new ItemSUMCharacterArmor(armorMaterial, ArmorType.BOOTS, character), character, altName, ArmorType.BOOTS, SUMCreativeTabs.suitsAltTab);
        }
    }

    private <ArmorSuit extends Item> void newArmorItem(ArmorSuit i, SUMCharacter character, ArmorType armorType, CreativeTabs creativeTab) {
        i.func_111206_d(SUMCharacterManager.getTextureName(character.getName() + "/" + character.getName()) + "_" + armorType.name);
        String n = character.getName() + "." + armorType.name;
        i.func_77655_b("sum." + n);
        if (armorType.equals(ArmorType.HELMET)) {
            character.setHelmetItem(i);
        }
        if (armorType.equals(ArmorType.CHESTPLATE)) {
            character.setChestItem(i);
        }
        if (armorType.equals(ArmorType.LEGGINGS)) {
            character.setLegsItem(i);
        }
        if (armorType.equals(ArmorType.BOOTS)) {
            character.setBootsItem(i);
        }
        i.func_77637_a(creativeTab);
        GameRegistry.registerItem(i, (String)n);
    }

    private <ArmorSuit extends Item> void newArmorItem(ArmorSuit i, SUMCharacter character, String altName, ArmorType armorType, CreativeTabs creativeTab) {
        i.func_111206_d(SUMCharacterManager.getTextureName(character.getName() + "/" + character.getName()) + "_" + altName + "_" + armorType.name);
        String n = character.getName() + "." + altName + "." + armorType.name;
        i.func_77655_b("sum." + n);
        i.func_77637_a(creativeTab);
        character.setAltSuitsItem(i);
        GameRegistry.registerItem(i, (String)n);
    }

    public static String getTextureName(String name) {
        return "sus:" + name;
    }

    public List<SUMCharacter> getAllCharacters() {
        return this.allCharacters;
    }

    public static SUMCharacter getCharacterReference(SUMCharacter character) {
        return character;
    }
}

