/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.management;

import com.tihyo.superheroes.client.SuperheroesRenderHelper;
import com.tihyo.superheroes.client.renders.RenderLightningStream;
import com.tihyo.superheroes.management.ILightning;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.utils.SUMHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;

public class LightningStream {
    public static LightningStream blue = new LightningStream("blue").setLightningColor("0000FF").setBlurColor("0000FF").setAlphaBlurColor(0.0f);
    public final String name;
    public Vec3 lightningColor;
    public String lightningColorHex;
    public Vec3 blurColor;
    public String blurColorHex;
    public float alphaBlur;

    public LightningStream(String name) {
        this.name = name;
    }

    public LightningStream setLightningColor(String hex) {
        this.lightningColorHex = hex;
        return this.setLightningColorClient(hex);
    }

    protected LightningStream setLightningColorClient(String hex) {
        this.lightningColor = SuperheroesRenderHelper.getColorFromHex(hex);
        return this;
    }

    public Vec3 getLightningColor() {
        return this.lightningColor;
    }

    public LightningStream setBlurColor(String hex) {
        this.blurColorHex = hex;
        return this.setBlurColorClient(hex);
    }

    protected LightningStream setBlurColorClient(String hex) {
        this.blurColor = SuperheroesRenderHelper.getColorFromHex(hex);
        return this;
    }

    public LightningStream setAlphaBlurColor(float blur) {
        this.alphaBlur = blur;
        return this;
    }

    public Vec3 getBlurColor() {
        return this.blurColor;
    }

    public float getAlphaBlurColor() {
        return this.alphaBlur;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderLightningStream getLightningRenderer() {
        return new RenderLightningStream();
    }

    public static LightningStream getType(EntityPlayer player) {
        SUMCharacter character;
        if (player != null && (character = SUMHelper.getCharacter(player)) != null) {
            return ((ILightning)((Object)character)).getLightningColor(player);
        }
        return blue;
    }
}

