/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.client;

import com.tihyo.legends.handlers.LegendsEventHandler;
import com.tihyo.superheroes.handlers.dc.SpeedForceEventHandler;
import com.tihyo.superheroes.management.Lightning;
import com.tihyo.superheroes.management.trail.SpeedForceLightning;
import com.tihyo.superheroes.management.trail.SpeedForceLightningDataInfo;
import com.tihyo.superheroes.management.trail.SpeedsterTrail;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class SuperheroesRenderHelper {
    private static Minecraft mc;
    private static float lastBrightnessX;
    private static float lastBrightnessY;

    public static float median(double current, double prev) {
        return (float)(prev + (current - prev) * (double)LegendsEventHandler.renderTick);
    }

    public static void setLighting(int lighting) {
        SuperheroesRenderHelper.storeLighting();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(lighting % 65536) / 255.0f), (float)((float)(lighting / 65536) / 255.0f));
    }

    public static void storeLighting() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
    }

    public static void resetLighting() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void drawLightning(Vec3 start, Vec3 end, float lineWidth, float innerLineWidth, Vec3 trailColor, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float prevWidth = GL11.glGetFloat((int)2849);
        if (lineWidth > 0.0f) {
            GL11.glLineWidth((float)lineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a((float)trailColor.field_72450_a, (float)trailColor.field_72448_b, (float)trailColor.field_72449_c, alpha);
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
        if (innerLineWidth > 0.0f) {
            GL11.glLineWidth((float)innerLineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, MathHelper.func_76131_a((float)(alpha - 0.2f), (float)0.0f, (float)1.0f));
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
        GL11.glLineWidth((float)prevWidth);
    }

    public static void drawLightningNoInner(Vec3 start, Vec3 end, float lineWidth, Vec3 trailColor, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float prevWidth = GL11.glGetFloat((int)2849);
        if (lineWidth > 0.0f) {
            GL11.glLineWidth((float)lineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a((float)trailColor.field_72450_a, (float)trailColor.field_72448_b, (float)trailColor.field_72449_c, alpha);
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
        GL11.glLineWidth((float)prevWidth);
    }

    public static void renderLightning(EntityPlayer player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            Random rand = new Random();
            for (int i = 0; i < 2; ++i) {
                double d0 = rand.nextFloat() * 2.0f - 1.0f;
                double d1 = rand.nextFloat() * 2.0f - 1.0f;
                double d2 = rand.nextFloat() * 2.0f - 1.0f;
                double d3 = d0 * (double)player.field_70130_N / 2.0;
                double d4 = player.field_70131_O - 1.6f * rand.nextFloat();
                double d5 = d2 * (double)player.field_70130_N / 4.0;
                SpeedForceLightning lightning = SuperheroesRenderHelper.createLightning(SpeedsterTrail.getTrailType(player), 0L, 0.1f).setScale(5.0f);
                SpeedForceEventHandler.addLightningDataToList(player, new SpeedForceLightningDataInfo(lightning, d3, d4, d5));
            }
        } else {
            Random rand = new Random();
            for (int i = 0; i < 2; ++i) {
                double d0 = rand.nextFloat() * 2.0f - 1.0f;
                double d1 = rand.nextFloat() * 2.0f - 1.0f;
                double d2 = rand.nextFloat() * 2.0f - 1.0f;
                double d3 = d0 * 1.0 / 2.0;
                double d4 = player.field_70131_O - 1.6f * rand.nextFloat();
                double d5 = d2 * 1.6 / 4.0;
                SpeedForceLightning lightning = SuperheroesRenderHelper.createLightning(SpeedsterTrail.getTrailType(player), 0L, 0.1f).setScale(5.0f);
                SpeedForceEventHandler.addLightningDataToList(player, new SpeedForceLightningDataInfo(lightning, d3, d4, d5));
            }
        }
    }

    public static SpeedForceLightning createLightning(SpeedsterTrail trail, long seed, float length) {
        Random rand = new Random();
        if (seed != 0L) {
            rand.setSeed(seed);
        }
        SpeedForceLightning lightning = new SpeedForceLightning(rand.nextFloat() * length, trail).setRotation(rand.nextFloat() * 180.0f, rand.nextFloat() * 180.0f, rand.nextFloat() * 180.0f);
        SuperheroesRenderHelper.childLightning(lightning, rand, length, 0);
        return lightning;
    }

    private static void childLightning(SpeedForceLightning lightning, Random rand, float length, int branch) {
        SpeedForceLightning lightning1 = new SpeedForceLightning(rand.nextFloat() * length).setRotation(rand.nextFloat() * rand.nextFloat() * 90.0f, rand.nextFloat() * rand.nextFloat() * 90.0f, rand.nextFloat() * rand.nextFloat() * 90.0f);
        lightning.addChild(lightning1);
        if (branch < 10 && rand.nextDouble() < 1.0 - (double)branch * 0.1) {
            SuperheroesRenderHelper.childLightning(lightning1, rand, length, ++branch);
        }
        if (rand.nextDouble() < 0.1) {
            SuperheroesRenderHelper.childLightning(lightning, rand, length, 7);
        }
    }

    public static void setupRenderLightning() {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDepthMask((boolean)false);
        SuperheroesRenderHelper.setLighting(61680);
    }

    public static void finishRenderLightning() {
        SuperheroesRenderHelper.resetLighting();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void renderLightning(SpeedForceLightning lightning, float opacity) {
        if (lightning.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (lightning.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (lightning.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        SuperheroesRenderHelper.drawLightning(Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)lightning.length, (double)0.0), 5.0f, 1.0f, lightning.lightningType.getTrailColor(), opacity);
        GL11.glTranslatef((float)0.0f, (float)lightning.length, (float)0.0f);
        for (SpeedForceLightning lightning1 : lightning.children) {
            GL11.glPushMatrix();
            SuperheroesRenderHelper.renderLightning(lightning1, opacity);
            GL11.glPopMatrix();
        }
    }

    public static void renderLightningStream(Lightning lightning, float opacity) {
        if (lightning.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (lightning.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (lightning.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        SuperheroesRenderHelper.drawLightning(Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)lightning.length, (double)0.0), 5.0f, 1.0f, lightning.lightningType.getLightningColor(), opacity);
        GL11.glTranslatef((float)0.0f, (float)lightning.length, (float)0.0f);
        for (Lightning lightning1 : lightning.children) {
            GL11.glPushMatrix();
            SuperheroesRenderHelper.renderLightningStream(lightning1, opacity);
            GL11.glPopMatrix();
        }
    }

    public static Vec3 getColorFromHex(String hex) {
        int color = (int)Long.parseLong(hex, 16);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        return Vec3.func_72443_a((double)r, (double)g, (double)b);
    }

    public static void faceVec(Vec3 src, Vec3 dst) {
        double d0 = dst.field_72450_a - src.field_72450_a;
        double d1 = dst.field_72448_b - src.field_72448_b;
        double d2 = dst.field_72449_c - src.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float yaw = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        GL11.glRotated((double)(-yaw), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)1.0, (double)0.0, (double)0.0);
    }
}

