/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Wolverine
implements SUMCharacter,
ISize {
    public static Item wolverineHelmet;
    public static Item wolverineChest;
    public static Item wolverineLegs;
    public static Item wolverineBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability2MaxTime = 2;
    private int ability2CoolMaxTime = 350;
    private int ability3MaxTime = 2;
    private int ability3CoolMaxTime = 50;
    private String ability2Tag = "Dash";
    private String ability2CooldownTag = "DashCooldown";
    private String ability3Tag = "ScentTracker";
    private String ability3CooldownTag = "ScentTrackerCooldown";

    @Override
    public String getName() {
        return "wolverine";
    }

    @Override
    public String getDisplayName() {
        return "Wolverine";
    }

    @Override
    public String getAltEgoText() {
        return "James (Logan) Howlett";
    }

    @Override
    public String getDefenseText() {
        return "Extreme";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "026";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.extremeDur, SuitDefenseTypes.extreme, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 28.0f;
    }

    @Override
    public float getFallResistance() {
        return 8.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public float getStandWidth(SUMCharacter stand) {
        return 0.95f;
    }

    @Override
    public float getStandHeight(SUMCharacter stand) {
        return 0.9f;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Claws", false);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74776_a("Width", 0.95f);
            itemstack.func_77978_p().func_74776_a("Height", 0.9f);
            itemstack.func_77978_p().func_74776_a("EyeHeight", 0.9f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingWolverine((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 9, 6, 3, length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (!itemStack.func_77942_o()) return defaultTexture;
        boolean claws = itemStack.func_77978_p().func_74767_n("Claws");
        String clawsTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_claws_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack == null) return null;
            if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                return defaultTexture;
            }
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                if (!claws) return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_claws_" + layer + ".png";
            }
            return null;
        } else {
            if (!claws) return defaultTexture;
            return clawsTexture;
        }
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 16;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 12 (17 w/Claws)");
        powers.add("Speed: 7 (When Sprinting)");
        powers.add("Acrobatics: 3");
        powers.add("Regeneration: 4");
        powers.add("Night-Vision (In Dark Areas)");
        powers.add("Negates Fall Damage");
        powers.add("Claws: Suit Ability 1");
        powers.add("- Can Cause Bleeding");
        powers.add("- Hold Shift + Punch And Press Forward Key To Climb");
        powers.add("Dash: Suit Ability 2");
        powers.add("Scent Tracker: Suit Ability 3");
        powers.add("- Tracks players and mobs");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Poison");
        immunities.add("Nausea");
        immunities.add("Wither");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList<String> weaknesses = new ArrayList<String>();
        weaknesses.add("Weaknesses:");
        weaknesses.add("Drowning");
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingWolverine((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (!world.field_72995_K) {
                if (ability2Cool < this.ability2CoolMaxTime) {
                    ++ability2Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
            }
            if (ability2 < this.ability2MaxTime) {
                PowersHandlerSuperheroes.dash(player, 15);
                ++ability2;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.scentTracker(player);
                ++ability3;
            }
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            PowersHandlerSuperheroes.healthBoost(player, 4);
            if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("Claws")) {
                PowersHandlerSuperheroes.strength(player, 17);
            } else {
                PowersHandlerSuperheroes.strength(player, 12);
            }
            if (PowersHandlerSuperheroes.isWeakToWater(player)) {
                PowersHandlerSuperheroes.regeneration(player, 4);
            }
            PowersHandlerSuperheroes.speed(player, 7, -1);
            PowersHandlerSuperheroes.acrobatics(player, 3);
            PowersHandlerSuperheroes.nightVisionInDark(player, world);
            PowersHandlerSuperheroes.immuneToPoison(player);
            PowersHandlerSuperheroes.immuneToNausea(player);
            PowersHandlerSuperheroes.immuneToWither(player);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 16;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        wolverineHelmet = item;
        return wolverineHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        wolverineChest = item;
        return wolverineChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        wolverineLegs = item;
        return wolverineLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        wolverineBoots = item;
        return wolverineBoots;
    }

    @Override
    public Item getHelmetItem() {
        return wolverineHelmet;
    }

    @Override
    public Item getChestItem() {
        return wolverineChest;
    }

    @Override
    public Item getLegsItem() {
        return wolverineLegs;
    }

    @Override
    public Item getBootsItem() {
        return wolverineBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (player.func_82169_q(2).func_77942_o() && !player.func_82169_q(2).func_77978_p().func_74767_n("Claws")) {
            PowersHandlerSuperheroes.wolverineClaws(player, true);
        } else {
            PowersHandlerSuperheroes.wolverineClaws(player, false);
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int dash = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int dashCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (dashCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (dash == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int scentTracker = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int scentTrackerCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (scentTrackerCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (scentTracker == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 4;
    }
}

