/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.IHeatVision;
import com.tihyo.superheroes.management.IOpticBlast;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Ultron
implements SUMCharacter,
ISize,
IHeatVision,
IOpticBlast {
    public static Item ultronHelmet;
    public static Item ultronChest;
    public static Item ultronLegs;
    public static Item ultronBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 10;
    private int ability1CoolMaxTime = 25;
    private int ability2MaxTime = 100;
    private int ability2CoolMaxTime = 2500;
    private int ability3MaxTime = 5;
    private int ability3CoolMaxTime = 25;
    private int ability5MaxTime = 10;
    private int ability5CoolMaxTime = 600;
    private String ability1Tag = "ConcussiveBlast";
    private String ability1CooldownTag = "ConcussiveBlastCooldown";
    private String ability2Tag = "Repair";
    private String ability2CooldownTag = "RepairCooldown";
    private String ability3Tag = "OpticBlast";
    private String ability3CooldownTag = "OpticBlastCooldown";
    private String ability5Tag = "RadiationEmitter";
    private String ability5CooldownTag = "RadiationEmitterCooldown";

    @Override
    public String getName() {
        return "ultron";
    }

    @Override
    public String getDisplayName() {
        return "Ultron-5";
    }

    @Override
    public String getAltEgoText() {
        return "N/A";
    }

    @Override
    public String getDefenseText() {
        return "Extreme";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Villain";
    }

    @Override
    public String getSuperDexIndex() {
        return "045";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.extremeDur, SuitDefenseTypes.extreme, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 40.0f;
    }

    @Override
    public float getFallResistance() {
        return 0.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public float getStandWidth(SUMCharacter stand) {
        return 1.4f;
    }

    @Override
    public float getStandHeight(SUMCharacter stand) {
        return 1.4f;
    }

    @Override
    public Color getHeatVisionColor(EntityPlayer player) {
        return Color.RED;
    }

    @Override
    public Color getOpticBlastColor(EntityPlayer player) {
        return Color.RED;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("isShielding", false);
            itemstack.func_77978_p().func_74757_a("FlightType3", false);
            itemstack.func_77978_p().func_74757_a("Aim", false);
            itemstack.func_77978_p().func_74757_a("Phasing", false);
            itemstack.func_77978_p().func_74757_a("FlightParticles", true);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74776_a("Width", 1.4f);
            itemstack.func_77978_p().func_74776_a("Height", 1.4f);
            itemstack.func_77978_p().func_74776_a("EyeHeight", 1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingUltron((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Head";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Chest";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Legs";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Feet";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 34;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 28");
        powers.add("Speed: 2 (When Sprinting)");
        powers.add("Jump Boost: 2");
        powers.add("Flight: 3");
        powers.add("Water Breathing/Minor Fire Resistance");
        powers.add("Psychic Shield");
        powers.add("No Fall Damage");
        powers.add("Concussive Blast: Suit Ability 1 (When Aiming)");
        powers.add("Repair: Suit Ability 2");
        powers.add("Optic Blast: Suit Ability 3");
        powers.add("Night-Vision: Suit Ability 4");
        powers.add("Radiation Emmiter: Suit Ability 5 (When Aiming)");
        powers.add("- Poisons Target With Radiation");
        powers.add("Aim: Weapons Equip");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Suffocation");
        immunities.add("Poison");
        immunities.add("Hunger");
        immunities.add("Wither");
        immunities.add("Bullets");
        immunities.add("Arrows");
        immunities.add("Snowballs");
        immunities.add("Psychic Shield");
        immunities.add("Can Breathe In Space");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingUltron((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability2Cool < this.ability2CoolMaxTime) {
                    ++ability2Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                PowersHandlerSuperheroes.concussiveBlast(player);
                ++ability1;
            }
            if (ability2 < this.ability2MaxTime) {
                PowersHandlerSuperheroes.repair(player);
                ++ability2;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.laserBeam(player, 0);
                ++ability3;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.radiationEmmitters(player);
                ++ability5;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            PowersHandlerSuperheroes.healthBoost(player, 10);
            PowersHandlerSuperheroes.strength(player, 28);
            PowersHandlerSuperheroes.jumpBoost(player, 2);
            PowersHandlerSuperheroes.speed(player, 2, -1);
            PowersHandlerSuperheroes.flight(player, 3);
            PowersHandlerSuperheroes.waterBreathing(player);
            PowersHandlerSuperheroes.minorFireResist(player, world);
            PowersHandlerSuperheroes.opticBlastStatus(player);
            PowersHandlerSuperheroes.psychicShieldStatus(player);
            PowersHandlerSuperheroes.immuneToSuffocation(player);
            PowersHandlerSuperheroes.immuneToPoison(player);
            PowersHandlerSuperheroes.immuneToHunger(player);
            PowersHandlerSuperheroes.immuneToWither(player);
            PowersHandlerSuperheroes.canSurviveInSpace(player);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList altSuit = new ArrayList();
        if (this.hasAlts()) {
            // empty if block
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 34;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) && i != 0) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        ultronHelmet = item;
        return ultronHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        ultronChest = item;
        return ultronChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        ultronLegs = item;
        return ultronLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        ultronBoots = item;
        return ultronBoots;
    }

    @Override
    public Item getHelmetItem() {
        return ultronHelmet;
    }

    @Override
    public Item getChestItem() {
        return ultronChest;
    }

    @Override
    public Item getLegsItem() {
        return ultronLegs;
    }

    @Override
    public Item getBootsItem() {
        return ultronBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Aim") && player.func_71045_bC() == null && !player.field_82175_bq) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int concussiveBlast = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int concussiveBlastCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (concussiveBlastCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (concussiveBlast == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int repair = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int repairCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (repairCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (repair == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int opticBlast = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int opticBlastCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (opticBlastCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (opticBlast == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            PowersHandlerSuperheroes.nightVisionToggle(player);
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Aim") && player.func_71045_bC() == null && !player.field_82175_bq) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int RadiationEmitter = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int RadiationEmitterCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (RadiationEmitterCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (RadiationEmitter == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            if (player.func_82169_q(2).func_77942_o() && !player.func_82169_q(2).func_77978_p().func_74767_n("Aim")) {
                PowersHandlerSuperheroes.aim(player, true);
            } else {
                PowersHandlerSuperheroes.aim(player, false);
            }
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 5;
    }
}

