/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.entities.ExtendedPlayer;
import com.tihyo.legends.management.I3SlotSuit;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.items.weapons.ItemThorHammer;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ILightning;
import com.tihyo.superheroes.management.IMjolnir;
import com.tihyo.superheroes.management.LightningStream;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Thor
implements SUMCharacter,
I3SlotSuit,
IMjolnir,
ILightning {
    public static final ResourceLocation chargebar = new ResourceLocation("sus", "textures/gui/chargebar.png");
    public static Item thorHelmet;
    public static Item thorChest;
    public static Item thorLegs;
    public static Item thorBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability2MaxTime = 4;
    private int ability2CoolMaxTime = 50;
    private int ability3MaxTime = 5;
    private int ability3CoolMaxTime = 100;
    private int ability4MaxTime = 4;
    private int ability4CoolMaxTime = 200;
    private int ability5MaxTime = 2;
    private int ability5CoolMaxTime = 40;
    private String ability2Tag = "LightningStrike";
    private String ability2CooldownTag = "LightningStrikeCooldown";
    private String ability3Tag = "LightningStream";
    private String ability3CooldownTag = "LightningStreamCooldown";
    private String ability4Tag = "WarriorsMadness";
    private String ability4CooldownTag = "WarriorsMadnessCooldown";
    private String ability5Tag = "GroundPound";
    private String ability5CooldownTag = "GroundPoundCooldown";

    @Override
    public String getName() {
        return "thor";
    }

    @Override
    public String getDisplayName() {
        return "Thor";
    }

    @Override
    public String getAltEgoText() {
        return "Thor Odinson";
    }

    @Override
    public String getDefenseText() {
        return "Extreme";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "009";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.extremeDur, SuitDefenseTypes.extreme, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 40.0f;
    }

    @Override
    public float getFallResistance() {
        return 0.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public LightningStream getLightningColor(EntityPlayer player) {
        return LightningStream.blue;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Flying", false);
            itemstack.func_77978_p().func_74757_a("FlightType2", false);
            itemstack.func_77978_p().func_74768_a(this.ability2Tag, this.ability2MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability2CooldownTag, this.ability2CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingThor((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability2Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability2 = (int)((float)ability2Cooldown / (float)this.ability2CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability2CooldownTag)) {
                length = (int)((float)ability2 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 24, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Helmet";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 26;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 23");
        powers.add("Speed: 12 (When Sprinting)");
        powers.add("Jump Boost: 3");
        powers.add("Flight: 3 (Hold Right-Click and Release With Mj\u00ef\u00bf\u00bdlnir)");
        powers.add("Water Breathing");
        powers.add("Fire Resistance");
        powers.add("Regeneration: 2");
        powers.add("No Fall Damage");
        powers.add("Mj\u00ef\u00bf\u00bdlnir: +7 Attack");
        powers.add(" - Suit Ability 1: Hammer Throw");
        powers.add(" - Suit Ability 2: Lightning Strike");
        powers.add(" - Suit Ability 3: Lightning Stream");
        powers.add(" - Suit Ability 5: Ground Pound");
        powers.add(" - Knockback");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Suffocation");
        immunities.add("Poison");
        immunities.add("Wither");
        immunities.add("Nausea");
        immunities.add("Bullets");
        immunities.add("Arrows");
        immunities.add("Snowballs");
        immunities.add("Can Breathe In Space");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingThor((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability2 = itemStack.func_77978_p().func_74762_e(this.ability2Tag);
            int ability2Cool = itemStack.func_77978_p().func_74762_e(this.ability2CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
            int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            boolean flying = itemStack.func_77978_p().func_74767_n("Flying");
            boolean flyingAni = itemStack.func_77978_p().func_74767_n("FlightType2");
            if (!world.field_72995_K) {
                if (ability2Cool < this.ability2CoolMaxTime) {
                    ++ability2Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
                if (ability4Cool < this.ability4CoolMaxTime) {
                    ++ability4Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability2 < this.ability2MaxTime) {
                PowersHandlerSuperheroes.lightningStrike(player);
                ++ability2;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.lightningStream(player);
                ++ability3;
            }
            if (ability4 < this.ability4MaxTime) {
                ++ability4;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.groundPound(player, 2.0f);
                ++ability5;
            }
            if (flying && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemThorHammer && !player.field_70122_E && !player.field_71075_bZ.field_75100_b) {
                float moveForward = 1.2f;
                float moveY = 0.8f;
                if (!player.field_82175_bq && !player.func_70093_af()) {
                    flyingAni = true;
                    player.field_70159_w = -Math.sin(player.field_70177_z * (float)Math.PI / 180.0f) * (double)moveForward;
                    player.field_70181_x = -Math.sin(player.field_70125_A * (float)Math.PI / 180.0f) * (double)moveY;
                    player.field_70179_y = Math.cos(player.field_70177_z * (float)Math.PI / 180.0f) * (double)moveForward;
                } else if (player.func_70093_af()) {
                    player.field_70181_x -= (double)0.1f;
                } else {
                    flyingAni = false;
                    player.field_70181_x = 0.0;
                }
            }
            if (player.field_70122_E || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemThorHammer)) {
                flying = false;
                flyingAni = false;
            }
            itemStack.func_77978_p().func_74768_a(this.ability2Tag, ability2);
            itemStack.func_77978_p().func_74768_a(this.ability2CooldownTag, ability2Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
            itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            itemStack.func_77978_p().func_74757_a("Flying", flying);
            itemStack.func_77978_p().func_74757_a("FlightType2", flyingAni);
            PowersHandlerSuperheroes.healthBoost(player, 10);
            PowersHandlerSuperheroes.strength(player, 23);
            PowersHandlerSuperheroes.speed(player, 12, -1);
            PowersHandlerSuperheroes.jumpBoost(player, 3);
            PowersHandlerSuperheroes.waterBreathing(player);
            PowersHandlerSuperheroes.fireResistance(player);
            PowersHandlerSuperheroes.regeneration(player, 2);
            PowersHandlerSuperheroes.immuneToSuffocation(player);
            PowersHandlerSuperheroes.immuneToPoison(player);
            PowersHandlerSuperheroes.immuneToWither(player);
            PowersHandlerSuperheroes.immuneToNausea(player);
            PowersHandlerSuperheroes.canSurviveInSpace(player);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 26;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name) || i != 0) continue;
            altName = "";
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        thorHelmet = item;
        return thorHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        thorChest = item;
        return thorChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        thorLegs = item;
        return thorLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        thorBoots = item;
        return thorBoots;
    }

    @Override
    public Item getHelmetItem() {
        return thorHelmet;
    }

    @Override
    public Item getChestItem() {
        return thorChest;
    }

    @Override
    public Item getLegsItem() {
        return thorLegs;
    }

    @Override
    public Item getBootsItem() {
        return thorBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player)) {
            ExtendedPlayer extPlayer = ExtendedPlayer.get((EntityPlayer)player);
            if (player.field_71071_by.func_146028_b(RegisterItemsSUM.thorHammer) && SuitCheckerHelper.isWearingThor((EntityPlayer)player)) {
                PowersHandlerSuperheroes.hammerThrow(player);
                extPlayer.setWeaponData(1);
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && player.field_71071_by.func_146028_b(RegisterItemsSUM.thorHammer)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability2CooldownTag);
            int strike = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2Tag);
            int strikeCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability2CooldownTag);
            if (strikeCool >= this.ability2CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2Tag, 0);
                if (strike == this.ability2MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability2CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && player.field_71071_by.func_146028_b(RegisterItemsSUM.thorHammer)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int stream = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int streamCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (streamCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (stream == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int madness = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int madnessCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (madnessCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (madness == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearing3SlotSuit((EntityPlayer)player) && player.field_70122_E && player.field_71071_by.func_146028_b(RegisterItemsSUM.thorHammer)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int groundPound = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int groundPoundCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (groundPoundCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (groundPound == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingThor((EntityPlayer)player)) {
            ExtendedPlayer extPlayer = ExtendedPlayer.get((EntityPlayer)player);
            if (!player.field_71071_by.func_146028_b(RegisterItemsSUM.thorHammer) && extPlayer.getWeaponData() == 0) {
                player.field_71071_by.func_70441_a(new ItemStack(RegisterItemsSUM.thorHammer));
            } else {
                player.field_71071_by.func_146026_a(RegisterItemsSUM.thorHammer);
            }
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 5;
    }
}

