/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.MethodsHandlerSuperheroes;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Scarecrow
implements SUMCharacter {
    public static final ResourceLocation fuel0 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel0.png");
    public static final ResourceLocation fuel10 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel1.png");
    public static final ResourceLocation fuel20 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel2.png");
    public static final ResourceLocation fuel30 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel3.png");
    public static final ResourceLocation fuel40 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel4.png");
    public static final ResourceLocation fuel50 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel5.png");
    public static final ResourceLocation fuel60 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel6.png");
    public static final ResourceLocation fuel70 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel7.png");
    public static final ResourceLocation fuel80 = new ResourceLocation("sus", "textures/gui/scarecrow/fuel/fuel8.png");
    public static Item scarecrowHelmet;
    public static Item scarecrowChest;
    public static Item scarecrowLegs;
    public static Item scarecrowBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 1;
    private int ability1CoolMaxTime = 25;
    private int ability3MaxTime = 1;
    private int ability3CoolMaxTime = 500;
    private String ability1Tag = "FearGas";
    private String ability1CooldownTag = "FearGasCooldown";
    private String ability3Tag = "SnappingStraw";
    private String ability3CooldownTag = "SnappingStrawCooldown";

    @Override
    public String getName() {
        return "scarecrow";
    }

    @Override
    public String getDisplayName() {
        return "Scarecrow";
    }

    @Override
    public String getAltEgoText() {
        return "Johnathan Crane";
    }

    @Override
    public String getDefenseText() {
        return "Medium";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "043";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.mediumDur, SuitDefenseTypes.medium, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 24.0f;
    }

    @Override
    public float getFallResistance() {
        return 2.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74776_a("Width", 0.92f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingScarecrow((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            }
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 27, 6, 3, length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (!itemStack.func_77942_o()) return defaultTexture;
        if (!this.hasAlts()) return defaultTexture;
        if (itemStack == null) return null;
        if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
            return defaultTexture;
        }
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
            return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 21;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 10");
        powers.add("Speed: 1 (When Sprinting)");
        powers.add("Jump Boost: 1");
        powers.add("Negates Fall Damage");
        powers.add("Fear-Toxin Injection: Punch Target");
        powers.add("- Injects Target With Fear-Toxin");
        powers.add("- Can Cause Bleeding");
        powers.add("Fear-Toxin Gas: Suit Ability 1");
        powers.add("N/A: Suit Ability 2");
        powers.add("Snapping Straw: Suit Ability 3");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Fear-Toxin");
        immunities.add("Blindness");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingScarecrow((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                MethodsHandlerSuperheroes.fearToxin(player, 0);
                ++ability1;
            }
            if (ability3 < this.ability3MaxTime) {
                MethodsHandlerSuperheroes.snappingStraw(player, 16);
                ++ability3;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            PowersHandlerSuperheroes.healthBoost(player, 2);
            PowersHandlerSuperheroes.strength(player, 10);
            PowersHandlerSuperheroes.speed(player, 1, -1);
            PowersHandlerSuperheroes.jumpBoost(player, 1);
            PowersHandlerSuperheroes.immuneToBlindess(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 8;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        scarecrowHelmet = item;
        return scarecrowHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        scarecrowChest = item;
        return scarecrowChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        scarecrowLegs = item;
        return scarecrowLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        scarecrowBoots = item;
        return scarecrowBoots;
    }

    @Override
    public Item getHelmetItem() {
        return scarecrowHelmet;
    }

    @Override
    public Item getChestItem() {
        return scarecrowChest;
    }

    @Override
    public Item getLegsItem() {
        return scarecrowLegs;
    }

    @Override
    public Item getBootsItem() {
        return scarecrowBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int fearGas = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int fearGasCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (fearGasCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (fearGas == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && !player.field_71071_by.func_146028_b(RegisterItemsSUM.strawGas)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int snappingStraw = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int snappingStrawCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (snappingStrawCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (snappingStraw == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 2;
    }
}

