/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.MethodsHandlerSuperheroes;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Joker
implements SUMCharacter {
    public static Item jokerHelmet;
    public static Item jokerChest;
    public static Item jokerLegs;
    public static Item jokerBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 1;
    private int ability1CoolMaxTime = 25;
    private int ability3MaxTime = 2;
    private int ability3CoolMaxTime = 30;
    private int ability4MaxTime = 1;
    private int ability4CoolMaxTime = 100;
    private int ability5MaxTime = 1;
    private int ability5CoolMaxTime = 50;
    private String ability1Tag = "AcidFlower";
    private String ability1CooldownTag = "AcidFlowerCooldown";
    private String ability3Tag = "JokerCards";
    private String ability3CooldownTag = "JokerCardsCooldown";
    private String ability4Tag = "JokerVenom";
    private String ability4CooldownTag = "JokerVenomCooldown";
    private String ability5Tag = "Grenade";
    private String ability5CooldownTag = "GrenadeCooldown";

    @Override
    public String getName() {
        return "joker";
    }

    @Override
    public String getDisplayName() {
        return "Joker";
    }

    @Override
    public String getAltEgoText() {
        return "N/A";
    }

    @Override
    public String getDefenseText() {
        return "Medium";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Villain";
    }

    @Override
    public String getSuperDexIndex() {
        return "036";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.mediumDur, SuitDefenseTypes.medium, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 24.0f;
    }

    @Override
    public float getFallResistance() {
        return 2.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4Tag, this.ability4MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability4CooldownTag, this.ability4CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingJoker((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability4 = (int)((float)ability4Cooldown / (float)this.ability4CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability4CooldownTag)) {
                length = (int)((float)ability4 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 21, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Head";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Pants";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Shoes";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 38;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 5");
        powers.add("Speed: 1 (When Sprinting)");
        powers.add("Jump Boost: 1");
        powers.add("Negates Fall Damage");
        powers.add("Acid Spray: Suit Ability 1");
        powers.add("- Poisons Target");
        powers.add("- Burns Through Blocks");
        powers.add("Joker's Pistol: Suit Ability 2");
        powers.add("- Hold Right-Click + Suit Ability 2 To Fire Bullets");
        powers.add("- Must Have Bullets In Inventory");
        powers.add("- Hold Right-Click + Suit Ability 1 To Shoot BANG Flag");
        powers.add("Joker Card: Suit Ability 3");
        powers.add("Joker Venom: Suit Ability 4");
        powers.add("- Poisons Target");
        powers.add("- Causes Uncontrollable Laughing To Target");
        powers.add("Grenade: Suit Ability 5");
        powers.add("Knife: Weapons Equip");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities");
        immunities.add("Poison");
        immunities.add("Joker Venom");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingJoker((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability4 = itemStack.func_77978_p().func_74762_e(this.ability4Tag);
            int ability4Cool = itemStack.func_77978_p().func_74762_e(this.ability4CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
                if (ability4Cool < this.ability4CoolMaxTime) {
                    ++ability4Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                MethodsHandlerSuperheroes.jokerGun(player);
                ++ability1;
            }
            if (ability3 < this.ability3MaxTime) {
                PowersHandlerSuperheroes.jokerCard(player);
                ++ability3;
            }
            if (ability4 < this.ability4MaxTime) {
                MethodsHandlerSuperheroes.jokerGas(player);
                ++ability4;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.jokerGrenade(player, world);
                ++ability5;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            itemStack.func_77978_p().func_74768_a(this.ability4Tag, ability4);
            itemStack.func_77978_p().func_74768_a(this.ability4CooldownTag, ability4Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            PowersHandlerSuperheroes.healthBoost(player, 2);
            PowersHandlerSuperheroes.strength(player, 5);
            PowersHandlerSuperheroes.speed(player, 1, -1);
            PowersHandlerSuperheroes.jumpBoost(player, 1);
            PowersHandlerSuperheroes.immuneToPoison(player);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 0;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        jokerHelmet = item;
        return jokerHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        jokerChest = item;
        return jokerChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        jokerLegs = item;
        return jokerLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        jokerBoots = item;
        return jokerBoots;
    }

    @Override
    public Item getHelmetItem() {
        return jokerHelmet;
    }

    @Override
    public Item getChestItem() {
        return jokerChest;
    }

    @Override
    public Item getLegsItem() {
        return jokerLegs;
    }

    @Override
    public Item getBootsItem() {
        return jokerBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int acidFlower = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int acidFlowerCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (acidFlowerCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (acidFlower == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            MethodsHandlerSuperheroes.gunFire(player);
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int jokerCard = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int jokerCardCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (jokerCardCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (jokerCard == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability4CooldownTag);
            int jokerVenom = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4Tag);
            int jokerVenomCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability4CooldownTag);
            if (jokerVenomCool >= this.ability4CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4Tag, 0);
                if (jokerVenom == this.ability4MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability4CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int jokerGrenade = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int jokerGrenadeCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (jokerGrenadeCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (jokerGrenade == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (!player.field_71071_by.func_146028_b(RegisterItemsSUM.knife)) {
            player.field_71071_by.func_70441_a(new ItemStack(RegisterItemsSUM.knife));
        } else {
            player.field_71071_by.func_146026_a(RegisterItemsSUM.knife);
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 2;
    }
}

