/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.Main;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ISpeedster;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.management.trail.SpeedsterTrail;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Flash
implements SUMCharacter,
ISpeedster {
    private static final Object heightendedPerceptCooldownTag = null;
    public static Item flashHelmet;
    public static Item flashChest;
    public static Item flashLegs;
    public static Item flashBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 4;
    private int ability1CoolMaxTime = 150;
    private int heightenedPerceptMaxTime = 100;
    private int heightenedPerceptCoolMaxTime = 500;
    private String speedTag = "SpeedLevel";
    private String ability1Tag = "ArmVortex";
    private String ability1CooldownTag = "ArmVortexCooldown";

    @Override
    public String getName() {
        return "flash";
    }

    @Override
    public String getDisplayName() {
        return "Flash";
    }

    @Override
    public String getAltEgoText() {
        return "Barry Allen";
    }

    @Override
    public String getDefenseText() {
        return "High";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "005";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.highDur, SuitDefenseTypes.high, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 30.0f;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    @Override
    public SpeedsterTrail getTrailColor(EntityPlayer player) {
        return SpeedsterTrail.gold;
    }

    @Override
    public float getMinSpeed(EntityPlayer player) {
        return 1.0f;
    }

    @Override
    public float getMaxSpeed(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingFlashCW((EntityPlayer)player)) {
            return 10.0f;
        }
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingFlashCW2((EntityPlayer)player)) {
            return 11.5f;
        }
        return 12.0f;
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("WallRunning", false);
            itemstack.func_77978_p().func_74757_a("Trail", false);
            itemstack.func_77978_p().func_74757_a("Vibrating", false);
            itemstack.func_77978_p().func_74757_a("SlowMo", false);
            itemstack.func_77978_p().func_74776_a(this.speedTag, this.getMinSpeed(player));
            itemstack.func_77978_p().func_74768_a("SpeedAnimation", 0);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingFlash((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 15, 6, 3, length);
        }
    }

    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack != null) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                }
            }
        } else {
            return defaultTexture;
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 11;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Speed Force:");
        powers.add("- Health: " + (int)this.getMaxHealth());
        powers.add("- Attack Damage: 15 (27 Max)");
        powers.add("- Speed: 5 (20 Max)");
        powers.add("- Jump Boost: 2");
        powers.add("- Minor-Fire Resistance");
        powers.add("- Regeneration: 3");
        powers.add("- Negates Fall Damage");
        powers.add("- Water Running");
        powers.add("- Speedster Trail (When Running Fast Enough)");
        powers.add("Arm Vortex: Suit Ability 1");
        powers.add("Increase Speed: Hold Suit Ability 2");
        powers.add("Decrease Speed: Hold Suit Ability 3");
        powers.add("Reset Speed: Hold Shift + Suit Ability 3");
        powers.add("Vibrate: Suit Ability 4");
        powers.add("Phase: Vibrating + Weapons Equip");
        powers.add("Wall Running: Hold Suit Ability 5");
        powers.add("Heightened Perception: Utility Ability");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Poison (When Vibrating)");
        immunities.add("Nausea (When Vibrating)");
        immunities.add("Suffocation");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingFlash((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int speedLevel = itemStack.func_77978_p().func_74762_e(this.speedTag);
            if (!world.field_72995_K && ability1Cool < this.ability1CoolMaxTime) {
                ++ability1Cool;
            }
            if (ability1 < this.ability1MaxTime) {
                PowersHandlerSuperheroes.armVortex(player);
                ++ability1;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            if (player.field_70122_E && player.field_70701_bs >= 0.1f && !player.func_70090_H() && !player.func_70644_a(Main.slownessPotion) && !player.func_70644_a(Main.frozenPotion)) {
                player.func_70060_a(player.field_70702_br, player.field_70701_bs, (float)speedLevel * 0.05f);
            }
            PowersHandlerSuperheroes.healthBoost(player, 5);
            PowersHandlerSuperheroes.strength(player, 15);
            PowersHandlerSuperheroes.speed(player, 3, 1);
            PowersHandlerSuperheroes.jumpBoost(player, 2);
            PowersHandlerSuperheroes.minorFireResist(player, world);
            PowersHandlerSuperheroes.regeneration(player, 3);
            PowersHandlerSuperheroes.speedForce(player);
            if (player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Vibrating")) {
                PowersHandlerSuperheroes.immuneToPoison(player);
                PowersHandlerSuperheroes.immuneToNausea(player);
            }
            PowersHandlerSuperheroes.immuneToSuffocation(player);
            if (!player.field_70122_E) {
                player.func_82170_o(Main.intangPotion.field_76415_H);
            }
        }
    }

    @Override
    public boolean hasAlts() {
        return true;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("cw");
            altSuit.add("cw2");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && (altPos == 0 || altPos == 1)) {
            modelID = 15;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
            if (i == 0) {
                altName = "CW Version 1";
                continue;
            }
            if (i != 1) continue;
            altName = "CW Version 2";
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        flashHelmet = item;
        return flashHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        flashChest = item;
        return flashChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        flashLegs = item;
        return flashLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        flashBoots = item;
        return flashBoots;
    }

    @Override
    public Item getHelmetItem() {
        return flashHelmet;
    }

    @Override
    public Item getChestItem() {
        return flashChest;
    }

    @Override
    public Item getLegsItem() {
        return flashLegs;
    }

    @Override
    public Item getBootsItem() {
        return flashBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && !player.func_70093_af() && !player.func_70644_a(Main.intangPotion)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int armVortex = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int armVortexCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (armVortexCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (armVortex == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        if (player.func_82169_q(2).func_77942_o() && !player.func_82169_q(2).func_77978_p().func_74767_n("Vibrating")) {
            PowersHandlerSuperheroes.vibratingStatus(player, true);
        } else {
            PowersHandlerSuperheroes.vibratingStatus(player, false);
        }
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 5;
    }
}

