/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.MethodsHandlerSuperheroes;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.items.RegisterItemsSUM;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SUMHelper;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Deadpool
implements SUMCharacter {
    public static Item deadpoolHelmet;
    public static Item deadpoolChest;
    public static Item deadpoolLegs;
    public static Item deadpoolBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 200;
    private int ability1CoolMaxTime = 300;
    private int ability3MaxTime = 1;
    private int ability3CoolMaxTime = 20;
    private int ability5MaxTime = 1;
    private int ability5CoolMaxTime = 50;
    private String ability1Tag = "Combat";
    private String ability1CooldownTag = "CombatCooldown";
    private String ability3Tag = "Teleportation";
    private String ability3CooldownTag = "TeleportationCooldown";
    private String ability5Tag = "Grenade";
    private String ability5CooldownTag = "GrenadeCooldown";

    @Override
    public String getName() {
        return "deadpool";
    }

    @Override
    public String getDisplayName() {
        return "Deadpool";
    }

    @Override
    public String getAltEgoText() {
        return "Wade Wilson";
    }

    @Override
    public String getDefenseText() {
        return "Extreme";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "035";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.extremeDur, SuitDefenseTypes.extreme, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 28.0f;
    }

    @Override
    public float getFallResistance() {
        return 8.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Swords", false);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5Tag, this.ability5MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability5CooldownTag, this.ability5CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        int length = 0;
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingDeadpool((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability5Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            int ability5 = (int)((float)ability5Cooldown / (float)this.ability5CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability5CooldownTag)) {
                length = (int)((float)ability5 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
        String defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
        if (!itemStack.func_77942_o()) return defaultTexture;
        boolean swords = itemStack.func_77978_p().func_74767_n("Swords");
        String swordsTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_swords_off_" + layer + ".png";
        if (this.hasAlts()) {
            if (itemStack == null) return null;
            if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                return defaultTexture;
            }
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                if (swords) return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_swords_off_" + layer + ".png";
            }
            return null;
        } else {
            if (!swords) return defaultTexture;
            return swordsTexture;
        }
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsMarvelTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 33;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 11");
        powers.add("Speed: 5 (When Sprinting)");
        powers.add("Acrobatics: 3");
        powers.add("Regeneration: 5");
        powers.add("Negates Fall Damage");
        powers.add("Combat: Suit Ability 1");
        powers.add("Pistol: Suit Ability 2");
        powers.add("- Hold Right-Click + Suit Ability 2 To Shoot");
        powers.add("- Must Have Bullets In Inventory");
        powers.add("Teleportation: Suit Ability 3");
        powers.add("Grenade: Suit Ability 5");
        powers.add("Katanas: Weapons Equip");
        powers.add("N/A: Special Ability");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList<String> immunities = new ArrayList<String>();
        immunities.add("Immunities:");
        immunities.add("Poison");
        immunities.add("Nausea");
        immunities.add("Wither");
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && character instanceof Deadpool) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability5 = itemStack.func_77978_p().func_74762_e(this.ability5Tag);
            int ability5Cool = itemStack.func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
                if (ability5Cool < this.ability5CoolMaxTime) {
                    ++ability5Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                ++ability1;
            }
            if (ability3 < this.ability3MaxTime) {
                player.field_70159_w = 0.0;
                player.field_70181_x = 0.0;
                player.field_70179_y = 0.0;
                PowersHandlerSuperheroes.teleportation(player);
                ++ability3;
            }
            if (ability5 < this.ability5MaxTime) {
                PowersHandlerSuperheroes.grenade(player, world);
                ++ability5;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            itemStack.func_77978_p().func_74768_a(this.ability5Tag, ability5);
            itemStack.func_77978_p().func_74768_a(this.ability5CooldownTag, ability5Cool);
            PowersHandlerSuperheroes.healthBoost(player, 4);
            PowersHandlerSuperheroes.strength(player, 11);
            PowersHandlerSuperheroes.regeneration(player, 5);
            PowersHandlerSuperheroes.speed(player, 5, -1);
            PowersHandlerSuperheroes.acrobatics(player, 3);
            PowersHandlerSuperheroes.teleportationStatus(player);
            PowersHandlerSuperheroes.immuneToPoison(player);
            PowersHandlerSuperheroes.immuneToNausea(player);
            PowersHandlerSuperheroes.immuneToWither(player);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return false;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts() && altPos == 0) {
            modelID = 33;
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        deadpoolHelmet = item;
        return deadpoolHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        deadpoolChest = item;
        return deadpoolChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        deadpoolLegs = item;
        return deadpoolLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        deadpoolBoots = item;
        return deadpoolBoots;
    }

    @Override
    public Item getHelmetItem() {
        return deadpoolHelmet;
    }

    @Override
    public Item getChestItem() {
        return deadpoolChest;
    }

    @Override
    public Item getLegsItem() {
        return deadpoolLegs;
    }

    @Override
    public Item getBootsItem() {
        return deadpoolBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int combat = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int combatCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (combatCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (combat == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            MethodsHandlerSuperheroes.gunFire(player);
        }
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int teleportation = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int teleportationCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (teleportationCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (teleportation == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability5CooldownTag);
            int grenade = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5Tag);
            int grenadeCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability5CooldownTag);
            if (grenadeCool >= this.ability5CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5Tag, 0);
                if (grenade == this.ability5MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability5CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingDeadpool((EntityPlayer)player)) {
            if (!player.field_71071_by.func_146028_b(RegisterItemsSUM.katana) && player.func_82169_q(2).func_77942_o() && !player.func_82169_q(2).func_77978_p().func_74767_n("Swords")) {
                player.field_71071_by.func_70441_a(new ItemStack(RegisterItemsSUM.katana, 1));
                player.field_70170_p.func_72956_a((Entity)player, "sus:clawsextract", 1.0f, 1.0f);
                player.func_82169_q(2).func_77978_p().func_74757_a("Swords", true);
            } else if (player.func_82169_q(2).func_77942_o() && player.func_82169_q(2).func_77978_p().func_74767_n("Swords")) {
                player.field_71071_by.func_146026_a(RegisterItemsSUM.katana);
                player.field_70170_p.func_72956_a((Entity)player, "sus:clawsretract", 1.0f, 1.0f);
                player.func_82169_q(2).func_77978_p().func_74757_a("Swords", false);
            }
        }
    }

    static {
        altSuitItems = new ArrayList();
        tier = 4;
    }
}

