/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.characters;

import com.tihyo.legends.client.models.ModelPlayer;
import com.tihyo.legends.common.SuitCheckerHelper;
import com.tihyo.legends.management.IStealth;
import com.tihyo.superheroes.armors.SUMDurability;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.handlers.PowersHandlerSuperheroes;
import com.tihyo.superheroes.handlers.SUMSuitVersionUpdater;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.IBatfamily;
import com.tihyo.superheroes.management.ICombat;
import com.tihyo.superheroes.management.IGliding;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.SUMCreativeTabs;
import com.tihyo.superheroes.management.SuitInfo;
import com.tihyo.superheroes.proxies.ClientProxy;
import com.tihyo.superheroes.utils.SUMHelper;
import com.tihyo.superheroes.utils.SuitDefenseTypes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Batman
implements SUMCharacter,
IBatfamily,
ICombat,
IGliding,
IStealth {
    public static Item batmanHelmet;
    public static Item batmanChest;
    public static Item batmanLegs;
    public static Item batmanBoots;
    public static ArrayList altSuitItems;
    public static int tier;
    private String versionTag = "Version";
    private double versionNum = SUMSuitVersionUpdater.currentVersion;
    private int ability1MaxTime = 1;
    private int ability1CoolMaxTime = 10;
    private int ability3MaxTime = 200;
    private int ability3CoolMaxTime = 300;
    private String ability1Tag = "UseGadget";
    private String ability1CooldownTag = "UseGadgetCooldown";
    private String ability3Tag = "Combat";
    private String ability3CooldownTag = "CombatCooldown";
    private String gadget1Tag = "Batarang";
    private String gadget2Tag = "ExplosiveBatarang";
    private String gadget3Tag = "HeatedBatarang";
    private String gadget4Tag = "ElectricBatarang";
    private String gadget5Tag = "GasPellet";
    private String gadget6Tag = "FreezeGrenade";
    private String gadget7Tag = "Handlink";

    @Override
    public String getName() {
        return "batman";
    }

    @Override
    public String getDisplayName() {
        return "Batman";
    }

    @Override
    public String getAltEgoText() {
        return "Bruce Wayne";
    }

    @Override
    public String getDefenseText() {
        return "Medium";
    }

    @Override
    public int getTier() {
        return tier;
    }

    @Override
    public String getCharacterSide() {
        return "Hero";
    }

    @Override
    public String getSuperDexIndex() {
        return "002";
    }

    @Override
    public SuitInfo getSuitInfo() {
        return new SuitInfo(SUMDurability.mediumDur, SuitDefenseTypes.medium, SuitDefenseTypes.noEnchant);
    }

    @Override
    public float getMaxHealth() {
        return 28.0f;
    }

    @Override
    public float getFallResistance() {
        return 8.0f;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.versionTag) && stack.func_77978_p().func_74769_h(this.versionTag) == 0.0) {
            par2List.add("\u00a79THIS IS A 5.0 ALPHA SUIT");
        }
    }

    public void setTags(ItemStack itemstack, EntityPlayer player, World world) {
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.func_77978_p().func_74780_a(this.versionTag, this.versionNum);
            itemstack.func_77978_p().func_74757_a("Invisible", false);
            itemstack.func_77978_p().func_74757_a("Stealth", false);
            itemstack.func_77978_p().func_74757_a("Gliding", false);
            itemstack.func_77978_p().func_74768_a(this.ability1Tag, this.ability1MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability1CooldownTag, this.ability1CoolMaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3Tag, this.ability3MaxTime);
            itemstack.func_77978_p().func_74768_a(this.ability3CooldownTag, this.ability3CoolMaxTime);
            itemstack.func_77978_p().func_74778_a("CurrentAbility", "");
            itemstack.func_77978_p().func_74778_a("CurrentGadget", "");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay gui, int posX, int posY) {
        ResourceLocation statusTexture = new ResourceLocation("sus", "textures/gui/charge_bar.png");
        ResourceLocation gadgetsTexture = new ResourceLocation("sus", "textures/gui/batgadgets/gadgetsicon.png");
        int length = 0;
        SUMCharacter character = SUMHelper.getCharacter(player);
        ScaledResolution resolution = new ScaledResolution(gui.minecraft, gui.minecraft.field_71443_c, gui.minecraft.field_71440_d);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int x = width - 23;
        int y = height - 23;
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingBatman((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            int ability1Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3Cooldown = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            int ability1 = (int)((float)ability1Cooldown / (float)this.ability1CoolMaxTime * 55.0f);
            int ability3 = (int)((float)ability3Cooldown / (float)this.ability3CoolMaxTime * 55.0f);
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability1CooldownTag)) {
                length = (int)((float)ability1 / 100.0f * 90.0f);
                if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget1Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 29, posY - 21, 0, 0, 38, 14);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget2Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 29, posY - 21, 76, 0, 38, 14);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget3Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 29, posY - 21, 114, 0, 38, 14);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget4Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 29, posY - 21, 38, 0, 38, 14);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget5Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 5, posY - 21, 153, 0, 14, 100);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget6Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 5, posY - 21, 167, 0, 14, 100);
                } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget7Tag)) {
                    gui.minecraft.func_110434_K().func_110577_a(gadgetsTexture);
                    gui.func_73729_b(posX - 14, posY - 38, 45, 14, 23, 100);
                }
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentAbility").equals(this.ability3CooldownTag)) {
                length = (int)((float)ability3 / 100.0f * 90.0f);
            }
            gui.minecraft.func_110434_K().func_110577_a(statusTexture);
            gui.func_73729_b(posX + 13, posY - 8 - length, 12, 6, 3, length);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getArmorIconName(ArmorType onArmorType, ItemStack itemStack, Entity entity) {
        int layer;
        block12: {
            boolean gliding;
            block11: {
                String defaultTexture;
                block10: {
                    layer = onArmorType != ArmorType.LEGGINGS ? 1 : 2;
                    defaultTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + layer + ".png";
                    if (!itemStack.func_77942_o()) break block10;
                    gliding = itemStack.func_77978_p().func_74767_n("Gliding");
                    String glidingTexture = "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_gliding_" + layer + ".png";
                    if (this.hasAlts()) {
                        if (itemStack == null) return null;
                        if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                            if (!gliding) return defaultTexture;
                            return glidingTexture;
                        }
                        break block11;
                    } else {
                        if (!gliding) return defaultTexture;
                        return glidingTexture;
                    }
                }
                if (!this.hasAlts()) {
                    return defaultTexture;
                }
                if (itemStack == null) return null;
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    return defaultTexture;
                }
                break block12;
            }
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                if (!gliding) return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
                return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_gliding_" + layer + ".png";
            }
            return null;
        }
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
            return "sus:textures/models/armors/" + this.getName() + "/" + this.getName() + "_" + this.getAltSuits().get(i).toString() + "_" + layer + ".png";
        }
        return null;
    }

    @Override
    public String getDisplayName(ArmorType onArmorType, ItemStack itemStack) {
        String extension = "";
        String altName = "";
        if (onArmorType.equals(ArmorType.HELMET)) {
            extension = "Mask";
        } else if (onArmorType.equals(ArmorType.CHESTPLATE)) {
            extension = "Suit";
        } else if (onArmorType.equals(ArmorType.LEGGINGS)) {
            extension = "Leggings";
        } else if (onArmorType.equals(ArmorType.BOOTS)) {
            extension = "Boots";
        }
        if (this.hasAlts()) {
            for (int i = 0; i < this.getAltSuits().size(); ++i) {
                if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                altName = this.getAltDisplayName(itemStack, onArmorType);
                return this.getDisplayName() + "'s (" + altName + ") " + extension;
            }
            return this.getDisplayName() + "'s " + extension;
        }
        return this.getDisplayName() + "'s " + extension;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return SUMCreativeTabs.suitsDCTab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ArmorType onArmorType) {
        ModelPlayer armorModel = new ModelPlayer();
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        int defaultArmorModelID = 8;
        if (itemStack != null) {
            if (this.hasAlts()) {
                if (itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + onArmorType.name)) {
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
                }
                for (int i = 0; i < this.getAltSuits().size(); ++i) {
                    if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
                    armorModel = (ModelPlayer)ClientProxy.getArmorModel(this.getAltSuitModelID(i));
                }
            } else {
                armorModel = (ModelPlayer)ClientProxy.getArmorModel(defaultArmorModelID);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78118_o = false;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_82169_q(0) != null ? 1 : 0;
                    int n = armorModel.field_78120_m = ((EntityPlayer)entityLiving).func_71045_bC() != null ? 1 : 0;
                    if (((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                        EnumAction enumaction = ((EntityPlayer)entityLiving).func_71045_bC().func_77975_n();
                        if (enumaction == EnumAction.block) {
                            armorModel.field_78120_m = 3;
                        } else if (enumaction == EnumAction.bow) {
                            armorModel.field_78118_o = true;
                        }
                    }
                }
                return armorModel;
            }
        }
        return null;
    }

    @Override
    public ArrayList generatePowersTag() {
        ArrayList<String> powers = new ArrayList<String>();
        powers.add("Health: " + (int)this.getMaxHealth());
        powers.add("Attack Damage: 10");
        powers.add("Speed: 5 (When Sprinting)");
        powers.add("Acrobatics: 3");
        powers.add("Stealth");
        powers.add("Psychic Shield");
        powers.add("Negates Fall Damage");
        powers.add("Use Gadget: Suit Ability 1");
        powers.add("Gliding: Hold Suit Ability 2");
        powers.add("Combat: Suit Ability 3");
        powers.add("Night-Vision: Suit Ability 4");
        powers.add("Toggle Gadget: Suit Ability 5");
        powers.add("N/A: Special Ability");
        powers.add("");
        powers.add("Default Gadgets: (Built-In)");
        powers.add("- Batarang");
        powers.add("- Heated Batarang");
        powers.add("- Explosive Batarang");
        powers.add("- Electric Batarang");
        powers.add("- Gas Pellet");
        powers.add("- Freeze Grenade");
        powers.add("- Handlink");
        powers.add("");
        powers.add("Add-On Gadgets: (Must Be Crafted)");
        powers.add("- Smoke Pellets");
        powers.add("- Grappling Gun");
        powers.add("- Explosive Gel Gun");
        powers.add("");
        powers.add("Vehicles:");
        powers.add("- Batmobile");
        powers.add("- Batboat");
        powers.add("- Batwing");
        return powers;
    }

    @Override
    public ArrayList generateImmunitiesTag() {
        ArrayList immunities = new ArrayList();
        return immunities;
    }

    @Override
    public ArrayList generateWeaknessesTag() {
        ArrayList weaknesses = new ArrayList();
        return weaknesses;
    }

    @Override
    public void onArmorTick(ArmorType onArmorType, EntityPlayer player, World world, Side logical, int i, ItemStack itemStack) {
        SUMCharacter character = SUMHelper.getCharacter(player);
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && SuitCheckerHelper.isWearingBatman((EntityPlayer)player)) {
            this.setTags(itemStack, player, world);
            int ability1 = itemStack.func_77978_p().func_74762_e(this.ability1Tag);
            int ability1Cool = itemStack.func_77978_p().func_74762_e(this.ability1CooldownTag);
            int ability3 = itemStack.func_77978_p().func_74762_e(this.ability3Tag);
            int ability3Cool = itemStack.func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (!world.field_72995_K) {
                if (ability1Cool < this.ability1CoolMaxTime) {
                    ++ability1Cool;
                }
                if (ability3Cool < this.ability3CoolMaxTime) {
                    ++ability3Cool;
                }
            }
            if (ability1 < this.ability1MaxTime) {
                PowersHandlerSuperheroes.batmanGadgets(player, world, player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget"));
                ++ability1;
            }
            if (ability3 < this.ability3MaxTime) {
                ++ability3;
            }
            itemStack.func_77978_p().func_74768_a(this.ability1Tag, ability1);
            itemStack.func_77978_p().func_74768_a(this.ability1CooldownTag, ability1Cool);
            itemStack.func_77978_p().func_74768_a(this.ability3Tag, ability3);
            itemStack.func_77978_p().func_74768_a(this.ability3CooldownTag, ability3Cool);
            PowersHandlerSuperheroes.healthBoost(player, 4);
            PowersHandlerSuperheroes.strength(player, 10);
            PowersHandlerSuperheroes.speed(player, 5, -1);
            PowersHandlerSuperheroes.acrobatics(player, 3);
            PowersHandlerSuperheroes.stealth(player, itemStack);
            PowersHandlerSuperheroes.psychicShieldStatus(player);
            PowersHandlerSuperheroes.invisChecker(player, itemStack);
        }
    }

    @Override
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
    }

    @Override
    public boolean hasAlts() {
        return true;
    }

    @Override
    public ArrayList getAltSuits() {
        ArrayList<String> altSuit = new ArrayList<String>();
        if (this.hasAlts()) {
            altSuit.add("1960s");
            altSuit.add("btas");
            altSuit.add("tnba");
            altSuit.add("darkknight");
            altSuit.add("brave");
            altSuit.add("new52");
        }
        return altSuit;
    }

    @Override
    public ArrayList setAltSuitsItem(Item item) {
        if (this.hasAlts()) {
            altSuitItems.add(item);
        }
        return altSuitItems;
    }

    @Override
    public int getAltSuitModelID(int altPos) {
        int modelID = 0;
        if (this.hasAlts()) {
            if (altPos == 1 || altPos == 2 || altPos == 3 || altPos == 4) {
                modelID = 8;
            } else if (altPos == 5) {
                modelID = 46;
            } else if (altPos == 0) {
                modelID = 47;
            }
        }
        return modelID;
    }

    @Override
    public String getAltDisplayName(ItemStack itemStack, ArmorType onArmorType) {
        String altName = "";
        for (int i = 0; i < this.getAltSuits().size(); ++i) {
            if (!itemStack.func_77973_b().func_77658_a().equals("item.sum." + this.getName() + "." + this.getAltSuits().get(i).toString() + "." + onArmorType.name)) continue;
            if (i == 0) {
                altName = "1960s";
                continue;
            }
            if (i == 1) {
                altName = "BTAS";
                continue;
            }
            if (i == 2) {
                altName = "TNBA";
                continue;
            }
            if (i == 3) {
                altName = "Dark Knight";
                continue;
            }
            if (i == 4) {
                altName = "Brave and the Bold";
                continue;
            }
            if (i != 5) continue;
            altName = "New 52";
        }
        return altName;
    }

    @Override
    public SUMCharacter getCharacter() {
        return this;
    }

    @Override
    public Item setHelmetItem(Item item) {
        batmanHelmet = item;
        return batmanHelmet;
    }

    @Override
    public Item setChestItem(Item item) {
        batmanChest = item;
        return batmanChest;
    }

    @Override
    public Item setLegsItem(Item item) {
        batmanLegs = item;
        return batmanLegs;
    }

    @Override
    public Item setBootsItem(Item item) {
        batmanBoots = item;
        return batmanBoots;
    }

    @Override
    public Item getHelmetItem() {
        return batmanHelmet;
    }

    @Override
    public Item getChestItem() {
        return batmanChest;
    }

    @Override
    public Item getLegsItem() {
        return batmanLegs;
    }

    @Override
    public Item getBootsItem() {
        return batmanBoots;
    }

    @Override
    public void suitAbility1(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals("")) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget1Tag);
            }
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability1CooldownTag);
            int useGadget = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1Tag);
            int useGadgetCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability1CooldownTag);
            if (useGadgetCool >= this.ability1CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1Tag, 0);
                if (useGadget == this.ability1MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability1CooldownTag, 0);
                }
            }
        }
    }

    @Override
    public void suitAbility2(EntityPlayer player) {
    }

    @Override
    public void suitAbility3(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player)) {
            player.func_82169_q(2).func_77978_p().func_74778_a("CurrentAbility", this.ability3CooldownTag);
            int combat = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3Tag);
            int combatCool = player.func_82169_q(2).func_77978_p().func_74762_e(this.ability3CooldownTag);
            if (combatCool >= this.ability3CoolMaxTime) {
                player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3Tag, 0);
                if (combat == this.ability3MaxTime) {
                    player.func_82169_q(2).func_77978_p().func_74768_a(this.ability3CooldownTag, 0);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c--Ability Not Complete--"));
                }
            }
        }
    }

    @Override
    public void suitAbility4(EntityPlayer player) {
        PowersHandlerSuperheroes.nightVisionToggle(player);
    }

    @Override
    public void suitAbility5(EntityPlayer player) {
        if (SuitCheckerHelper.isWearingAFullSuit((EntityPlayer)player) && player.func_82169_q(2).func_77942_o()) {
            if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals("")) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget1Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget1Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget2Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget2Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget3Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget3Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget4Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget4Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget5Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget5Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget6Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget6Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget7Tag);
            } else if (player.func_82169_q(2).func_77978_p().func_74779_i("CurrentGadget").equals(this.gadget7Tag)) {
                player.func_82169_q(2).func_77978_p().func_74778_a("CurrentGadget", this.gadget1Tag);
            }
        }
    }

    @Override
    public void weaponsEquip(EntityPlayer player) {
    }

    static {
        altSuitItems = new ArrayList();
        tier = 3;
    }
}

