/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.superheroes.armors;

import com.tihyo.legends.armors.AbstractLegendsSuit;
import com.tihyo.legends.common.Main;
import com.tihyo.superheroes.armors.SUMCharacterArmorProduct;
import com.tihyo.superheroes.handlers.AbilityBarEventDisplay;
import com.tihyo.superheroes.management.ArmorType;
import com.tihyo.superheroes.management.ISize;
import com.tihyo.superheroes.management.IUtility;
import com.tihyo.superheroes.management.SUMCharacter;
import com.tihyo.superheroes.management.Sides;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemSUMCharacterArmor
extends AbstractLegendsSuit
implements SUMCharacterArmorProduct {
    public ArmorType onArmorType;
    public SUMCharacter character;
    private Item overriddenIcon;

    public ItemSUMCharacterArmor(ItemArmor.ArmorMaterial material, ArmorType armorType, SUMCharacter character) {
        super(material, 0, armorType.vanillaID);
        this.onArmorType = armorType;
        this.character = character;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.character.getArmorIconName(this.onArmorType, stack, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return this.character.getDisplayName(this.onArmorType, stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List par2List, boolean par4) {
        this.character.addInformation(stack, player, par2List, par4);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.func_110143_aJ() > this.character.getMaxHealth()) {
            player.func_70606_j(this.character.getMaxHealth());
            player.func_82170_o(Main.healthBoostPotion.field_76415_H);
        }
        this.character.onArmorTick(this.onArmorType, player, world, Sides.logical(world), 36 + (3 - this.onArmorType.vanillaID), itemStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean inHotbar) {
        super.func_77663_a(stack, world, player, slot, inHotbar);
    }

    public IIcon func_77617_a(int metadata) {
        return this.overriddenIcon == null ? super.func_77617_a(metadata) : this.overriddenIcon.func_77617_a(metadata);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        if (this.overriddenIcon == null) {
            super.func_94581_a(iconRegister);
        }
    }

    @Override
    public void overrideIcon(Item model) {
        this.overriddenIcon = model;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return this.character.getArmorModel(entityLiving, itemStack, armorSlot, this.onArmorType);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack itemstack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        this.character.renderHelmetOverlay(itemstack, player, resolution, partialTicks, hasScreen, mouseX, mouseY);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderAbilityStatus(EntityPlayer player, AbilityBarEventDisplay display, int posX, int posY) {
        this.character.renderAbilityStatus(player, display, posX, posY);
    }

    public SUMCharacter getCharacter() {
        return this.character;
    }

    public void suitAbility1(EntityPlayer player) {
        this.character.suitAbility1(player);
    }

    public void suitAbility2(EntityPlayer player) {
        this.character.suitAbility2(player);
    }

    public void suitAbility3(EntityPlayer player) {
        this.character.suitAbility3(player);
    }

    public void suitAbility4(EntityPlayer player) {
        this.character.suitAbility4(player);
    }

    public void suitAbility5(EntityPlayer player) {
        this.character.suitAbility5(player);
    }

    public void weaponsEquip(EntityPlayer player) {
        this.character.weaponsEquip(player);
    }

    public void utilityAbility(EntityPlayer player) {
        if (this.character instanceof IUtility) {
            ((IUtility)((Object)this.character)).utilityAbility(player);
        }
    }

    public float getWidth(ItemStack chest) {
        float width;
        if (chest != null && chest.func_77942_o() && (width = chest.func_77978_p().func_74760_g("Width")) > 0.0f) {
            return width;
        }
        return 1.0f;
    }

    public float getHeight(ItemStack chest) {
        float height;
        if (chest != null && chest.func_77942_o() && (height = chest.func_77978_p().func_74760_g("Height")) > 0.0f) {
            return height;
        }
        return 1.0f;
    }

    public float getEyeHeight(ItemStack chest) {
        float height;
        if (chest != null && chest.func_77942_o() && (height = chest.func_77978_p().func_74760_g("EyeHeight")) > 0.0f) {
            return height;
        }
        return 1.0f;
    }

    public float getStandHeight(ItemStack chest) {
        if (chest != null && this.character instanceof ISize) {
            return ((ISize)((Object)this.character)).getStandHeight(this.character);
        }
        return 1.0f;
    }

    public float getStandWidth(ItemStack chest) {
        if (chest != null && this.character instanceof ISize) {
            return ((ISize)((Object)this.character)).getStandWidth(this.character);
        }
        return 1.0f;
    }
}

