/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.data;

import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.helper.ItemStackHelper;
import de.eydamos.backpack.misc.Constants;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class BackpackSave
extends WorldSavedData
implements IInventory {
    private ItemStack[] currentInventory;
    private Hashtable<String, ItemStack[]> inventories = new Hashtable();
    private ItemStack backpack;
    private boolean heldItem;
    private EntityPlayer player;

    public BackpackSave() {
        super(Constants.INVENTORIES_PATH + "DUMMY");
    }

    public BackpackSave(String name) {
        super(name);
    }

    @ParametersAreNonnullByDefault
    public void func_76184_a(NBTTagCompound nbt) {
        for (String identifier : nbt.func_150296_c()) {
            NBTTagList inventoryList = nbt.func_150295_c(identifier, 10);
            ItemStack[] inventory = ItemStackHelper.createInventory(inventoryList.func_74745_c());
            for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
                NBTTagCompound slotEntry = inventoryList.func_150305_b(i);
                int slot = slotEntry.func_74771_c("slot") & 0xFF;
                if (slot < 0 || slot >= inventory.length || !slotEntry.func_74764_b("id")) continue;
                inventory[slot] = new ItemStack(slotEntry);
            }
            if (this.currentInventory == null) {
                this.currentInventory = inventory;
            }
            this.inventories.put(identifier, inventory);
        }
    }

    @ParametersAreNonnullByDefault
    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        for (Map.Entry<String, ItemStack[]> inventoryEntry : this.inventories.entrySet()) {
            String identifier = inventoryEntry.getKey();
            ItemStack[] inventory = inventoryEntry.getValue();
            NBTTagList inventoryList = new NBTTagList();
            for (int i = 0; i < inventory.length; ++i) {
                NBTTagCompound slotEntry = new NBTTagCompound();
                slotEntry.func_74774_a("slot", (byte)i);
                if (!inventory[i].func_190926_b()) {
                    inventory[i].func_77955_b(slotEntry);
                }
                inventoryList.func_74742_a((NBTBase)slotEntry);
            }
            nbt.func_74782_a(identifier, (NBTBase)inventoryList);
        }
        return nbt;
    }

    private void initialize(ItemStack backpack, EntityPlayer player, boolean heldItem) {
        this.backpack = backpack;
        this.player = player;
        this.heldItem = heldItem;
        if (this.currentInventory == null) {
            int slots = BackpackHelper.getSlots(backpack);
            ItemStack[] inventory = ItemStackHelper.createInventory(slots);
            this.inventories.put("backpack", inventory);
            this.currentInventory = inventory;
        }
    }

    public static BackpackSave loadBackpack(World world, ItemStack backpack, EntityPlayer player, boolean heldItem) {
        String UUID2 = BackpackHelper.getUUID(backpack);
        MapStorage storage = world.func_175693_T();
        BackpackSave instance = (BackpackSave)storage.func_75742_a(BackpackSave.class, Constants.INVENTORIES_PATH + UUID2);
        if (instance == null) {
            instance = new BackpackSave(Constants.INVENTORIES_PATH + UUID2);
            storage.func_75745_a(Constants.INVENTORIES_PATH + UUID2, (WorldSavedData)instance);
        }
        instance.initialize(backpack, player, heldItem);
        return instance;
    }

    public int func_70302_i_() {
        return this.currentInventory.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.currentInventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70301_a(int index) {
        if (this.currentInventory != null && index >= 0 && index < this.currentInventory.length) {
            return this.currentInventory[index];
        }
        return ItemStack.field_190927_a;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70298_a(int index, int amount) {
        ItemStack itemstack = this.func_70301_a(index);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_190916_E() <= amount) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else {
                itemstack = itemstack.func_77979_a(amount);
                if (this.func_70301_a(index).func_190916_E() == 0) {
                    this.func_70299_a(index, ItemStack.field_190927_a);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return itemstack;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (!this.func_70301_a(index).func_190926_b()) {
            itemstack = this.func_70301_a(index);
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
        return itemstack;
    }

    @ParametersAreNonnullByDefault
    public void func_70299_a(int index, ItemStack newContent) {
        if (this.currentInventory != null && index >= 0 && index < this.currentInventory.length) {
            this.currentInventory[index] = newContent;
            if (!newContent.func_190926_b() && newContent.func_190916_E() > this.func_70297_j_()) {
                newContent.func_190920_e(this.func_70297_j_());
            }
            this.updateUsedSlots();
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @ParametersAreNonnullByDefault
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void func_174889_b(EntityPlayer player) {
    }

    @ParametersAreNonnullByDefault
    public void func_174886_c(EntityPlayer player) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        if (this.currentInventory != null) {
            for (int i = 0; i < this.currentInventory.length; ++i) {
                this.currentInventory[i] = ItemStack.field_190927_a;
            }
        }
    }

    @MethodsReturnNonnullByDefault
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.backpack.func_82833_r() : this.backpack.func_77977_a() + ".name";
    }

    public boolean func_145818_k_() {
        return this.backpack.func_82837_s();
    }

    @MethodsReturnNonnullByDefault
    public ITextComponent func_145748_c_() {
        Object component = this.func_145818_k_() ? new TextComponentString(this.backpack.func_82833_r()) : new TextComponentTranslation(this.backpack.func_77977_a(), new Object[0]);
        return component;
    }

    public void func_70296_d() {
        super.func_76185_a();
    }

    private void updateUsedSlots() {
        int slotsUsed = 0;
        for (ItemStack itemStack : this.currentInventory) {
            if (itemStack.func_190926_b()) continue;
            ++slotsUsed;
        }
        BackpackHelper.setSlotsUsed(BackpackHelper.getBackpackFromPlayer(this.player, this.heldItem), slotsUsed);
    }
}

