/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.misc;

import de.eydamos.backpack.init.BackpackItems;
import de.eydamos.backpack.item.EFrame;
import de.eydamos.backpack.item.EPiece;
import de.eydamos.backpack.item.EStick;
import de.eydamos.backpack.tier.TierFrame;
import de.eydamos.backpack.tier.TierLeather;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum EItemStack {
    BOUND_LEATHER(BackpackItems.bound_leather, 0, new Object[0]),
    TANNED_LEATHER(BackpackItems.tanned_leather, 0, new Object[0]),
    STICK_STONE(BackpackItems.stick, EStick.STONE.getDamage(), new Object[0]),
    STICK_IRON(BackpackItems.stick, EStick.IRON.getDamage(), new Object[0]),
    FRAME_WOOD(BackpackItems.backpack_frame, EFrame.WOOD.getDamage(), new Object[0]),
    FRAME_STONE(BackpackItems.backpack_frame, EFrame.STONE.getDamage(), new Object[0]),
    FRAME_IRON(BackpackItems.backpack_frame, EFrame.IRON.getDamage(), new Object[0]),
    BACKPACK_PICE_TOP(BackpackItems.backpack_piece, EPiece.TOP.getDamage(), "leather_tier", TierLeather.III.name(), "frame_tier", TierFrame.III.name()),
    BACKPACK_PICE_MIDDLE(BackpackItems.backpack_piece, EPiece.MIDDLE.getDamage(), "leather_tier", TierLeather.III.name(), "frame_tier", TierFrame.III.name()),
    BACKPACK_PICE_BOTTOM(BackpackItems.backpack_piece, EPiece.BOTTOM.getDamage(), "leather_tier", TierLeather.III.name(), "frame_tier", TierFrame.III.name());

    protected Item item;
    protected int damage;
    protected NBTTagCompound nbtTagCompound;

    private EItemStack(Item item, int damage, Object ... nbtData) {
        this.item = item;
        this.damage = damage;
        this.nbtTagCompound = new NBTTagCompound();
        for (int i = 0; i < nbtData.length; i += 2) {
            String key = String.valueOf(nbtData[i]);
            String value = String.valueOf(nbtData[i + 1]);
            this.nbtTagCompound.func_74778_a(key, value);
        }
    }

    public ItemStack getItemStack(int amount) {
        ItemStack itemStack = new ItemStack(this.item, amount, this.damage);
        if (!this.nbtTagCompound.func_82582_d()) {
            itemStack.func_77982_d(this.nbtTagCompound);
        }
        return itemStack;
    }

    public static ItemStack getItemStack(Item item, int amount, int damage) {
        for (EItemStack eItem : EItemStack.values()) {
            if (!eItem.item.equals(item) || eItem.damage != damage) continue;
            return eItem.getItemStack(amount);
        }
        return new ItemStack(item, amount, damage);
    }
}

