/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import java.util.Hashtable;

public enum EPiece {
    TOP(0, "top"),
    MIDDLE(1, "middle"),
    BOTTOM(2, "bottom");

    private static Hashtable<Integer, String> VARIANTS;
    private final int damage;
    private final String identifier;

    private EPiece(int damage, String identifier) {
        this.damage = damage;
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getDamage() {
        return this.damage;
    }

    public static String getIdentifierByDamage(int damage) {
        for (EPiece piece : EPiece.values()) {
            if (piece.getDamage() != damage) continue;
            return piece.identifier;
        }
        return "";
    }

    public static Hashtable<Integer, String> getVariants() {
        return VARIANTS;
    }

    static {
        VARIANTS = new Hashtable();
        for (EPiece piece : EPiece.values()) {
            VARIANTS.put(piece.getDamage(), piece.getIdentifier());
        }
    }
}

