/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.registry;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFactory<E> {
    protected final WorldEdit worldEdit;
    protected final List<InputParser<E>> parsers = new ArrayList<InputParser<E>>();

    protected AbstractFactory(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    public E parseFromInput(String input, ParserContext context) throws InputParseException {
        for (InputParser<E> parser : this.parsers) {
            E match = parser.parseFromInput(input, context);
            if (match == null) continue;
            return match;
        }
        throw new NoMatchException("No match for '" + input + "'");
    }
}

