/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModFortify
extends ToolModifier {
    public final Material material;

    public ModFortify(Material material) {
        super("fortify" + material.getIdentifier(), material.materialTextColor);
        if (!material.hasStats("head")) {
            throw new TinkerAPIException(String.format("Trying to add a fortify-modifier for a material without tool stats: %s", material.getIdentifier()));
        }
        this.material = material;
        this.addAspects(new ModifierAspect.SingleAspect(this), new ModifierAspect.DataAspect(this), ModifierAspect.harvestOnly);
        ItemStack kit = TinkerTools.sharpeningKit.getItemstackWithMaterial(material);
        ItemStack flint = new ItemStack(Items.field_151145_ak);
        this.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{kit, flint}));
    }

    @Override
    public String getLocalizedName() {
        return Util.translate("modifier.%s.name", "fortify") + " (" + this.material.getLocalizedName() + ")";
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translateFormatted(String.format("modifier.%s.desc", "fortify"), this.material.getLocalizedName());
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        NBTTagCompound tag = TagUtil.getToolTag(rootCompound);
        HeadMaterialStats stats = (HeadMaterialStats)this.material.getStats("head");
        tag.func_74768_a("HarvestLevel", stats.harvestLevel);
        NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound mod = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(mod);
            if (data.identifier.equals(this.identifier)) break;
            if (!data.identifier.startsWith("fortify")) continue;
            tagList.func_74744_a(i);
            --i;
        }
        TagUtil.setModifiersTagList(rootCompound, tagList);
    }

    @Override
    public boolean hasTexturePerMaterial() {
        return true;
    }
}

