/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import com.google.common.collect.ImmutableMap;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.item.ItemThrowball;

public class BlockGlow
extends Block {
    public static PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;

    public BlockGlow() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        if (TinkerGadgets.throwball != null) {
            return new ItemStack((Item)TinkerGadgets.throwball, 1, ItemThrowball.ThrowballType.GLOW.ordinal());
        }
        return ItemStack.field_190927_a;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            worldIn.func_175698_g(pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    protected boolean canBlockStay(World world, BlockPos pos, EnumFacing facing) {
        BlockPos placedOn = pos.func_177972_a(facing);
        boolean isSolidSide = world.func_180495_p(placedOn).isSideSolid((IBlockAccess)world, placedOn, facing.func_176734_d());
        boolean isLiquid = world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid;
        return !isLiquid && isSolidSide;
    }

    public boolean addGlow(World world, BlockPos pos, EnumFacing facing) {
        IBlockState oldState = world.func_180495_p(pos);
        if (oldState.func_177230_c().func_149688_o(oldState).func_76222_j()) {
            if (this.canBlockStay(world, pos, facing)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing));
                }
                return true;
            }
            for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
                if (!this.canBlockStay(world, pos, enumfacing)) continue;
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing));
                }
                return true;
            }
        }
        return false;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0));
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
        BOUNDS = builder.build();
    }
}

