/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.crosshair;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;

@SideOnly(value=Side.CLIENT)
public final class CrosshairRenderEvents {
    public static final CrosshairRenderEvents INSTANCE = new CrosshairRenderEvents();
    private static final Minecraft mc = Minecraft.func_71410_x();

    private CrosshairRenderEvents() {
    }

    @SubscribeEvent
    public void onCrosshairRender(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        EntityPlayerSP entityPlayer = CrosshairRenderEvents.mc.field_71439_g;
        ItemStack itemStack = this.getItemstack((EntityPlayer)entityPlayer);
        if (itemStack.func_190926_b()) {
            return;
        }
        ICustomCrosshairUser customCrosshairUser = (ICustomCrosshairUser)itemStack.func_77973_b();
        ICrosshair crosshair = customCrosshairUser.getCrosshair(itemStack, (EntityPlayer)entityPlayer);
        if (crosshair == ICrosshair.DEFAULT) {
            return;
        }
        float width = event.getResolution().func_78326_a();
        float height = event.getResolution().func_78328_b();
        crosshair.render(customCrosshairUser.getCrosshairState(itemStack, (EntityPlayer)entityPlayer), width, height, event.getPartialTicks());
        event.setCanceled(true);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        if (CrosshairRenderEvents.mc.field_71474_y.field_186716_M == 1) {
            int resW = event.getResolution().func_78326_a();
            int resH = event.getResolution().func_78328_b();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179141_d();
            float f = CrosshairRenderEvents.mc.field_71439_g.func_184825_o(0.0f);
            if (f < 1.0f) {
                int i = resH / 2 - 7 + 16;
                int j = resW / 2 - 7;
                int k = (int)(f * 17.0f);
                CrosshairRenderEvents.mc.field_71456_v.func_73729_b(j, i, 36, 94, 16, 4);
                CrosshairRenderEvents.mc.field_71456_v.func_73729_b(j, i, 52, 94, k, 4);
            }
        }
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179084_k();
    }

    @Nonnull
    private ItemStack getItemstack(EntityPlayer entityPlayer) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (entityPlayer.func_184587_cr() && this.isValidItem(entityPlayer.func_184607_cu())) {
            itemStack = entityPlayer.func_184607_cu();
        }
        if (itemStack.func_190926_b() && this.isValidItem(entityPlayer.func_184614_ca())) {
            itemStack = entityPlayer.func_184614_ca();
        }
        if (itemStack.func_190926_b() && this.isValidItem(entityPlayer.func_184592_cb())) {
            itemStack = entityPlayer.func_184592_cb();
        }
        return itemStack;
    }

    private boolean isValidItem(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ICustomCrosshairUser;
    }
}

