/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.gadgets.tileentity.TileSlimeChannel;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockSlime;

public class BlockSlimeChannel
extends EnumBlock<BlockSlime.SlimeType>
implements ITileEntityProvider {
    public static final PropertyDirection SIDE = PropertyDirection.func_177714_a((String)"side");
    public static final PropertyEnum<ChannelDirection> DIRECTION = PropertyEnum.func_177709_a((String)"direction", ChannelDirection.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<ChannelConnected> CONNECTED = PropertyEnum.func_177709_a((String)"connected", ChannelConnected.class);
    public static final PropertyEnum<BlockSlime.SlimeType> TYPE = BlockSlime.TYPE;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> LOWER_BOUNDS;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> SIDE_BOUNDS;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> UPPER_BOUNDS;

    public BlockSlimeChannel() {
        super(Material.field_151571_B, TYPE, BlockSlime.SlimeType.class);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE, (Comparable)((Object)BlockSlime.SlimeType.GREEN)).func_177226_a((IProperty)SIDE, (Comparable)EnumFacing.DOWN).func_177226_a(DIRECTION, (Comparable)((Object)ChannelDirection.NORTH)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a(CONNECTED, (Comparable)((Object)ChannelConnected.NONE)));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGadgets);
        this.field_149758_A = true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, SIDE, DIRECTION, POWERED, CONNECTED});
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileSlimeChannel();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BlockSlime.SlimeType.fromMeta(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((BlockSlime.SlimeType)((Object)state.func_177229_b(TYPE))).getMeta();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.addDataFromTE(state, source, pos);
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SIDE);
        EnumFacing flow = ((ChannelDirection)((Object)state.func_177229_b(DIRECTION))).getFlow(side);
        BlockPos offset = pos.func_177972_a(side.func_176734_d());
        IBlockState check = source.func_180495_p(offset);
        if (check.func_177230_c() == this && ((EnumFacing)this.addDataFromTE(check, source, offset).func_177229_b((IProperty)SIDE)).func_176734_d() == flow) {
            return state.func_177226_a(CONNECTED, (Comparable)((Object)ChannelConnected.OUTER));
        }
        offset = pos.func_177972_a(side);
        check = source.func_180495_p(offset);
        if (check.func_177230_c() == this && this.addDataFromTE(check, source, offset).func_177229_b((IProperty)SIDE) == flow) {
            return state.func_177226_a(CONNECTED, (Comparable)((Object)ChannelConnected.INNER));
        }
        return state.func_177226_a(CONNECTED, (Comparable)((Object)ChannelConnected.NONE));
    }

    private IBlockState addDataFromTE(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TileSlimeChannel) {
            TileSlimeChannel channel = (TileSlimeChannel)te;
            return state.func_177226_a((IProperty)SIDE, (Comparable)channel.getSide()).func_177226_a(DIRECTION, (Comparable)((Object)channel.getDirection()));
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BlockSlime.SlimeType.fromMeta(meta))).func_177226_a((IProperty)SIDE, (Comparable)facing.func_176734_d()).func_177226_a(DIRECTION, (Comparable)((Object)this.getPlacement(facing.func_176734_d(), hitX, hitY, hitZ, placer)));
    }

    private ChannelDirection getPlacement(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        ChannelDirection direction;
        int u = 0;
        int v = 0;
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            u = (int)(hitX * 16.0f);
            v = (int)(hitZ * 16.0f);
        } else {
            v = 15 - (int)(hitY * 16.0f);
            switch (side) {
                case NORTH: {
                    u = (int)(hitX * 16.0f);
                    break;
                }
                case SOUTH: {
                    u = 15 - (int)(hitX * 16.0f);
                    break;
                }
                case WEST: {
                    u = 15 - (int)(hitZ * 16.0f);
                    break;
                }
                case EAST: {
                    u = (int)(hitZ * 16.0f);
                }
            }
        }
        if (v < 5) {
            direction = u < 5 ? ChannelDirection.NORTHWEST : (u > 10 ? ChannelDirection.NORTHEAST : ChannelDirection.NORTH);
        } else if (v > 10) {
            direction = u < 5 ? ChannelDirection.SOUTHWEST : (u > 10 ? ChannelDirection.SOUTHEAST : ChannelDirection.SOUTH);
        } else if (u < 5) {
            direction = ChannelDirection.WEST;
        } else if (u > 10) {
            direction = ChannelDirection.EAST;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
            direction = ChannelDirection.fromIndex(facing);
            if (side.func_176740_k() != EnumFacing.Axis.Y) {
                switch (side) {
                    case SOUTH: {
                        direction = direction.getOpposite();
                        break;
                    }
                    case WEST: {
                        direction = direction.rotate90();
                        break;
                    }
                    case EAST: {
                        direction = direction.rotate90().getOpposite();
                    }
                }
            }
        }
        if (direction != null && placer.func_70093_af()) {
            direction = direction.getOpposite();
        }
        return direction;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSlimeChannel) {
            TileSlimeChannel channel = (TileSlimeChannel)te;
            channel.setSide((EnumFacing)state.func_177229_b((IProperty)SIDE));
            channel.setDirection((ChannelDirection)((Object)state.func_177229_b(DIRECTION)));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockSlime.SlimeType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            ChannelConnected connected;
            AxisAlignedBB entityAABB = entity.func_70046_E();
            if (entityAABB == null) {
                entityAABB = entity.func_174813_aQ();
            }
            double speed = 0.01;
            boolean item = false;
            if (entity instanceof EntityItem) {
                speed *= 1.5;
                item = true;
            }
            Motion motion = new Motion();
            boolean inBounds = false;
            state = state.func_185899_b((IBlockAccess)world, pos);
            EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SIDE);
            if (entityAABB.func_72326_a(this.getBounds(state, (IBlockAccess)world, pos).func_186670_a(pos))) {
                inBounds = true;
                if (entity.func_70089_S()) {
                    entity.func_70050_g(300);
                }
                entity.func_70015_d(0);
                entity.field_70143_R = 0.0f;
                List<EnumFacing> flow = ((ChannelDirection)((Object)state.func_177229_b(DIRECTION))).getFlowDiagonals(side);
                if (!flow.contains(EnumFacing.DOWN) && entity.field_70181_x < 0.0) {
                    entity.field_70181_x /= 2.0;
                }
                if (flow.contains(EnumFacing.UP) && item) {
                    entity.field_70122_E = false;
                }
                for (EnumFacing facing : flow) {
                    motion.boost(facing, speed);
                }
            }
            if ((connected = (ChannelConnected)((Object)state.func_177229_b(CONNECTED))) == ChannelConnected.OUTER && entityAABB.func_72326_a(this.getSecondaryBounds(state).func_186670_a(pos))) {
                if (!inBounds) {
                    if (side != EnumFacing.DOWN && entity.field_70181_x < 0.0) {
                        entity.field_70181_x /= 2.0;
                    }
                    if (entity.func_70089_S()) {
                        entity.func_70050_g(300);
                    }
                    entity.func_70015_d(0);
                    entity.field_70143_R = 0.0f;
                }
                if (side == EnumFacing.UP && item) {
                    entity.field_70122_E = false;
                }
                motion.boost(side, speed);
            }
            entity.func_70024_g(motion.x, motion.y, motion.z);
        }
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        if (material != Material.field_151586_h) {
            return null;
        }
        AxisAlignedBB entityAABB = entity.func_70046_E();
        if (entityAABB == null) {
            entityAABB = entity.func_174813_aQ();
        }
        if (entityAABB.func_72326_a(this.getBounds(state = state.func_185899_b(world, pos), world, pos).func_186670_a(pos))) {
            return Boolean.TRUE;
        }
        if (state.func_177229_b(CONNECTED) == ChannelConnected.OUTER && entityAABB.func_72326_a(this.getSecondaryBounds(state).func_186670_a(pos))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateState(worldIn, pos, state);
    }

    public void updateState(World world, BlockPos pos, IBlockState state) {
        boolean powered = world.func_175640_z(pos);
        if (powered != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBounds(state.func_185899_b(source, pos), source, pos);
    }

    private AxisAlignedBB getBounds(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SIDE);
        EnumFacing facing = ((ChannelDirection)((Object)state.func_177229_b(DIRECTION))).getFacing();
        ChannelConnected connected = (ChannelConnected)((Object)state.func_177229_b(CONNECTED));
        if (connected == ChannelConnected.INNER && facing != null) {
            if (side == EnumFacing.DOWN) {
                return (AxisAlignedBB)LOWER_BOUNDS.get((Object)facing);
            }
            if (side == EnumFacing.UP) {
                return (AxisAlignedBB)UPPER_BOUNDS.get((Object)facing);
            }
            switch (facing) {
                case NORTH: {
                    return (AxisAlignedBB)UPPER_BOUNDS.get((Object)side);
                }
                case SOUTH: {
                    return (AxisAlignedBB)LOWER_BOUNDS.get((Object)side);
                }
                case WEST: {
                    return (AxisAlignedBB)SIDE_BOUNDS.get((Object)side);
                }
                case EAST: {
                    return (AxisAlignedBB)SIDE_BOUNDS.get((Object)side.func_176746_e());
                }
            }
        }
        return (AxisAlignedBB)BOUNDS.get((Object)side);
    }

    private AxisAlignedBB getSecondaryBounds(IBlockState state) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SIDE);
        EnumFacing facing = ((ChannelDirection)((Object)state.func_177229_b(DIRECTION))).getFacing();
        if (facing == null) {
            return field_185505_j;
        }
        if (side == EnumFacing.DOWN) {
            return (AxisAlignedBB)UPPER_BOUNDS.get((Object)facing.func_176734_d());
        }
        if (side == EnumFacing.UP) {
            return (AxisAlignedBB)LOWER_BOUNDS.get((Object)facing.func_176734_d());
        }
        switch (facing) {
            case NORTH: {
                return (AxisAlignedBB)LOWER_BOUNDS.get((Object)side.func_176734_d());
            }
            case SOUTH: {
                return (AxisAlignedBB)UPPER_BOUNDS.get((Object)side.func_176734_d());
            }
            case WEST: {
                return (AxisAlignedBB)SIDE_BOUNDS.get((Object)side.func_176734_d());
            }
            case EAST: {
                return (AxisAlignedBB)SIDE_BOUNDS.get((Object)side.func_176735_f());
            }
        }
        return field_185505_j;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing face) {
        int knightminers_sanity_percentage_after_writing_function = 14;
        if (!super.func_176225_a(state, blockAccess, pos, face)) {
            return false;
        }
        IBlockState offset = blockAccess.func_180495_p(pos.func_177972_a(face));
        if (offset.func_177230_c() != this) {
            return true;
        }
        if (state.func_177229_b(TYPE) != offset.func_177229_b(TYPE)) {
            return true;
        }
        state = state.func_185899_b(blockAccess, pos);
        offset = offset.func_185899_b(blockAccess, pos.func_177972_a(face));
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SIDE);
        ChannelConnected connected = (ChannelConnected)((Object)state.func_177229_b(CONNECTED));
        EnumFacing flow = ((ChannelDirection)((Object)state.func_177229_b(DIRECTION))).getFlow(side);
        EnumFacing offsetSide = (EnumFacing)offset.func_177229_b((IProperty)SIDE);
        ChannelConnected offsetConnected = (ChannelConnected)((Object)offset.func_177229_b(CONNECTED));
        EnumFacing offsetFlow = ((ChannelDirection)((Object)offset.func_177229_b(DIRECTION))).getFlow(offsetSide);
        if (flow == null) {
            connected = ChannelConnected.NONE;
        }
        if (offsetFlow == null) {
            offsetConnected = ChannelConnected.NONE;
        }
        if (face == side) {
            if (connected == ChannelConnected.INNER) {
                return !BlockSlimeChannel.hasHalfSide(flow, face, offsetSide, offsetFlow, offsetConnected);
            }
            return !BlockSlimeChannel.hasFullSide(face, offsetSide, offsetFlow, offsetConnected);
        }
        if (face == side.func_176734_d()) {
            if (connected == ChannelConnected.OUTER) {
                return !BlockSlimeChannel.hasHalfSide(flow.func_176734_d(), face, offsetSide, offsetFlow, offsetConnected);
            }
            return true;
        }
        if (face == flow) {
            return !BlockSlimeChannel.hasHalfSide(side, face, offsetSide, offsetFlow, offsetConnected);
        }
        if (face.func_176734_d() == flow) {
            switch (connected) {
                case INNER: {
                    return true;
                }
                case OUTER: {
                    return !BlockSlimeChannel.hasFullSide(face, offsetSide, offsetFlow, offsetConnected);
                }
                case NONE: {
                    return !BlockSlimeChannel.hasHalfSide(side, face, offsetSide, offsetFlow, offsetConnected);
                }
            }
        }
        switch (connected) {
            case NONE: {
                return !BlockSlimeChannel.hasHalfSide(side, face, offsetSide, offsetFlow, offsetConnected);
            }
            case OUTER: {
                if (BlockSlimeChannel.hasFullSide(face, offsetSide, offsetFlow, offsetConnected)) {
                    return false;
                }
                if (offsetConnected == ChannelConnected.OUTER) {
                    if (offsetSide == side) {
                        return offsetFlow != flow;
                    }
                    if (offsetSide == flow.func_176734_d()) {
                        return offsetFlow != side.func_176734_d();
                    }
                    return true;
                }
                return true;
            }
            case INNER: {
                if (offsetSide == side || offsetSide == face.func_176734_d() || offsetSide == flow) {
                    return offsetConnected == ChannelConnected.INNER && (offsetFlow == side.func_176734_d() || offsetFlow == face || offsetFlow == flow.func_176734_d());
                }
                return offsetConnected != ChannelConnected.OUTER || offsetFlow != face && offsetFlow != side.func_176734_d() && offsetFlow != flow.func_176734_d();
            }
        }
        return true;
    }

    private static boolean hasFullSide(EnumFacing orginFace, EnumFacing side, EnumFacing flow, ChannelConnected connected) {
        if (orginFace == side.func_176734_d() && connected != ChannelConnected.INNER) {
            return true;
        }
        return orginFace == flow && connected == ChannelConnected.OUTER;
    }

    private static boolean hasHalfSide(EnumFacing orginHalf, EnumFacing orginFace, EnumFacing side, EnumFacing flow, ChannelConnected connected) {
        if (side == orginHalf) {
            if (connected == ChannelConnected.INNER) {
                return flow == orginFace.func_176734_d();
            }
            return true;
        }
        if (side == orginFace.func_176734_d()) {
            if (connected == ChannelConnected.INNER) {
                return flow == orginHalf;
            }
            return true;
        }
        if (side == orginFace) {
            return connected == ChannelConnected.OUTER && flow == orginHalf.func_176734_d();
        }
        if (connected == ChannelConnected.OUTER) {
            if (flow == orginFace) {
                return true;
            }
            if (side == orginHalf.func_176734_d()) {
                return false;
            }
            return flow == orginHalf.func_176734_d();
        }
        return false;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0));
        BOUNDS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0));
        LOWER_BOUNDS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 1.0, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.5));
        SIDE_BOUNDS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0));
        UPPER_BOUNDS = builder.build();
    }

    public static class EventHandler {
        public static final EventHandler instance = new EventHandler();

        private EventHandler() {
        }

        @SubscribeEvent
        public void onItemExpire(ItemExpireEvent event) {
            EntityItem item = event.getEntityItem();
            if (item.func_130014_f_().func_180495_p(item.func_180425_c()).func_177230_c() instanceof BlockSlimeChannel) {
                event.setCanceled(true);
            }
        }
    }

    private static class Motion {
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;

        public Motion boost(EnumFacing facing, double speed) {
            switch (facing) {
                case UP: {
                    this.y += speed * 3.0;
                    break;
                }
                case DOWN: {
                    this.y -= speed;
                    break;
                }
                case NORTH: {
                    this.z -= speed;
                    break;
                }
                case SOUTH: {
                    this.z += speed;
                    break;
                }
                case WEST: {
                    this.x -= speed;
                    break;
                }
                case EAST: {
                    this.x += speed;
                }
            }
            return this;
        }
    }

    public static enum ChannelConnected implements IStringSerializable
    {
        NONE,
        INNER,
        OUTER;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }

    public static enum ChannelDirection implements IStringSerializable
    {
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST;

        public final int index = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getIndex() {
            return this.index;
        }

        public static ChannelDirection fromIndex(int index) {
            if (index < 0 || index >= ChannelDirection.values().length) {
                index = 0;
            }
            return ChannelDirection.values()[index];
        }

        public ChannelDirection getOpposite() {
            switch (this) {
                case SOUTH: {
                    return NORTH;
                }
                case SOUTHWEST: {
                    return NORTHEAST;
                }
                case WEST: {
                    return EAST;
                }
                case NORTHWEST: {
                    return SOUTHEAST;
                }
                case NORTH: {
                    return SOUTH;
                }
                case NORTHEAST: {
                    return SOUTHWEST;
                }
                case EAST: {
                    return WEST;
                }
                case SOUTHEAST: {
                    return NORTHWEST;
                }
            }
            return null;
        }

        public ChannelDirection rotate90() {
            switch (this) {
                case SOUTH: {
                    return WEST;
                }
                case SOUTHWEST: {
                    return NORTHWEST;
                }
                case WEST: {
                    return NORTH;
                }
                case NORTHWEST: {
                    return NORTHEAST;
                }
                case NORTH: {
                    return EAST;
                }
                case NORTHEAST: {
                    return SOUTHEAST;
                }
                case EAST: {
                    return SOUTH;
                }
                case SOUTHEAST: {
                    return SOUTHWEST;
                }
            }
            throw new IllegalArgumentException("Unknown enum value? Impossibru!");
        }

        public EnumFacing getFacing() {
            switch (this) {
                case NORTH: {
                    return EnumFacing.NORTH;
                }
                case SOUTH: {
                    return EnumFacing.SOUTH;
                }
                case WEST: {
                    return EnumFacing.WEST;
                }
                case EAST: {
                    return EnumFacing.EAST;
                }
            }
            return null;
        }

        public ChannelDirection fromFacing(EnumFacing facing) {
            switch (facing) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            return null;
        }

        @Nullable
        public EnumFacing getFlow(EnumFacing side) {
            switch (side) {
                case NORTH: {
                    switch (this) {
                        case NORTH: {
                            return EnumFacing.UP;
                        }
                        case SOUTH: {
                            return EnumFacing.DOWN;
                        }
                        case WEST: {
                            return EnumFacing.WEST;
                        }
                        case EAST: {
                            return EnumFacing.EAST;
                        }
                    }
                }
                case SOUTH: {
                    switch (this) {
                        case NORTH: {
                            return EnumFacing.UP;
                        }
                        case SOUTH: {
                            return EnumFacing.DOWN;
                        }
                        case WEST: {
                            return EnumFacing.EAST;
                        }
                        case EAST: {
                            return EnumFacing.WEST;
                        }
                    }
                }
                case WEST: {
                    switch (this) {
                        case NORTH: {
                            return EnumFacing.UP;
                        }
                        case SOUTH: {
                            return EnumFacing.DOWN;
                        }
                        case WEST: {
                            return EnumFacing.SOUTH;
                        }
                        case EAST: {
                            return EnumFacing.NORTH;
                        }
                    }
                }
                case EAST: {
                    switch (this) {
                        case NORTH: {
                            return EnumFacing.UP;
                        }
                        case SOUTH: {
                            return EnumFacing.DOWN;
                        }
                        case WEST: {
                            return EnumFacing.NORTH;
                        }
                        case EAST: {
                            return EnumFacing.SOUTH;
                        }
                    }
                }
            }
            return this.getFacing();
        }

        public List<EnumFacing> getFlowDiagonals(@Nonnull EnumFacing side) {
            switch (this) {
                case NORTH: {
                    return ImmutableList.of((Object)NORTH.getFlow(side));
                }
                case SOUTH: {
                    return ImmutableList.of((Object)SOUTH.getFlow(side));
                }
                case WEST: {
                    return ImmutableList.of((Object)WEST.getFlow(side));
                }
                case EAST: {
                    return ImmutableList.of((Object)EAST.getFlow(side));
                }
                case NORTHWEST: {
                    return ImmutableList.of((Object)NORTH.getFlow(side), (Object)WEST.getFlow(side));
                }
                case NORTHEAST: {
                    return ImmutableList.of((Object)NORTH.getFlow(side), (Object)EAST.getFlow(side));
                }
                case SOUTHWEST: {
                    return ImmutableList.of((Object)SOUTH.getFlow(side), (Object)WEST.getFlow(side));
                }
                case SOUTHEAST: {
                    return ImmutableList.of((Object)SOUTH.getFlow(side), (Object)EAST.getFlow(side));
                }
            }
            return ImmutableList.of();
        }
    }
}

