/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiDotColors
extends GuiScreen {
    private IXaeroMinimap modMain;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private ArrayList<GuiDropDown> dropDowns;
    private String[] colorOptions;
    private boolean[] displaySettingsChanged;
    private boolean dropped;

    public GuiDotColors(IXaeroMinimap modMain, GuiScreen par1GuiScreen) {
        this.modMain = modMain;
        this.parentGuiScreen = par1GuiScreen;
        this.dropDowns = new ArrayList();
        this.displaySettingsChanged = new boolean[6];
    }

    private String getButtonText(ModOptions par1EnumOptions) {
        String s = "";
        int id = this.settingIdForEnum(par1EnumOptions);
        boolean changed = this.displaySettingsChanged[id];
        boolean currentClientSetting = this.modMain.getSettings().getClientBooleanValue(par1EnumOptions);
        boolean clientSetting = changed ? !currentClientSetting : currentClientSetting;
        boolean serverSetting = this.modMain.getSettings().getBooleanValue(par1EnumOptions);
        s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != currentClientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
        return s;
    }

    public void func_73866_w_() {
        this.screenTitle = I18n.func_135052_a((String)"gui.xaero_entity_radar", (Object[])new Object[0]);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.dropDowns.clear();
        this.colorOptions = this.createColorOptions();
        String[] playerOptions = new String[this.colorOptions.length + 1];
        String[] teamOptions = new String[this.colorOptions.length + 1];
        for (int i = 0; i < this.colorOptions.length; ++i) {
            playerOptions[i] = this.colorOptions[i];
            teamOptions[i + 1] = this.colorOptions[i];
        }
        playerOptions[this.colorOptions.length] = "gui.xaero_team_colours";
        teamOptions[0] = "gui.xaero_players";
        this.dropDowns.add(new GuiDropDown(this.colorOptions, this.field_146294_l / 2 - 60, this.field_146295_m / 7 + 70, 120, this.modMain.getSettings().mobsColor));
        this.field_146292_n.add(new MyTinyButton(ModOptions.MOBS.returnEnumOrdinal(), this.field_146294_l / 2 + 63, this.field_146295_m / 7 + 66, ModOptions.MOBS, this.getButtonText(ModOptions.MOBS)));
        this.dropDowns.add(new GuiDropDown(this.colorOptions, this.field_146294_l / 2 - 60, this.field_146295_m / 7 + 95, 120, this.modMain.getSettings().hostileColor));
        this.field_146292_n.add(new MyTinyButton(ModOptions.HOSTILE.returnEnumOrdinal(), this.field_146294_l / 2 + 63, this.field_146295_m / 7 + 91, ModOptions.HOSTILE, this.getButtonText(ModOptions.HOSTILE)));
        this.dropDowns.add(new GuiDropDown(this.colorOptions, this.field_146294_l / 2 - 60, this.field_146295_m / 7 + 120, 120, this.modMain.getSettings().itemsColor));
        this.field_146292_n.add(new MyTinyButton(ModOptions.ITEMS.returnEnumOrdinal(), this.field_146294_l / 2 + 63, this.field_146295_m / 7 + 116, ModOptions.ITEMS, this.getButtonText(ModOptions.ITEMS)));
        this.dropDowns.add(new GuiDropDown(this.colorOptions, this.field_146294_l / 2 - 60, this.field_146295_m / 7 + 145, 120, this.modMain.getSettings().otherColor));
        this.field_146292_n.add(new MyTinyButton(ModOptions.ENTITIES.returnEnumOrdinal(), this.field_146294_l / 2 + 63, this.field_146295_m / 7 + 141, ModOptions.ENTITIES, this.getButtonText(ModOptions.ENTITIES)));
        this.dropDowns.add(new GuiDropDown(playerOptions, this.field_146294_l / 2 - 60, this.field_146295_m / 7 + 20, 120, this.modMain.getSettings().playersColor != -1 ? this.modMain.getSettings().playersColor : this.colorOptions.length));
        this.field_146292_n.add(new MyTinyButton(ModOptions.PLAYERS.returnEnumOrdinal(), this.field_146294_l / 2 + 63, this.field_146295_m / 7 + 16, ModOptions.PLAYERS, this.getButtonText(ModOptions.PLAYERS)));
        this.dropDowns.add(new GuiDropDown(teamOptions, this.field_146294_l / 2 - 60, this.field_146295_m / 7 + 45, 120, this.modMain.getSettings().otherTeamColor != -1 ? this.modMain.getSettings().otherTeamColor + 1 : 0));
        this.field_146292_n.add(new MyTinyButton(ModOptions.DISPLAY_OTHER_TEAM.returnEnumOrdinal(), this.field_146294_l / 2 + 63, this.field_146295_m / 7 + 41, ModOptions.DISPLAY_OTHER_TEAM, this.getButtonText(ModOptions.DISPLAY_OTHER_TEAM)));
    }

    private String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    private ModOptions settingEnumForId(int opt) {
        switch (opt) {
            case 0: {
                return ModOptions.PLAYERS;
            }
            case 1: {
                return ModOptions.DISPLAY_OTHER_TEAM;
            }
            case 2: {
                return ModOptions.MOBS;
            }
            case 3: {
                return ModOptions.HOSTILE;
            }
            case 4: {
                return ModOptions.ITEMS;
            }
        }
        return ModOptions.ENTITIES;
    }

    private int settingIdForEnum(ModOptions opt) {
        if (opt == ModOptions.PLAYERS) {
            return 0;
        }
        if (opt == ModOptions.DISPLAY_OTHER_TEAM) {
            return 1;
        }
        if (opt == ModOptions.MOBS) {
            return 2;
        }
        if (opt == ModOptions.HOSTILE) {
            return 3;
        }
        if (opt == ModOptions.ITEMS) {
            return 4;
        }
        return 5;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof MyTinyButton) {
                boolean changed = this.displaySettingsChanged[this.settingIdForEnum(((MyTinyButton)par1GuiButton).returnModOptions())];
                this.displaySettingsChanged[this.settingIdForEnum((ModOptions)((MyTinyButton)par1GuiButton).returnModOptions())] = !changed;
                par1GuiButton.field_146126_j = this.getButtonText(((MyTinyButton)par1GuiButton).returnModOptions());
            }
            if (par1GuiButton.field_146127_k == 200) {
                this.modMain.getSettings().mobsColor = this.dropDowns.get(0).getSelected();
                this.modMain.getSettings().hostileColor = this.dropDowns.get(1).getSelected();
                this.modMain.getSettings().itemsColor = this.dropDowns.get(2).getSelected();
                this.modMain.getSettings().otherColor = this.dropDowns.get(3).getSelected();
                int playerOption = this.dropDowns.get(4).getSelected();
                int teamOption = this.dropDowns.get(5).getSelected();
                this.modMain.getSettings().playersColor = playerOption < this.colorOptions.length ? playerOption : -1;
                this.modMain.getSettings().otherTeamColor = teamOption > 0 ? teamOption - 1 : -1;
                for (int opt = 0; opt < this.displaySettingsChanged.length; ++opt) {
                    if (!this.displaySettingsChanged[opt]) continue;
                    try {
                        this.modMain.getSettings().setOptionValue(this.settingEnumForId(opt), 1);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2)) {
                d.mouseClicked(par1, par2, par3);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2)) {
                d.mouseClicked(par1, par2, par3);
                return;
            }
            d.setClosed(true);
        }
        super.func_73864_a(par1, par2, par3);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int k;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_players", (Object[])new Object[0]) + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 10, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_other_teams", (Object[])new Object[0]) + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 35, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_mobs", (Object[])new Object[0]) + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 60, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_hostile", (Object[])new Object[0]) + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 85, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_items", (Object[])new Object[0]) + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 110, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_other", (Object[])new Object[0]) + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 135, 0xFFFFFF);
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(par1, par2);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(par1, par2);
        }
    }
}

