/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.tree.GeneratorBasicTree;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorMahoganyTree
extends GeneratorBasicTree {
    public GeneratorMahoganyTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, boolean updateNeighbours, int leafLayers, int leavesOffset, int minLeavesRadius, int leavesLayerHeight, IBlockPosQuery placeVinesOn, float hangingChance, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, updateNeighbours, leafLayers, leavesOffset, minLeavesRadius, leavesLayerHeight, placeVinesOn, hangingChance, scatterYMethod);
    }

    @Override
    protected void generateTrunk(World world, BlockPos start, int height) {
        int endHeight = height - this.leafLayers;
        for (int layer = 0; layer <= endHeight - 3; ++layer) {
            BlockPos middlePos = start.func_177981_b(layer);
            if (!this.replace.matches(world, middlePos)) continue;
            this.setLog(world, middlePos);
        }
        BlockPos branchStartPos = start.func_177981_b(endHeight - 2);
        int branchHeight = this.leafLayers - 1 + 1;
        this.generateBranch(world, branchStartPos, EnumFacing.NORTH, branchHeight);
        this.generateBranch(world, branchStartPos, EnumFacing.EAST, branchHeight);
        this.generateBranch(world, branchStartPos, EnumFacing.SOUTH, branchHeight);
        this.generateBranch(world, branchStartPos, EnumFacing.WEST, branchHeight);
    }

    private void generateBranch(World world, BlockPos middle, EnumFacing direction, int height) {
        BlockPos pos = middle.func_177972_a(direction);
        if (this.replace.matches(world, pos)) {
            this.setLog(world, pos, direction.func_176740_k());
        }
        for (int i = 0; i <= height - 1; ++i) {
            pos = middle.func_177967_a(direction, 2).func_177981_b(i + 1);
            if (!this.replace.matches(world, pos)) continue;
            this.setLog(world, pos, EnumFacing.Axis.Y);
        }
        EnumFacing logDirection = direction.func_176746_e();
        for (int i = -1; i <= 1; ++i) {
            pos = middle.func_177967_a(direction, 3).func_177967_a(logDirection, i).func_177981_b(height - 1);
            if (!this.replace.matches(world, pos)) continue;
            this.setLog(world, pos, logDirection.func_176740_k());
        }
    }

    public static class Builder
    extends GeneratorBasicTree.InnerBuilder<Builder, GeneratorMahoganyTree>
    implements IGenerator.IGeneratorBuilder<GeneratorMahoganyTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.anything;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a, Material.field_151584_j);
            this.log = BlockBOPLog.paging.getVariantState(BOPWoods.MAHOGANY);
            this.leaves = BlockBOPLeaves.paging.getVariantState(BOPTrees.MAHOGANY);
            this.vine = null;
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.minHeight = 10;
            this.maxHeight = 15;
            this.leafLayers = 4;
            this.leavesOffset = 1;
            this.maxLeavesRadius = 1;
            this.leavesLayerHeight = 1;
            this.placeVinesOn = BlockQueries.air;
            this.hangingChance = 0.0f;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorMahoganyTree create() {
            return new GeneratorMahoganyTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, false, this.leafLayers, this.leavesOffset, this.maxLeavesRadius, this.leavesLayerHeight, this.placeVinesOn, this.hangingChance, this.scatterYMethod);
        }
    }
}

