/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.config;

import biomesoplenty.core.BiomesOPlenty;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GameplayConfigurationHandler {
    public static Configuration config;
    public static final String CONVENIENCE_SETTINGS = "Convenience Settings";
    public static boolean flowerDropsNeedShears;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GameplayConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            flowerDropsNeedShears = config.getBoolean("Flower Drops Need Shears", CONVENIENCE_SETTINGS, false, "Require shears to be used to collect flower drops.");
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Biomes O' Plenty has encountered a problem loading gameplay.cfg", (Throwable)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("biomesoplenty")) {
            GameplayConfigurationHandler.loadConfiguration();
        }
    }
}

