/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.common.block.BlockBOPDecoration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBOPDoubleDecoration
extends BlockBOPDecoration {
    public static final PropertyEnum HALF = PropertyEnum.func_177709_a((String)"half", Half.class);
    public float radius = 0.5f;
    public float height = 1.0f;
    public boolean fromTop = false;

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    public BlockBOPDoubleDecoration() {
        this(Material.field_151585_k);
    }

    public BlockBOPDoubleDecoration(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HALF, (Comparable)((Object)Half.LOWER)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)Half.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Half)((Object)state.func_177229_b((IProperty)HALF))).ordinal();
    }

    public BlockPos getLowerPos(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return pos;
        }
        return world.func_180495_p(pos).func_177229_b((IProperty)HALF) == Half.UPPER ? pos.func_177977_b() : pos;
    }

    public BlockPos getUpperPos(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return pos.func_177984_a();
        }
        return world.func_180495_p(pos).func_177229_b((IProperty)HALF) == Half.UPPER ? pos : pos.func_177984_a();
    }

    public IBlockState getLowerState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(this.getLowerPos(world, pos));
    }

    public IBlockState getUpperState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(this.getUpperPos(world, pos));
    }

    public boolean isValidDoubleBlock(IBlockAccess world, BlockPos pos) {
        IBlockState lowerState = this.getLowerState(world, pos);
        IBlockState upperState = this.getUpperState(world, pos);
        Block lowerBlock = lowerState.func_177230_c();
        Block upperBlock = upperState.func_177230_c();
        return lowerBlock instanceof BlockBOPDoubleDecoration && upperBlock instanceof BlockBOPDoubleDecoration && lowerBlock == upperBlock && lowerState.func_177229_b((IProperty)HALF) == Half.LOWER && upperState.func_177229_b((IProperty)HALF) == Half.UPPER;
    }

    @Override
    protected boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isValidDoubleBlock((IBlockAccess)worldIn, pos) && this.canBlockStay(worldIn, this.getLowerPos((IBlockAccess)worldIn, pos), state)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        return false;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()) && this.canBlockStay(world, pos, this.func_176203_a(meta))) {
            return this.func_176203_a(meta).func_177226_a((IProperty)HALF, (Comparable)((Object)Half.LOWER));
        }
        return world.func_180495_p(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176203_a(stack.func_77960_j()).func_177226_a((IProperty)HALF, (Comparable)((Object)Half.UPPER)), 3);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos lowerPos, IBlockState state) {
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b((IProperty)HALF) == Half.UPPER) {
            return this.getUpperDrops(world, pos, state, fortune);
        }
        return this.getLowerDrops(world, pos, state, fortune);
    }

    public List<ItemStack> getUpperDrops(IBlockAccess world, BlockPos upperPos, IBlockState upperState, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> getLowerDrops(IBlockAccess world, BlockPos lowerPos, IBlockState lowerState, int fortune) {
        return super.getDrops(world, lowerPos, lowerState, fortune);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!this.isValidDoubleBlock(world, pos)) {
            return drops;
        }
        drops.addAll(this.getUpperShearDrops(item, world, this.getUpperPos(world, pos), this.getUpperState(world, pos), fortune));
        drops.addAll(this.getLowerShearDrops(item, world, this.getLowerPos(world, pos), this.getLowerState(world, pos), fortune));
        return drops;
    }

    public List<ItemStack> getUpperShearDrops(ItemStack item, IBlockAccess world, BlockPos upperPos, IBlockState upperState, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> getLowerShearDrops(ItemStack item, IBlockAccess world, BlockPos lowerPos, IBlockState lowerState, int fortune) {
        return super.getDrops(world, lowerPos, lowerState, fortune);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state.func_177226_a((IProperty)HALF, (Comparable)((Object)Half.LOWER)));
    }

    public static enum Half implements IStringSerializable
    {
        LOWER,
        UPPER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

