/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.gui;

import biomesoplenty.client.gui.GuiBOPPageList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEnumButton<T extends Enum>
extends GuiButton {
    private T value;
    private String localizationStr;
    private final GuiBOPPageList.GuiResponder guiResponder;

    public GuiEnumButton(GuiBOPPageList.GuiResponder responder, int fieldId, int x, int y, String localizationStr, T initialValue) {
        super(fieldId, x, y, 150, 20, "");
        this.localizationStr = localizationStr;
        this.value = initialValue;
        this.field_146126_j = this.buildDisplayString();
        this.guiResponder = responder;
    }

    private String buildDisplayString() {
        return I18n.func_135052_a((String)this.localizationStr, (Object[])new Object[]{((Enum)this.value).toString()});
    }

    public void setValue(T value) {
        this.value = value;
        this.field_146126_j = this.buildDisplayString();
        this.guiResponder.handleEnumSelection(this.field_146127_k, ((Enum)value).ordinal());
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            ?[] values = this.value.getClass().getEnumConstants();
            int len = values.length;
            this.value = (Enum)values[(((Enum)this.value).ordinal() + 1) % len];
            this.field_146126_j = this.buildDisplayString();
            this.guiResponder.handleEnumSelection(this.field_146127_k, ((Enum)this.value).ordinal());
            return true;
        }
        return false;
    }
}

