/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.client.gui.teams.EnumLoadoutSlot;
import com.flansmod.client.gui.teams.GuiChooseLoadout;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.network.PacketLoadoutData;
import com.flansmod.common.network.PacketOpenRewardBox;
import com.flansmod.common.network.PacketRoundFinished;
import com.flansmod.common.network.PacketTeamSelect;
import com.flansmod.common.network.PacketVoting;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerClassCustom;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.teams.RewardBoxInstance;
import com.flansmod.common.teams.RoundFinishedData;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TeamsManagerRanked
extends TeamsManager {
    public static HashMap<UUID, PlayerRankData> rankData = new HashMap();
    public LoadoutPool currentPool;
    public float XPMultiplier = 1.0f;
    public RoundFinishedData roundFinishedTemplateData = new RoundFinishedData();

    public static TeamsManagerRanked GetInstance() {
        return (TeamsManagerRanked)TeamsManager.instance;
    }

    @Override
    public void startRound() {
        if (this.currentPool == null) {
            return;
        }
        for (EntityPlayer entityPlayer : TeamsManagerRanked.getPlayers()) {
            this.ProcessRankData((EntityPlayerMP)entityPlayer);
        }
        super.startRound();
        for (EntityPlayer entityPlayer : TeamsManagerRanked.getPlayers()) {
            PlayerData data = PlayerHandler.getPlayerData(entityPlayer);
            if (data == null || data.builder) continue;
            this.sendLoadoutData((EntityPlayerMP)entityPlayer);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.interRoundTimeLeft > 0 && this.time % 10L == 0L && this.roundFinishedTemplateData.votingOptions != null && this.roundFinishedTemplateData.votingOptions.length > 0) {
            PlayerData data;
            for (int i = 0; i < this.roundFinishedTemplateData.votingOptions.length; ++i) {
                this.roundFinishedTemplateData.votingOptions[i].numVotes = 0;
            }
            for (EntityPlayer entityPlayer : TeamsManagerRanked.getPlayers()) {
                data = PlayerHandler.getPlayerData(entityPlayer);
                if (data.builder || data.vote == 0 || data.vote - 1 >= this.roundFinishedTemplateData.votingOptions.length) continue;
                ++this.roundFinishedTemplateData.votingOptions[data.vote - 1].numVotes;
            }
            for (EntityPlayer entityPlayer : TeamsManagerRanked.getPlayers()) {
                data = PlayerHandler.getPlayerData(entityPlayer);
                if (data.builder) continue;
                TeamsManagerRanked.sendPacketToPlayer(new PacketVoting(this.roundFinishedTemplateData), (EntityPlayerMP)entityPlayer);
            }
        }
    }

    public void sendLoadoutData(EntityPlayerMP player) {
        PacketLoadoutData data = new PacketLoadoutData();
        Team[] availableTeams = this.currentRound.gametype.getTeamsCanSpawnAs(this.currentRound, (EntityPlayer)player);
        boolean playerIsOp = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH());
        Team[] allAvailableTeams = new Team[availableTeams.length + (playerIsOp ? 2 : 1)];
        System.arraycopy(availableTeams, 0, allAvailableTeams, 0, availableTeams.length);
        allAvailableTeams[availableTeams.length] = Team.spectators;
        data.teamsAvailable = allAvailableTeams;
        data.currentPool = this.currentPool;
        data.myRankData = rankData.get(player.func_110124_au());
        data.motd = this.motd;
        FlansMod.getPacketHandler().sendTo(data, player);
    }

    @Override
    public void onPlayerLogin(EntityPlayer player) {
        if (!rankData.containsKey(player.func_110124_au())) {
            PlayerRankData data = new PlayerRankData();
            if (this.currentPool != null) {
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < EnumLoadoutSlot.values().length; ++j) {
                        if (this.currentPool.defaultLoadouts[i].slots[j] == null) continue;
                        data.loadouts[i].slots[j] = this.currentPool.defaultLoadouts[i].slots[j].func_77946_l();
                    }
                }
            }
            rankData.put(player.func_110124_au(), data);
        }
        if (!enabled || this.currentRound == null) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            this.sendLoadoutData(playerMP);
            this.currentRound.gametype.playerJoined(playerMP);
        }
    }

    @Override
    public void onPlayerLogout(EntityPlayer player) {
        super.onPlayerLogout(player);
    }

    @Override
    public void OnPlayerKilled(EntityPlayerMP victim, DamageSource source) {
        EntityPlayerMP attacker;
        PlayerData attackerData;
        super.OnPlayerKilled(victim, source);
        PlayerData victimData = PlayerHandler.getPlayerData((EntityPlayer)victim);
        if (source.func_76346_g() instanceof EntityPlayerMP && (attackerData = PlayerHandler.getPlayerData((EntityPlayer)(attacker = (EntityPlayerMP)source.func_76346_g()))) != null && attackerData.team != null && attackerData.team != victimData.team) {
            TeamsManagerRanked.AwardXP(attacker, MathHelper.func_76141_d((float)((float)this.currentPool.XPForKill * this.XPMultiplier)));
            TeamsManagerRanked.AwardXP(victim, MathHelper.func_76141_d((float)((float)this.currentPool.XPForDeath * this.XPMultiplier)));
        }
    }

    public static void AwardXP(EntityPlayerMP player, int amount) {
        PlayerRankData data = rankData.get(player.func_110124_au());
        if (data != null) {
            data.AddXP(amount);
        }
    }

    public static void ResetRank(EntityPlayerMP player) {
        PlayerRankData data = rankData.get(player.func_110124_au());
        if (data != null) {
            data.currentLevel = 0;
            data.currentXP = 0;
        }
    }

    @Override
    protected void OnRoundEnded() {
        this.pickVoteOptions();
        this.UpdateRoundFinishedTemplate();
        for (EntityPlayer entityPlayer : TeamsManagerRanked.getPlayers()) {
            this.SendRoundFinishedDataToPlayer((EntityPlayerMP)entityPlayer);
        }
        super.OnRoundEnded();
    }

    private void UpdateRoundFinishedTemplate() {
        this.roundFinishedTemplateData.votingTime = votingTime;
        this.roundFinishedTemplateData.scoresTime = scoreDisplayTime;
        this.roundFinishedTemplateData.rankUpdateTime = rankUpdateTime;
        this.roundFinishedTemplateData.votingEnabled = voting;
        if (voting) {
            this.roundFinishedTemplateData.FillVoteOptions(this.voteOptions);
        }
    }

    private void SendRoundFinishedDataToPlayer(EntityPlayerMP player) {
        int resultantXP;
        PlayerData pData = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (pData != null && pData.builder) {
            return;
        }
        RoundFinishedData finishedData = new RoundFinishedData(this.roundFinishedTemplateData);
        PlayerRankData data = rankData.get(player.func_110124_au());
        int resultantLevel = data.currentLevel;
        int XPForNextLevel = this.currentPool.GetXPForLevel(resultantLevel + 1);
        for (resultantXP = data.pendingXP + data.currentXP; XPForNextLevel > 0 && resultantXP >= XPForNextLevel; resultantXP -= XPForNextLevel) {
            XPForNextLevel = this.currentPool.GetXPForLevel(++resultantLevel + 1);
        }
        finishedData.pendingXP = data.pendingXP;
        finishedData.resultantXP = resultantXP;
        finishedData.resultantLevel = resultantLevel;
        FlansMod.getPacketHandler().sendTo(new PacketRoundFinished(finishedData), player);
    }

    private void SendRankDataToPlayer(EntityPlayerMP player) {
    }

    private void ProcessRankData(EntityPlayerMP player) {
        PlayerRankData data = rankData.get(player.func_110124_au());
        if (data != null) {
            int resultantXP;
            int resultantLevel = data.currentLevel;
            int XPForNextLevel = this.currentPool.GetXPForLevel(resultantLevel + 1);
            for (resultantXP = data.pendingXP + data.currentXP; XPForNextLevel > 0 && resultantXP >= XPForNextLevel; resultantXP -= XPForNextLevel) {
                this.GiveRewardsForLevelUp(++resultantLevel, player);
                XPForNextLevel = this.currentPool.GetXPForLevel(resultantLevel + 1);
            }
            data.pendingXP = 0;
            data.currentLevel = resultantLevel;
            data.currentXP = resultantXP;
            data.currentKillstreak = 0;
            data.bestKillstreak = 0;
        }
    }

    private void GiveRewardsForLevelUp(int level, EntityPlayerMP player) {
        for (RewardBox box : this.currentPool.rewardsPerLevel[level - 1]) {
            RewardBoxInstance instance = RewardBoxInstance.CreateLevelUpReward(box, (EntityPlayer)player);
            PlayerRankData data = TeamsManagerRanked.GetRankData((EntityPlayer)player);
            data.AddRewardBoxInstance(instance);
        }
    }

    @Override
    public void showTeamsMenuToAll(boolean info) {
    }

    @Override
    public void sendTeamsMenuToPlayer(EntityPlayerMP player, boolean info) {
        if (!enabled || this.currentRound == null || this.currentRound.teams == null) {
            return;
        }
        this.sendLoadoutData(player);
    }

    @Override
    public void sendClassMenuToPlayer(EntityPlayerMP player) {
    }

    @Override
    protected void ReadFromNBT(NBTTagCompound tags, World world) {
        super.ReadFromNBT(tags, world);
        int iPoolHash = tags.func_74762_e("pool");
        this.currentPool = LoadoutPool.GetPool(iPoolHash);
        NBTTagList ranks = tags.func_150295_c("playerRanks", 10);
        if (ranks != null) {
            for (int i = 0; i < ranks.func_74745_c(); ++i) {
                NBTTagCompound playerTags = ranks.func_150305_b(i);
                UUID uuid = new UUID(playerTags.func_74763_f("uuid1"), playerTags.func_74763_f("uuid2"));
                PlayerRankData rData = new PlayerRankData();
                rData.readFromNBT(playerTags);
                rankData.put(uuid, rData);
            }
        }
    }

    @Override
    protected void WriteToNBT(NBTTagCompound tags) {
        super.WriteToNBT(tags);
        if (this.currentPool != null) {
            tags.func_74768_a("pool", this.currentPool.shortName.hashCode());
        }
        NBTTagList ranks = new NBTTagList();
        for (Map.Entry<UUID, PlayerRankData> entry : rankData.entrySet()) {
            NBTTagCompound playerTags = new NBTTagCompound();
            playerTags.func_74772_a("uuid1", entry.getKey().getMostSignificantBits());
            playerTags.func_74772_a("uuid2", entry.getKey().getLeastSignificantBits());
            entry.getValue().writeToNBT(playerTags);
            ranks.func_74742_a((NBTBase)playerTags);
        }
        tags.func_74782_a("playerRanks", (NBTBase)ranks);
    }

    @Override
    public void playerSelectedClass(EntityPlayerMP player, String className) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        int selection = Integer.parseInt(className);
        PlayerRankData data = rankData.get(player.func_110124_au());
        PlayerClassCustom playerClass = new PlayerClassCustom(selection, data.loadouts[selection]);
        this.playerSelectedClass(player, playerClass);
    }

    @SideOnly(value=Side.CLIENT)
    public static void ConfirmLoadoutChanges() {
        PacketLoadoutData packet = new PacketLoadoutData();
        packet.myRankData = ClientTeamsData.theRankData;
        FlansMod.getPacketHandler().sendToServer(packet);
    }

    @SideOnly(value=Side.CLIENT)
    public static void ChooseLoadout(int id) {
        PacketTeamSelect packet = new PacketTeamSelect();
        packet.classChoicesPacket = true;
        packet.info = false;
        packet.selection = "" + id;
        packet.selectionPacket = true;
        FlansMod.getPacketHandler().sendToServer(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void SelectTeam(Team team) {
        FlansMod.getPacketHandler().sendToServer(new PacketTeamSelect(team == null ? "null" : team.shortName, false));
        if (team == null) {
            FMLClientHandler.instance().getClient().func_147108_a(null);
        } else {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiChooseLoadout());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean LocalPlayerOwnsUnlock(int unlockHash) {
        return ClientTeamsData.theRankData.OwnsUnlock(unlockHash);
    }

    public static boolean PlayerOwnsUnlock(int hashCode, UUID uuid) {
        return false;
    }

    public static void OpenRewardBox(EntityPlayerMP player, RewardBox box) {
        PlayerRankData data = rankData.get(player.func_110124_au());
        for (RewardBoxInstance instance : data.rewardBoxData) {
            if (instance.opened || instance.boxHash != box.hashCode() || instance.unlockHash != 0) continue;
            int unlockHash = instance.OpenBox(data);
            FlansMod.getPacketHandler().sendTo(new PacketOpenRewardBox(box.hashCode(), unlockHash), player);
            return;
        }
        FlansMod.Assert(false, "Player " + player.getDisplayNameString() + " tried to open box they don't have");
    }

    public static PlayerRankData GetRankData(EntityPlayer player) {
        TeamsManagerRanked.GetInstance();
        return rankData.get(player.func_110124_au());
    }

    public static PlayerRankData GetRankData(UUID id) {
        TeamsManagerRanked.GetInstance();
        return rankData.get(id);
    }
}

