/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.client.gui.teams.EnumLoadoutSlot;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.teams.PlayerLoadout;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class LoadoutPool
extends InfoType {
    public static ArrayList<LoadoutPool> pools = new ArrayList();
    public int maxLevel = 20;
    public int[] XPPerLevel;
    public int XPForKill = 10;
    public int XPForDeath = 5;
    public int XPForKillstreakBonus = 10;
    public ArrayList<LoadoutEntryInfoType>[] unlocks;
    public PlayerLoadout[] defaultLoadouts = new PlayerLoadout[5];
    public RewardBox[] rewardBoxes = new RewardBox[3];
    public ArrayList<RewardBox>[] rewardsPerLevel;
    public int[] slotUnlockLevels = new int[]{0, 0, 5, 10, 20};

    public LoadoutPool(TypeFile file) {
        super(file);
        int i;
        pools.add(this);
        this.unlocks = new ArrayList[EnumLoadoutSlot.values().length];
        for (i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            this.unlocks[i] = new ArrayList();
        }
        for (i = 0; i < 5; ++i) {
            this.defaultLoadouts[i] = new PlayerLoadout();
        }
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        this.XPForKill = this.Read(split, "XPForKill", this.XPForKill);
        this.XPForDeath = this.Read(split, "XPForDeath", this.XPForDeath);
        this.XPForKillstreakBonus = this.Read(split, "XPForKillstreakBonus", this.XPForKillstreakBonus);
        if (this.KeyMatches(split, "MaxLevel")) {
            this.maxLevel = Integer.parseInt(split[1]);
            this.XPPerLevel = new int[this.maxLevel];
            this.rewardsPerLevel = new ArrayList[this.maxLevel];
            for (int i = 0; i < this.maxLevel; ++i) {
                this.XPPerLevel[i] = 10 * i;
                this.rewardsPerLevel[i] = new ArrayList();
            }
        } else if (this.KeyMatches(split, "XPPerLevel")) {
            for (int i = 0; i < this.maxLevel; ++i) {
                if (i + 1 >= split.length) continue;
                this.XPPerLevel[i] = Integer.parseInt(split[i + 1]);
            }
        } else if (!(this.ParseLoadoutEntry("AddPrimary", EnumLoadoutSlot.primary, split) || this.ParseLoadoutEntry("AddSecondary", EnumLoadoutSlot.secondary, split) || this.ParseLoadoutEntry("AddSpecial", EnumLoadoutSlot.special, split) || this.ParseLoadoutEntry("AddMelee", EnumLoadoutSlot.melee, split) || this.ParseLoadoutEntry("AddArmour", EnumLoadoutSlot.armour, split))) {
            if (this.KeyMatches(split, "SlotUnlockLevels")) {
                for (int i = 0; i < 5; ++i) {
                    this.slotUnlockLevels[i] = Integer.parseInt(split[i + 1]);
                }
            } else if (this.KeyMatches(split, "DefaultLoadout")) {
                int index = Integer.parseInt(split[1]) - 1;
                for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
                    if (2 + i >= split.length) continue;
                    InfoType type = InfoType.getType(split[2 + i]);
                    if (type == null) {
                        FlansMod.Assert(false, "Invalid info type in loadout: " + split[2 + i]);
                        continue;
                    }
                    this.defaultLoadouts[index].slots[i] = new ItemStack(type.getItem());
                }
            } else if (this.KeyMatches(split, "AddRewardBox")) {
                boolean slotAvailable = false;
                for (int i = 0; i < 3; ++i) {
                    if (this.rewardBoxes[i] != null) continue;
                    this.rewardBoxes[i] = RewardBox.GetRewardBox(split[1]);
                    slotAvailable = true;
                    break;
                }
                FlansMod.Assert(slotAvailable, "Trying to insert more than 3 reward box types. No support for this yet");
            } else if (this.KeyMatches(split, "AddReward")) {
                RewardBox box = RewardBox.GetRewardBox(split[1]);
                boolean found = false;
                for (int i = 0; i < 3; ++i) {
                    if (box != this.rewardBoxes[i]) continue;
                    found = true;
                }
                if (!found) {
                    FlansMod.Assert(false, "Trying to give player reward box invalid for this loadout pool");
                } else {
                    this.rewardsPerLevel[Integer.parseInt(split[2]) - 1].add(box);
                }
            }
        }
    }

    private boolean ParseLoadoutEntry(String keyword, EnumLoadoutSlot slot, String[] split) {
        if (this.KeyMatches(split, keyword)) {
            LoadoutEntryInfoType entry = new LoadoutEntryInfoType();
            entry.type = InfoType.getType(split[1]);
            entry.unlockLevel = Integer.parseInt(split[2]);
            int numAdditionalItems = (split.length - 3) / 2;
            for (int i = 0; i < numAdditionalItems; ++i) {
                ItemStack stack = LoadoutPool.getNonRecipeElement(split[2 * i + 3]);
                if (stack == null || stack.func_190926_b()) {
                    FlansMod.Assert(false, "Recipe item stack null");
                    continue;
                }
                stack.func_190920_e(Integer.parseInt(split[2 * i + 4]));
                entry.extraItems.add(stack);
            }
            if (entry.type != null) {
                this.unlocks[slot.ordinal()].add(entry);
            } else {
                FlansMod.log("Entry with no InfoType: " + split[1]);
            }
            return true;
        }
        return false;
    }

    public int GetXPForLevel(int level) {
        if (level > 0 && level <= this.maxLevel) {
            return this.XPPerLevel[level - 1];
        }
        return -1;
    }

    public static LoadoutPool GetPool(String s) {
        for (LoadoutPool pool : pools) {
            if (!pool.shortName.equals(s)) continue;
            return pool;
        }
        return null;
    }

    public static LoadoutPool GetPool(int iHash) {
        for (LoadoutPool pool : pools) {
            if (pool.shortName.hashCode() != iHash) continue;
            return pool;
        }
        return null;
    }

    public LoadoutEntryInfoType GetLoadoutEntryForInfoType(int loadoutSlot, InfoType infoType) {
        for (LoadoutEntry loadoutEntry : this.unlocks[loadoutSlot]) {
            if (!(loadoutEntry instanceof LoadoutEntryInfoType) || ((LoadoutEntryInfoType)loadoutEntry).type != infoType) continue;
            return (LoadoutEntryInfoType)loadoutEntry;
        }
        return null;
    }

    public static class LoadoutEntryInfoType
    extends LoadoutEntry {
        public InfoType type = null;
        public ArrayList<ItemStack> extraItems = new ArrayList(2);
    }

    public static class LoadoutEntryPaintjob
    extends LoadoutEntry {
        public Paintjob paintjob = null;
    }

    public static class LoadoutEntry {
        public int unlockLevel = 0;
        public boolean available = false;
    }
}

