/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class GametypeDM
extends Gametype {
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;

    public GametypeDM() {
        super("Free For All", "DM", 2);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeDM.getPlayerData(player) == null || GametypeDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeDM.getPlayerData(attacker) == null || GametypeDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeDM.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
        }
        return GametypeDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GametypeDM.getPlayerData((EntityPlayerMP)attacker).score;
                ++GametypeDM.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeDM.getPlayerData((EntityPlayerMP)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3d getSpawnPoint(EntityPlayerMP player) {
        if (GametypeDM.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GametypeDM.getPlayerData(player);
        ArrayList<BlockPos> validSpawnPoints = new ArrayList<BlockPos>();
        if (data.newTeam == null) {
            return null;
        }
        if (data.newTeam == Team.spectators) {
            GametypeDM.teamsManager.currentRound.map.getValidSpawnPoints(GametypeDM.teamsManager.currentRound.getTeamID(data.newTeam), validSpawnPoints);
        } else {
            for (int k = 2; k < 4; ++k) {
                GametypeDM.teamsManager.currentRound.map.getValidSpawnPoints(GametypeDM.teamsManager.currentRound.getTeamID(data.newTeam), validSpawnPoints);
            }
        }
        if (validSpawnPoints.size() > 0) {
            BlockPos spawnPoint = (BlockPos)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return new Vec3d((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5);
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("DMScoreLimit");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("DMScoreLimit", this.scoreLimit);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return false;
    }

    @Override
    public boolean shouldAutobalance() {
        return false;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return false;
    }
}

