/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBreakSound
extends PacketBase {
    public int x;
    public int y;
    public int z;
    public int blockID;

    public PacketBreakSound() {
    }

    public PacketBreakSound(int x, int y, int z, Block block) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockID = Block.func_149682_b((Block)block);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.writeInt(this.blockID);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.blockID = data.readInt();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log("Received block break sound packet on server. Skipping.");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        World world = clientPlayer.field_70170_p;
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        IBlockState state = world.func_180495_p(new BlockPos(this.x, this.y, this.z));
        Block block = Block.func_149729_e((int)this.blockID);
        FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(new BlockPos(this.x, this.y, this.z), block.func_176223_P());
        SoundType sound = block.getSoundType(state, world, pos, (Entity)clientPlayer);
        SoundEvent event = sound.func_185845_c();
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(event, SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f, (float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f));
    }
}

