/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class ItemGrenade
extends ItemShootable
implements IFlanItem {
    public GrenadeType type;

    public ItemGrenade(GrenadeType t) {
        super(t);
        this.type = t;
        this.type.item = this;
        this.func_77637_a(FlansMod.tabFlanGuns);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.type.meleeDamage, 0));
        return multimap;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return this.type.meleeDamage == 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        PlayerData data = PlayerHandler.getPlayerData(player, world.field_72995_K ? Side.CLIENT : Side.SERVER);
        if (this.type.canThrow && data != null && data.shootTimeRight <= 0.0f && data.shootTimeLeft <= 0.0f) {
            data.shootTimeRight = this.type.throwDelay;
            EntityGrenade grenade = new EntityGrenade(world, this.type, (EntityLivingBase)player);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)grenade);
            }
            if (this.type.remote) {
                data.remoteExplosives.add(grenade);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            if (this.type.dropItemOnThrow != null) {
                String itemName = this.type.dropItemOnDetonate;
                int damage = 0;
                if (itemName.contains(".")) {
                    damage = Integer.parseInt(itemName.split("\\.")[1]);
                    itemName = itemName.split("\\.")[0];
                }
                ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropStack));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    @Override
    public EntityShootable getEntity(World world, Vec3d origin, float yaw, float pitch, double motionX, double motionY, double motionZ, EntityLivingBase shooter, float gunDamage, InfoType shotFrom) {
        return null;
    }

    @Override
    public EntityShootable getEntity(World world, Vector3f origin, Vector3f direction, EntityLivingBase thrower, float spread, float damage, float speed, InfoType shotFrom) {
        return this.getGrenade(world, thrower);
    }

    @Override
    public EntityShootable getEntity(World world, Vec3d origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float damage, InfoType shotFrom) {
        return null;
    }

    @Override
    public EntityShootable getEntity(World world, EntityLivingBase player, float bulletSpread, float damage, float bulletSpeed, boolean b, InfoType shotFrom) {
        return this.getGrenade(world, player);
    }

    public EntityGrenade getGrenade(World world, EntityLivingBase thrower) {
        EntityGrenade grenade = new EntityGrenade(world, this.type, thrower);
        if (this.type.remote && thrower instanceof EntityPlayer) {
            PlayerHandler.getPlayerData((EntityPlayer)((EntityPlayer)thrower)).remoteExplosives.add(grenade);
        }
        return grenade;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag b) {
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
    }

    @Override
    public void Shoot(World world, Vector3f origin, Vector3f direction, float damageModifier, float spreadModifier, float speedModifier, InfoType shotFrom, EntityLivingBase shooter) {
        EntityGrenade grenade = this.getGrenade(world, shooter);
        world.func_72838_d((Entity)grenade);
    }
}

