/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.common.FlansMod;
import com.flansmod.common.FlansModExplosion;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityDamageSourceGun;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.network.PacketFlak;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullet
extends EntityShootable
implements IEntityAdditionalSpawnData {
    private static int bulletLife = 600;
    public Entity owner;
    private int ticksInAir = 0;
    public BulletType type;
    public InfoType firedFrom;
    public float damage;
    public boolean shotgun = false;
    public int pingOfShooter = 0;
    public static Random bulletRandom = new Random();
    public Entity lockedOnTo;
    public float penetratingPower;
    private float yOffset;
    @SideOnly(value=Side.CLIENT)
    private boolean playedFlybySound;

    public EntityBullet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    private EntityBullet(World world, EntityLivingBase shooter, float gunDamage, BulletType bulletType, InfoType shotFrom) {
        this(world);
        this.owner = shooter;
        if (shooter instanceof EntityPlayerMP) {
            this.pingOfShooter = ((EntityPlayerMP)shooter).field_71138_i;
        }
        this.type = bulletType;
        this.firedFrom = shotFrom;
        this.damage = gunDamage;
        this.penetratingPower = this.type.penetratingPower;
    }

    public EntityBullet(World world, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, boolean shot, InfoType shotFrom) {
        this(world, new Vec3d(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v), shooter.field_70177_z, shooter.field_70125_A, shooter, spread, gunDamage, type1, speed, shotFrom);
        this.shotgun = shot;
    }

    public EntityBullet(World world, Vec3d origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.func_70012_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, yaw, pitch);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.yOffset = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, spread / 2.0f, speed);
    }

    public EntityBullet(World world, Vector3f origin, Vector3f direction, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.damage = gunDamage;
        this.func_70107_b(origin.x, origin.y, origin.z);
        this.field_70159_w = direction.x;
        this.field_70181_x = direction.y;
        this.field_70179_y = direction.z;
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, spread, speed);
    }

    public EntityBullet(World world, Vec3d origin, float yaw, float pitch, double motX, double motY, double motZ, EntityLivingBase shooter, float gunDamage, BulletType type1, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.func_70012_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, yaw, pitch);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.yOffset = 0.0f;
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void setArrowHeading(double d, double d1, double d2, float spread, float speed) {
        spread /= 5.0f;
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d *= (double)speed;
        d1 *= (double)speed;
        d2 *= (double)speed;
        this.field_70159_w = d += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        this.field_70181_x = d1 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        this.field_70179_y = d2 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        float f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.getLockOnTarget();
    }

    private void getLockOnTarget() {
        if (this.type.lockOnToPlanes || this.type.lockOnToVehicles || this.type.lockOnToMechas || this.type.lockOnToLivings || this.type.lockOnToPlayers) {
            Vector3f motionVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Entity closestEntity = null;
            float closestAngle = this.type.maxLockOnAngle * (float)Math.PI / 180.0f;
            for (Object obj : this.field_70170_p.field_72996_f) {
                Vector3f relPosVec;
                float angle;
                Entity entity = (Entity)obj;
                if (!(this.type.lockOnToMechas && entity instanceof EntityMecha || this.type.lockOnToVehicles && entity instanceof EntityVehicle || this.type.lockOnToPlanes && entity instanceof EntityPlane || this.type.lockOnToPlayers && entity instanceof EntityPlayer) && (!this.type.lockOnToLivings || !(entity instanceof EntityLivingBase)) || !((angle = Math.abs(Vector3f.angle(motionVec, relPosVec = new Vector3f(entity.field_70165_t - this.field_70165_t, entity.field_70163_u - this.field_70163_u, entity.field_70161_v - this.field_70161_v)))) < closestAngle)) continue;
                closestEntity = entity;
                closestAngle = angle;
            }
            if (closestEntity != null) {
                this.lockedOnTo = closestEntity;
            }
        }
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public static boolean OnHit(World world, Vector3f origin, Vector3f hit, Entity shooter, InfoType shotFrom, ShootableType shootableType, EntityBullet bullet, float damage, FlansModRaytracer.BulletHit bulletHit) {
        DamageSource source;
        if (!(shootableType instanceof BulletType)) {
            FlansMod.log("Tried to fire grenade instantly");
            return true;
        }
        if (world == null || origin == null || hit == null || shooter == null || shotFrom == null || shootableType == null) {
            return true;
        }
        BulletType bulletType = (BulletType)shootableType;
        float penetratingPower = bullet == null ? bulletType.penetratingPower : bullet.penetratingPower;
        DamageSource damageSource = source = bullet == null ? EntityBullet.GetBulletDamage(shotFrom, bulletType, shooter, false) : bullet.getBulletDamage(false);
        if (bulletHit instanceof FlansModRaytracer.DriveableHit) {
            FlansModRaytracer.DriveableHit driveableHit = (FlansModRaytracer.DriveableHit)bulletHit;
            penetratingPower = driveableHit.driveable.bulletHit(bulletType, damage, driveableHit, penetratingPower);
            if (FlansMod.DEBUG && world.field_72995_K) {
                world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 0.0f, 0.0f, 1.0f));
            }
        } else if (bulletHit instanceof FlansModRaytracer.PlayerBulletHit) {
            FlansModRaytracer.PlayerBulletHit playerHit = (FlansModRaytracer.PlayerBulletHit)bulletHit;
            penetratingPower = playerHit.hitbox.hitByBullet(source, shooter, shotFrom, bulletType, damage, penetratingPower);
            if (FlansMod.DEBUG && world.field_72995_K) {
                world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 1.0f, 0.0f, 0.0f));
            }
        } else if (bulletHit instanceof FlansModRaytracer.EntityHit) {
            FlansModRaytracer.EntityHit entityHit = (FlansModRaytracer.EntityHit)bulletHit;
            if (entityHit.entity != null) {
                if (entityHit.entity.func_70097_a(source, damage * bulletType.damageVsLiving) && entityHit.entity instanceof EntityLivingBase) {
                    EntityLivingBase living = (EntityLivingBase)entityHit.entity;
                    for (PotionEffect effect : bulletType.hitEffects) {
                        living.func_70690_d(new PotionEffect(effect));
                    }
                    living.field_70172_ad = 0;
                }
                if (bulletType.setEntitiesOnFire) {
                    entityHit.entity.func_70015_d(20);
                }
                penetratingPower -= 1.0f;
                if (FlansMod.DEBUG && world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 1.0f, 1.0f, 0.0f));
                }
            }
        } else if (bulletHit instanceof FlansModRaytracer.BlockHit) {
            FlansModRaytracer.BlockHit blockHit = (FlansModRaytracer.BlockHit)bulletHit;
            RayTraceResult raytraceResult = blockHit.raytraceResult;
            BlockPos pos = raytraceResult.func_178782_a();
            if (FlansMod.DEBUG && world.field_72995_K) {
                world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 0.0f, 1.0f, 0.0f));
            }
            Block block = world.func_180495_p(pos).func_177230_c();
            Material mat = world.func_180495_p(pos).func_185904_a();
            if (bulletType.breaksGlass && mat == Material.field_151592_s && TeamsManager.canBreakGlass) {
                world.func_175698_g(pos);
                FlansMod.proxy.playBlockBreakSound(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), block);
            }
            if (bullet != null) {
                bullet.func_70107_b(blockHit.raytraceResult.field_72307_f.field_72450_a, blockHit.raytraceResult.field_72307_f.field_72448_b, blockHit.raytraceResult.field_72307_f.field_72449_c);
            }
            if (!world.field_72995_K && shooter != null && bulletType.hitSound != null) {
                PacketPlaySound.sendSoundPacket(hit.x, hit.y, hit.z, bulletType.hitSoundRange, shooter.field_71093_bK, bulletType.hitSound, true);
            }
            if (bullet != null) {
                bullet.penetratingPower = penetratingPower;
            }
            return true;
        }
        if (penetratingPower <= 0.0f || bulletType.explodeOnImpact && (bullet == null || bullet.ticksInAir > 1)) {
            if (bullet != null) {
                bullet.func_70107_b(hit.x, hit.y, hit.z);
                bullet.penetratingPower = penetratingPower;
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        List<FlansModRaytracer.BulletHit> hits;
        super.func_70071_h_();
        if (FlansMod.DEBUG && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y), 20));
        }
        ++this.ticksInAir;
        if (this.ticksInAir > this.type.fuse && this.type.fuse > 0 && !this.field_70128_L) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > bulletLife) {
            this.func_70106_y();
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.onUpdateClient();
        }
        Vector3f origin = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3f motion = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K && !(hits = FlansModRaytracer.Raytrace(this.field_70170_p, this.owner, this.ticksInAir > 20, this, origin, motion, this.pingOfShooter)).isEmpty()) {
            Iterator<FlansModRaytracer.BulletHit> iterator = hits.iterator();
            while (iterator.hasNext()) {
                FlansModRaytracer.BulletHit bulletHit;
                Vector3f hitPos = new Vector3f(origin.x + motion.x * bulletHit.intersectTime, origin.y + motion.y * bulletHit.intersectTime, origin.z + motion.z * bulletHit.intersectTime);
                bulletHit = iterator.next();
                if (!EntityBullet.OnHit(this.field_70170_p, origin, hitPos, this.owner, this.firedFrom, this.type, this, this.damage, bulletHit)) continue;
                this.func_70106_y();
                break;
            }
        }
        float drag = 0.99f;
        float gravity = 0.02f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float bubbleMotion = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)bubbleMotion, this.field_70163_u - this.field_70181_x * (double)bubbleMotion, this.field_70161_v - this.field_70179_y * (double)bubbleMotion, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            drag = 0.8f;
        }
        this.field_70159_w *= (double)drag;
        this.field_70181_x *= (double)drag;
        this.field_70179_y *= (double)drag;
        this.field_70181_x -= (double)(gravity * this.type.fallSpeed);
        if (this.lockedOnTo != null) {
            double dX = this.lockedOnTo.field_70165_t - this.field_70165_t;
            double dY = this.lockedOnTo.field_70163_u - this.field_70163_u;
            double dZ = this.lockedOnTo.field_70161_v - this.field_70161_v;
            double dXYZ = dX * dX + dY * dY + dZ * dZ;
            Vector3f relPosVec = new Vector3f(dX, dY, dZ);
            float angle = Math.abs(Vector3f.angle(motion, relPosVec));
            double lockOnPull = angle * this.type.lockOnForce;
            lockOnPull *= lockOnPull;
            this.field_70159_w *= (double)0.95f;
            this.field_70181_x *= (double)0.95f;
            this.field_70179_y *= (double)0.95f;
            this.field_70159_w += lockOnPull * dX / dXYZ;
            this.field_70181_x += lockOnPull * dY / dXYZ;
            this.field_70179_y += lockOnPull * dZ / dXYZ;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float motionXZ = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionXZ) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.type.trailParticles && this.field_70170_p.field_72995_K && this.ticksInAir > 1) {
            this.spawnParticles();
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onUpdateClient() {
        if (this.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) < 5.0 && !this.playedFlybySound) {
            this.playedFlybySound = true;
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSoundEvent("bulletFlyby"), SoundCategory.HOSTILE, 10.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f), (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        double dX = (this.field_70165_t - this.field_70169_q) / 10.0;
        double dY = (this.field_70163_u - this.field_70167_r) / 10.0;
        double dZ = (this.field_70161_v - this.field_70166_s) / 10.0;
        float spread = 0.1f;
        for (int i = 0; i < 10; ++i) {
            Particle particle = FlansModClient.getParticle(this.type.trailParticleType, this.field_70170_p, this.field_70169_q + dX * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70167_r + dY * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70166_s + dZ * (double)i + this.field_70146_Z.nextGaussian() * (double)spread);
        }
    }

    public DamageSource getBulletDamage(boolean headshot) {
        if (this.owner instanceof EntityPlayer) {
            return new EntityDamageSourceGun(this.type.shortName, this, (EntityPlayer)this.owner, this.firedFrom, headshot).func_76349_b();
        }
        return new EntityDamageSourceIndirect(this.type.shortName, (Entity)this, this.owner).func_76349_b();
    }

    public static DamageSource GetBulletDamage(InfoType firedFrom, BulletType type, Entity owner, boolean headshot) {
        if (owner instanceof EntityPlayer) {
            return new EntityDamageSourceGun(type.shortName, owner, (EntityPlayer)owner, firedFrom, headshot).func_76349_b();
        }
        return new EntityDamageSourceIndirect(type.shortName, owner, owner).func_76349_b();
    }

    private boolean isPartOfOwner(Entity entity) {
        if (this.owner == null) {
            return false;
        }
        if (entity == this.owner || entity == this.owner.func_184179_bs() || entity == this.owner.func_184187_bx()) {
            return true;
        }
        if (this.owner instanceof EntityPlayer) {
            if (PlayerHandler.getPlayerData((EntityPlayer)this.owner, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER) == null) {
                return false;
            }
            EntityMG mg = PlayerHandler.getPlayerData((EntityPlayer)((EntityPlayer)this.owner), (Side)(this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)).mountingGun;
            if (mg != null && mg == entity) {
                return true;
            }
        }
        return this.owner.func_184187_bx() instanceof EntitySeat && (((EntitySeat)this.owner.func_184187_bx()).driveable == null || ((EntitySeat)this.owner.func_184187_bx()).driveable.isPartOfThis(entity));
    }

    public void func_70106_y() {
        if (this.field_70128_L) {
            return;
        }
        super.func_70106_y();
        EntityBullet.OnDetonate(this.field_70170_p, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.owner, this, this.firedFrom, this.type);
    }

    public static void OnDetonate(World world, Vector3f detonatePos, Entity owner, EntityBullet bullet, InfoType shotFrom, BulletType bulletType) {
        if (world.field_72995_K) {
            return;
        }
        if (bulletType.explosionRadius > 0.0f) {
            if (owner instanceof EntityPlayer) {
                new FlansModExplosion(world, bullet, (EntityPlayer)owner, bulletType, detonatePos.x, detonatePos.y, detonatePos.z, bulletType.explosionRadius, bulletType.fireRadius > 0.0f, bulletType.flak > 0, bulletType.explosionBreaksBlocks);
            } else {
                world.func_72876_a((Entity)bullet, (double)detonatePos.x, (double)detonatePos.y, (double)detonatePos.z, bulletType.explosionRadius, TeamsManager.explosions && bulletType.explosionBreaksBlocks);
            }
        }
        if (bulletType.fireRadius > 0.0f) {
            for (float i = -bulletType.fireRadius; i < bulletType.fireRadius; i += 1.0f) {
                for (float k = -bulletType.fireRadius; k < bulletType.fireRadius; k += 1.0f) {
                    for (int j = -1; j < 1; ++j) {
                        if (world.func_180495_p(new BlockPos((int)(detonatePos.x + i), (int)(detonatePos.y + (float)j), (int)(detonatePos.z + k))).func_185904_a() != Material.field_151579_a) continue;
                        world.func_180501_a(new BlockPos((int)(detonatePos.x + i), (int)(detonatePos.y + (float)j), (int)(detonatePos.z + k)), Blocks.field_150480_ab.func_176223_P(), 2);
                    }
                }
            }
        }
        if (bulletType.flak > 0 && owner != null) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketFlak(detonatePos.x, detonatePos.y, detonatePos.z, bulletType.flak, bulletType.flakParticles), detonatePos.x, detonatePos.y, detonatePos.z, 200.0f, owner.field_71093_bK);
        }
        if (bulletType.dropItemOnHit != null) {
            ItemStack dropStack;
            String itemName = bulletType.dropItemOnHit;
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            if ((dropStack = InfoType.getRecipeElement(itemName, damage)) != null && !dropStack.func_190926_b()) {
                EntityItem entityitem = new EntityItem(world, (double)detonatePos.x, (double)detonatePos.y, (double)detonatePos.z, dropStack);
                entityitem.func_174869_p();
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("type", this.type.shortName);
        if (this.owner == null) {
            tag.func_74778_a("owner", "null");
        } else {
            tag.func_74778_a("owner", this.owner.func_70005_c_());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        String typeString = tag.func_74779_i("type");
        String ownerName = tag.func_74779_i("owner");
        if (typeString != null) {
            this.type = BulletType.getBullet(typeString);
        }
        if (ownerName != null && !ownerName.equals("null")) {
            this.owner = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(ownerName);
        }
    }

    public int getBrightnessForRender(float par1) {
        int j;
        if (this.type.hasLight) {
            return 0xF000F0;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.yOffset + d0));
            return this.field_70170_p.func_175705_a(EnumSkyBlock.SKY, new BlockPos(i, k, j));
        }
        return 0;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
        data.writeInt(this.lockedOnTo == null ? -1 : this.lockedOnTo.func_145782_y());
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.type.shortName);
        if (this.owner == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)"null");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.owner.func_70005_c_());
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.field_70159_w = data.readDouble();
            this.field_70181_x = data.readDouble();
            this.field_70179_y = data.readDouble();
            int lockedOnToID = data.readInt();
            if (lockedOnToID != -1) {
                this.lockedOnTo = this.field_70170_p.func_73045_a(lockedOnToID);
            }
            this.type = BulletType.getBullet(ByteBufUtils.readUTF8String((ByteBuf)data));
            this.penetratingPower = this.type.penetratingPower;
            String name = ByteBufUtils.readUTF8String((ByteBuf)data);
            for (Object obj : this.field_70170_p.field_72996_f) {
                if (obj == null || !((Entity)obj).func_70005_c_().equals(name)) continue;
                this.owner = (EntityLivingBase)obj;
                break;
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to read bullet owner from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }
}

