/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IControllable;
import com.flansmod.api.IExplodeable;
import com.flansmod.client.EntityCamera;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.ShotData;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableKeyHeld;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.parts.EnumPartCategory;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityDriveable
extends Entity
implements IControllable,
IExplodeable,
IEntityAdditionalSpawnData {
    public boolean syncFromServer = true;
    public int serverPositionTransitionTicker;
    public double field_70118_ct;
    public double field_70117_cu;
    public double field_70116_cv;
    public double serverYaw;
    public double serverPitch;
    public double serverRoll;
    public DriveableData driveableData;
    public String driveableType;
    public float throttle;
    public EntityWheel[] wheels;
    public boolean fuelling;
    public float prevRotationRoll;
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean leftMouseHeld = false;
    public boolean rightMouseHeld = false;
    public float shootDelayPrimary;
    public float shootDelaySecondary;
    public float minigunSpeedPrimary;
    public float minigunSpeedSecondary;
    public int currentGunPrimary;
    public int currentGunSecondary;
    public float harvesterAngle;
    public RotatedAxes prevAxes;
    public RotatedAxes axes = new RotatedAxes();
    private EntitySeat[] seats;
    protected boolean readyForUpdates = false;
    private float yOffset;
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase camera;
    private int[] emitterTimers;
    public int animCount = 0;
    public int animFrame = 0;

    public EntityDriveable(World world) {
        super(world);
        this.prevAxes = new RotatedAxes();
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.yOffset = 0.375f;
        this.field_70158_ak = true;
    }

    public EntityDriveable(World world, DriveableType t, DriveableData d) {
        this(world);
        this.driveableType = t.shortName;
        this.driveableData = d;
    }

    protected void initType(DriveableType type, boolean firstSpawn, boolean clientSide) {
        int i;
        this.seats = new EntitySeat[type.numPassengers + 1];
        this.wheels = new EntityWheel[type.wheelPositions.length];
        if (!clientSide && firstSpawn) {
            for (i = 0; i < type.numPassengers + 1; ++i) {
                this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.seats[i]);
                this.seats[i].func_184220_m(this);
            }
            for (i = 0; i < this.wheels.length; ++i) {
                this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
                this.wheels[i].func_184220_m(this);
            }
        }
        this.field_70138_W = type.wheelStepHeight;
        this.yOffset = type.yOffset;
        this.emitterTimers = new int[type.emitters.size()];
        for (i = 0; i < type.emitters.size(); ++i) {
            this.emitterTimers[i] = this.field_70146_Z.nextInt(type.emitters.get((int)i).emitRate);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        double dX = this.field_70165_t - x;
        double dY = this.field_70163_u - y;
        double dZ = this.field_70161_v - z;
        double distSq = dX * dX + dY * dY + dZ * dZ;
        double maxDist = 200.0 * EntityDriveable.func_184183_bd();
        return distSq < maxDist * maxDist;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        this.driveableData.writeToNBT(tag);
        tag.func_74778_a("Type", this.driveableType);
        tag.func_74776_a("RotationYaw", this.axes.getYaw());
        tag.func_74776_a("RotationPitch", this.axes.getPitch());
        tag.func_74776_a("RotationRoll", this.axes.getRoll());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.driveableType = tag.func_74779_i("Type");
        this.driveableData = new DriveableData(tag);
        this.initType(DriveableType.getDriveable(this.driveableType), false, false);
        this.field_70126_B = tag.func_74760_g("RotationYaw");
        this.field_70127_C = tag.func_74760_g("RotationPitch");
        this.prevRotationRoll = tag.func_74760_g("RotationRoll");
        this.axes = new RotatedAxes(this.field_70126_B, this.field_70127_C, this.prevRotationRoll);
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.driveableType);
        NBTTagCompound tag = new NBTTagCompound();
        this.driveableData.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
        data.writeFloat(this.axes.getYaw());
        data.writeFloat(this.axes.getPitch());
        data.writeFloat(this.axes.getRoll());
        for (EnumDriveablePart ep : EnumDriveablePart.values()) {
            DriveablePart part = this.getDriveableData().parts.get((Object)ep);
            data.writeShort((int)((short)part.health));
            data.writeBoolean(part.onFire);
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.driveableType = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.driveableData = new DriveableData(ByteBufUtils.readTag((ByteBuf)data));
            this.initType(this.getDriveableType(), false, true);
            this.axes.setAngles(data.readFloat(), data.readFloat(), data.readFloat());
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                part.health = data.readShort();
                part.onFire = data.readBoolean();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retreive plane type from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
        this.camera = new EntityCamera(this.field_70170_p, this);
        this.field_70170_p.func_72838_d((Entity)this.camera);
    }

    @Override
    public abstract void onMouseMoved(int var1, int var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return this.camera;
    }

    protected boolean canSit(int seat) {
        return this.getDriveableType().numPassengers >= seat && this.seats[seat].func_184179_bs() == null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return -0.3;
    }

    public double func_70033_W() {
        return this.yOffset;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        return this.field_70170_p.field_72995_K || this.field_70128_L || this.attackPart(EnumDriveablePart.core, damagesource, i);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.camera.func_70106_y();
        }
        for (EntitySeat entitySeat : this.seats) {
            if (entitySeat == null) continue;
            entitySeat.reallySetDead();
        }
        for (Entity entity : this.wheels) {
            if (entity == null) continue;
            entity.reallySetDead();
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    @SideOnly(value=Side.CLIENT)
    private void ReportVehicleError() {
        FlansMod.log("Vehicle error in " + this);
        ++FlansModClient.numVehicleExceptions;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
        if (!this.isPartOfThis(entity)) {
            super.func_70108_f(entity);
        }
    }

    public void func_180426_a(double d, double d1, double d2, float f, float f1, int i, boolean b) {
        if (this.field_70173_aa > 1) {
            return;
        }
        if (!(this.func_184179_bs() instanceof EntityPlayer) || !FlansMod.proxy.isThePlayer((EntityPlayer)this.func_184179_bs())) {
            if (this.syncFromServer) {
                this.serverPositionTransitionTicker = i + 5;
            } else {
                double var10 = d - this.field_70165_t;
                double var12 = d1 - this.field_70163_u;
                double var14 = d2 - this.field_70161_v;
                double var16 = var10 * var10 + var12 * var12 + var14 * var14;
                if (var16 <= 1.0) {
                    return;
                }
                this.serverPositionTransitionTicker = 3;
            }
            this.field_70118_ct = d;
            this.field_70117_cu = d1;
            this.field_70116_cv = d2;
            this.serverYaw = f;
            this.serverPitch = f1;
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70118_ct = x;
            this.field_70117_cu = y;
            this.field_70116_cv = z;
            this.serverYaw = yaw;
            this.serverPitch = pitch;
            this.serverRoll = roll;
            this.serverPositionTransitionTicker = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.field_70126_B = yaw;
            this.field_70127_C = pitch;
            this.prevRotationRoll = roll;
            this.setRotation(yaw, pitch, roll);
        }
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
        this.angularVelocity = new Vector3f(velYaw, velPitch, velRoll);
        this.throttle = throt;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && key == 9 && this.getDriveableType().modePrimary == EnumFireMode.SEMIAUTO) {
            this.shoot(false);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && key == 8 && this.getDriveableType().modeSecondary == EnumFireMode.SEMIAUTO) {
            this.shoot(true);
            return true;
        }
        return false;
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKeyHeld(key, held));
        }
        switch (key) {
            case 9: {
                this.leftMouseHeld = held;
                break;
            }
            case 8: {
                this.rightMouseHeld = held;
            }
        }
    }

    public void shoot(boolean secondary) {
        DriveableType type = this.getDriveableType();
        if (this.seats[0] == null && !(this.seats[0].func_184179_bs() instanceof EntityLivingBase)) {
            return;
        }
        while (this.getShootDelay(secondary) <= 0.0f) {
            ArrayList<DriveablePosition> shootPoints = type.shootPoints(secondary);
            EnumWeaponType weaponType = type.weaponType(secondary);
            if (shootPoints.size() == 0) {
                return;
            }
            int currentGun = this.getCurrentGun(secondary);
            if (type.alternate(secondary)) {
                currentGun = (currentGun + 1) % shootPoints.size();
                this.setCurrentGun(currentGun, secondary);
                this.shootEach(type, shootPoints.get(currentGun), currentGun, secondary, weaponType);
                continue;
            }
            for (int i = 0; i < shootPoints.size(); ++i) {
                this.shootEach(type, shootPoints.get(i), i, secondary, weaponType);
            }
        }
    }

    private boolean driverIsCreative() {
        return this.seats != null && this.seats[0] != null && this.seats[0].func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)this.seats[0].func_184179_bs()).field_71075_bZ.field_75098_d;
    }

    private EntityPlayer GetDriver() {
        if (this.seats != null && this.seats[0] != null && this.seats[0].func_184179_bs() instanceof EntityPlayer) {
            return (EntityPlayer)this.seats[0].func_184179_bs();
        }
        return null;
    }

    private void shootEach(DriveableType type, DriveablePosition shootPoint, int currentGun, boolean secondary, EnumWeaponType weaponType) {
        Vector3f gunVec = this.getOrigin(shootPoint);
        Vector3f lookVector = this.getLookVector(shootPoint);
        if (shootPoint instanceof PilotGun) {
            PilotGun pilotGun = (PilotGun)shootPoint;
            GunType gunType = pilotGun.type;
            ItemStack shootableStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + currentGun];
            EntityPlayer driver = this.GetDriver();
            if (shootableStack == null || !(shootableStack.func_77973_b() instanceof ItemShootable)) {
                this.shootDelaySecondary = 1.0f;
                this.shootDelayPrimary = 1.0f;
                return;
            }
            ItemShootable shootableItem = (ItemShootable)shootableStack.func_77973_b();
            ShootableType shootableType = shootableItem.type;
            float spread = 0.005f * gunType.bulletSpread * shootableType.bulletSpread;
            lookVector.x += (float)this.field_70170_p.field_73012_v.nextGaussian() * spread;
            lookVector.y += (float)this.field_70170_p.field_73012_v.nextGaussian() * spread;
            lookVector.z += (float)this.field_70170_p.field_73012_v.nextGaussian() * spread;
            lookVector.scale(500.0f);
            if (gunType.bulletSpeed == 0.0f) {
                for (int i = 0; i < gunType.numBullets * shootableType.numBullets; ++i) {
                    List<FlansModRaytracer.BulletHit> hits = FlansModRaytracer.Raytrace(this.field_70170_p, (Entity)driver, false, null, gunVec, lookVector, 0);
                    Entity victim = null;
                    Vector3f hitPos = Vector3f.add(gunVec, lookVector, null);
                    FlansModRaytracer.BulletHit firstHit = null;
                    if (!hits.isEmpty()) {
                        firstHit = hits.get(0);
                        hitPos = Vector3f.add(gunVec, (Vector3f)lookVector.scale(firstHit.intersectTime), null);
                        victim = firstHit.GetEntity();
                    }
                    if (FlansMod.DEBUG && this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)new EntityDebugDot(this.field_70170_p, gunVec, 100, 1.0f, 1.0f, 1.0f));
                    }
                    ShotData.InstantShotData shotData = new ShotData.InstantShotData(-1, EnumHand.MAIN_HAND, (InfoType)type, shootableType, (Entity)driver, gunVec, firstHit, hitPos, gunType.damage, i < gunType.numBullets * shootableType.numBullets - 1, false);
                    ((ItemGun)gunType.item).ServerHandleShotData(null, -1, this.field_70170_p, this, false, shotData);
                }
            } else {
                ShotData.SpawnEntityShotData shotData = new ShotData.SpawnEntityShotData(-1, EnumHand.MAIN_HAND, (InfoType)type, shootableType, (Entity)driver, lookVector);
                ((ItemGun)gunType.item).ServerHandleShotData(null, -1, this.field_70170_p, this, false, shotData);
            }
            this.setShootDelay(type.shootDelay(secondary), secondary);
        } else {
            switch (weaponType) {
                case BOMB: {
                    if (!TeamsManager.bombsEnabled) break;
                    int slot = -1;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ItemStack bomb = this.driveableData.func_70301_a(i);
                        if (bomb == null || !(bomb.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)bomb.func_77973_b()).type, weaponType)) continue;
                        slot = i;
                    }
                    if (slot != -1) {
                        boolean spread = false;
                        int damageMultiplier = secondary ? type.damageModifierSecondary : type.damageModifierPrimary;
                        float shellSpeed = 0.0f;
                        ItemStack bulletStack = this.driveableData.func_70301_a(slot);
                        ItemBullet bulletItem = (ItemBullet)bulletStack.func_77973_b();
                        EntityShootable bulletEntity = bulletItem.getEntity(this.field_70170_p, new Vec3d(this.field_70165_t + (double)gunVec.x, this.field_70163_u + (double)gunVec.y, this.field_70161_v + (double)gunVec.z), this.axes.getYaw(), this.axes.getPitch(), this.field_70159_w, this.field_70181_x, this.field_70179_y, (EntityLivingBase)this.seats[0].func_184179_bs(), damageMultiplier, type);
                        this.field_70170_p.func_72838_d((Entity)bulletEntity);
                        if (type.shootSound(secondary) != null) {
                            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                        }
                        if (!this.driverIsCreative()) {
                            bulletStack.func_77964_b(bulletStack.func_77952_i() + 1);
                            if (bulletStack.func_77952_i() == bulletStack.func_77958_k()) {
                                bulletStack.func_77964_b(0);
                                bulletStack.func_190920_e(bulletStack.func_190916_E() - 1);
                                if (bulletStack.func_190916_E() == 0) {
                                    bulletStack = ItemStack.field_190927_a.func_77946_l();
                                }
                            }
                            this.driveableData.func_70299_a(slot, bulletStack);
                        }
                        this.setShootDelay(type.shootDelay(secondary), secondary);
                        break;
                    }
                    this.shootDelaySecondary = 1.0f;
                    this.shootDelayPrimary = 1.0f;
                    break;
                }
                case MISSILE: 
                case SHELL: {
                    if (!TeamsManager.shellsEnabled) break;
                    int slot = -1;
                    for (int i = this.driveableData.getMissileInventoryStart(); i < this.driveableData.getMissileInventoryStart() + type.numMissileSlots; ++i) {
                        ItemStack shell = this.driveableData.func_70301_a(i);
                        if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)shell.func_77973_b()).type, weaponType)) continue;
                        slot = i;
                    }
                    if (slot != -1) {
                        boolean spread = false;
                        int damageMultiplier = secondary ? type.damageModifierSecondary : type.damageModifierPrimary;
                        float shellSpeed = 3.0f;
                        ItemStack bulletStack = this.driveableData.func_70301_a(slot);
                        ItemBullet bulletItem = (ItemBullet)bulletStack.func_77973_b();
                        EntityShootable bulletEntity = bulletItem.getEntity(this.field_70170_p, Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), gunVec, null), lookVector, (EntityLivingBase)this.seats[0].func_184179_bs(), (float)spread, (float)damageMultiplier, shellSpeed, (InfoType)type);
                        this.field_70170_p.func_72838_d((Entity)bulletEntity);
                        if (type.shootSound(secondary) != null) {
                            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                        }
                        if (!this.driverIsCreative()) {
                            bulletStack.func_77964_b(bulletStack.func_77952_i() + 1);
                            if (bulletStack.func_77952_i() == bulletStack.func_77958_k()) {
                                bulletStack.func_77964_b(0);
                                bulletStack.func_190920_e(bulletStack.func_190916_E() - 1);
                                if (bulletStack.func_190916_E() == 0) {
                                    bulletStack = ItemStack.field_190927_a.func_77946_l();
                                }
                            }
                            this.driveableData.func_70299_a(slot, bulletStack);
                        }
                        this.setShootDelay(type.shootDelay(secondary), secondary);
                        break;
                    }
                    this.shootDelaySecondary = 1.0f;
                    this.shootDelayPrimary = 1.0f;
                    break;
                }
                case GUN: {
                    break;
                }
                case MINE: {
                    break;
                }
            }
        }
    }

    public Vector3f getOrigin(DriveablePosition dp) {
        Vector3f localGunVec = new Vector3f(dp.position);
        if (dp.part == EnumDriveablePart.turret) {
            Vector3f.sub(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
            localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
            Vector3f.add(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
        }
        return this.rotate(localGunVec);
    }

    public Vector3f getLookVector(DriveablePosition dp) {
        return this.axes.getXAxis();
    }

    public void func_70071_h_() {
        boolean canThrust;
        int i;
        super.func_70071_h_();
        DriveableType type = this.getDriveableType();
        for (Entity passenger : this.func_184188_bt()) {
            if (passenger instanceof EntitySeat) {
                EntitySeat seat = (EntitySeat)passenger;
                if (seat.getExpectedSeatID() < 0 || this.seats[seat.getExpectedSeatID()] != null) continue;
                this.seats[seat.getExpectedSeatID()] = seat;
                continue;
            }
            if (passenger instanceof EntityWheel) {
                EntityWheel wheel = (EntityWheel)passenger;
                if (wheel.getExpectedWheelID() < 0 || this.wheels[wheel.getExpectedWheelID()] != null) continue;
                this.wheels[wheel.getExpectedWheelID()] = wheel;
                continue;
            }
            FlansMod.log("Entity " + passenger + " is riding a driveable core entity.");
        }
        this.readyForUpdates = true;
        for (i = 0; i < type.numPassengers; ++i) {
            if (this.seats[i] != null) continue;
            this.readyForUpdates = false;
        }
        for (i = 0; i < type.wheelPositions.length; ++i) {
            if (this.wheels[i] != null) continue;
            this.readyForUpdates = false;
        }
        if (!this.readyForUpdates) {
            if (!this.field_70170_p.field_72995_K) {
                this.initType(type, true, false);
            }
            if (this.field_70170_p.field_72995_K && this.serverPositionTransitionTicker > 0) {
                double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
                double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
                double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
                double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
                double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
                double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
                this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
                this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
                float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
                --this.serverPositionTransitionTicker;
                this.func_70107_b(x, y, z);
                this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
            }
            return;
        }
        if (this.hasEnoughFuel()) {
            this.harvesterAngle += this.throttle / 5.0f;
        }
        if (type.harvestBlocks && type.health.get((Object)EnumDriveablePart.harvester) != null) {
            CollisionBox box = type.health.get((Object)EnumDriveablePart.harvester);
            for (float x = box.x; x <= box.x + box.w; x += 1.0f) {
                for (float y = box.y; y <= box.y + box.h; y += 1.0f) {
                    for (float z = box.z; z <= box.z + box.d; z += 1.0f) {
                        Vector3f v = this.axes.findLocalVectorGlobally(new Vector3f(x, y, z));
                        int blockX = (int)Math.round(this.field_70165_t + (double)v.x);
                        int blockY = (int)Math.round(this.field_70163_u + (double)v.y);
                        int blockZ = (int)Math.round(this.field_70161_v + (double)v.z);
                        IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(blockX, blockY, blockZ));
                        boolean cancelled = false;
                        if (this.seats[0] != null && this.seats[0].func_184179_bs() instanceof EntityPlayerMP) {
                            int eventOutcome = ForgeHooks.onBlockBreakEvent((World)this.field_70170_p, (GameType)(((EntityPlayerMP)this.seats[0].func_184179_bs()).field_71075_bZ.field_75098_d ? GameType.CREATIVE : (((EntityPlayerMP)this.seats[0].func_184179_bs()).field_71075_bZ.field_75099_e ? GameType.SURVIVAL : GameType.ADVENTURE)), (EntityPlayerMP)((EntityPlayerMP)this.seats[0].func_184179_bs()), (BlockPos)new BlockPos(blockX, blockY, blockZ));
                            boolean bl = cancelled = eventOutcome == -1;
                        }
                        if (cancelled || !type.materialsHarvested.contains(block.func_185904_a())) continue;
                        BlockPos blockPos = new BlockPos(blockX, blockY, blockZ);
                        if (!(block.func_185887_b(this.field_70170_p, blockPos) >= 0.0f)) continue;
                        NonNullList stacks = NonNullList.func_191196_a();
                        block.func_177230_c().getDrops(stacks, (IBlockAccess)this.field_70170_p, new BlockPos(blockX, blockY, blockZ), this.field_70170_p.func_180495_p(new BlockPos(blockX, blockY, blockZ)), 0);
                        for (int i2 = 0; i2 < stacks.size(); ++i2) {
                            ItemStack stack = (ItemStack)stacks.get(i2);
                            if (InventoryHelper.addItemStackToInventory(this.driveableData, stack, this.driverIsCreative()) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) continue;
                            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), stack));
                        }
                        this.field_70170_p.func_175655_b(new BlockPos(blockX, blockY, blockZ), false);
                    }
                }
            }
        }
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            Vector3f pos;
            if (part.box == null) continue;
            part.update(this);
            if (this.field_70170_p.field_72995_K) {
                if (part.onFire) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x + this.field_70146_Z.nextFloat() * part.box.w, part.box.y + this.field_70146_Z.nextFloat() * part.box.h, part.box.z + this.field_70146_Z.nextFloat() * part.box.d));
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0, new int[0]);
                }
                if (part.health > 0 && part.health < part.maxHealth / 2) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x + this.field_70146_Z.nextFloat() * part.box.w, part.box.y + this.field_70146_Z.nextFloat() * part.box.h, part.box.z + this.field_70146_Z.nextFloat() * part.box.d));
                    this.field_70170_p.func_175688_a(part.health < part.maxHealth / 4 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (part.onFire) {
                if (this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(40) == 0) {
                    part.onFire = false;
                }
                pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x + part.box.w / 2.0f, part.box.y + part.box.h / 2.0f, part.box.z + part.box.d / 2.0f));
                if (this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z)))).func_185904_a() != Material.field_151586_h) continue;
                part.onFire = false;
                continue;
            }
            pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x / 16.0f + part.box.w / 32.0f, part.box.y / 16.0f + part.box.h / 32.0f, part.box.z / 16.0f + part.box.d / 32.0f));
            if (this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z)))).func_185904_a() != Material.field_151587_i) continue;
            part.onFire = true;
        }
        for (int i3 = 0; i3 < type.emitters.size(); ++i3) {
            DriveableType.ParticleEmitter emitter = type.emitters.get(i3);
            int n = i3;
            this.emitterTimers[n] = this.emitterTimers[n] - 1;
            boolean canEmit = false;
            DriveablePart part = this.getDriveableData().parts.get((Object)EnumDriveablePart.getPart(emitter.part));
            float healthPercentage = (float)part.health / (float)part.maxHealth;
            canEmit = this.isPartIntact(EnumDriveablePart.getPart(emitter.part)) && healthPercentage >= emitter.minHealth && healthPercentage <= emitter.maxHealth;
            if (this.emitterTimers[i3] > 0) continue;
            if (this.throttle >= emitter.minThrottle && this.throttle <= emitter.maxThrottle && canEmit) {
                Vector3f velocity = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
                if (this.seats != null && this.seats[0] != null) {
                    if (EnumDriveablePart.getPart(emitter.part) != EnumDriveablePart.turret && EnumDriveablePart.getPart(emitter.part) != EnumDriveablePart.head) {
                        Vector3f localPosition = new Vector3f(emitter.origin.x + this.field_70146_Z.nextFloat() * emitter.extents.x - emitter.extents.x * 0.5f, emitter.origin.y + this.field_70146_Z.nextFloat() * emitter.extents.y - emitter.extents.y * 0.5f, emitter.origin.z + this.field_70146_Z.nextFloat() * emitter.extents.z - emitter.extents.z * 0.5f);
                        pos = this.axes.findLocalVectorGlobally(localPosition);
                        velocity = this.axes.findLocalVectorGlobally(emitter.velocity);
                    } else if (EnumDriveablePart.getPart(emitter.part) == EnumDriveablePart.turret || EnumDriveablePart.getPart(emitter.part) != EnumDriveablePart.head) {
                        Vector3f localPosition2 = new Vector3f(emitter.origin.x + this.field_70146_Z.nextFloat() * emitter.extents.x - emitter.extents.x * 0.5f, emitter.origin.y + this.field_70146_Z.nextFloat() * emitter.extents.y - emitter.extents.y * 0.5f, emitter.origin.z + this.field_70146_Z.nextFloat() * emitter.extents.z - emitter.extents.z * 0.5f);
                        RotatedAxes yawOnlyLooking = new RotatedAxes(this.seats[0].looking.getYaw() + this.axes.getYaw(), this.axes.getPitch(), this.axes.getRoll());
                        pos = yawOnlyLooking.findLocalVectorGlobally(localPosition2);
                        velocity = yawOnlyLooking.findLocalVectorGlobally(emitter.velocity);
                    }
                    this.field_70170_p.func_175688_a(emitter.effectType, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, (double)velocity.x, (double)velocity.y, (double)velocity.z, new int[0]);
                }
            }
            this.emitterTimers[i3] = emitter.emitRate;
        }
        this.checkParts();
        this.field_70126_B = this.axes.getYaw();
        this.field_70127_C = this.axes.getPitch();
        this.prevRotationRoll = this.axes.getRoll();
        this.prevAxes = this.axes.clone();
        boolean bl = canThrust = this.driverIsCreative() || this.driveableData.fuelInTank > 0.0f;
        if (this.seats[0] != null && this.seats[0].func_184179_bs() == null || !canThrust && this.getDriveableType().maxThrottle != 0.0f && this.getDriveableType().maxNegativeThrottle != 0.0f) {
            this.throttle *= 0.98f;
            this.leftMouseHeld = false;
            this.rightMouseHeld = false;
        } else if (this.seats[0] != null && this.seats[0].func_184179_bs() != null && this.seats[0].func_184179_bs() == this.func_184179_bs()) {
            this.ReportVehicleError();
        }
        if (this.shootDelayPrimary > 0.0f) {
            this.shootDelayPrimary -= 1.0f;
        }
        if (this.shootDelaySecondary > 0.0f) {
            this.shootDelaySecondary -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.leftMouseHeld && this.getDriveableType().modePrimary == EnumFireMode.FULLAUTO) {
                this.shoot(false);
            }
            if (this.rightMouseHeld && this.getDriveableType().modeSecondary == EnumFireMode.FULLAUTO) {
                this.shoot(true);
            }
            this.minigunSpeedPrimary *= 0.9f;
            this.minigunSpeedSecondary *= 0.9f;
            if (this.leftMouseHeld && this.getDriveableType().modePrimary == EnumFireMode.MINIGUN) {
                this.minigunSpeedPrimary += 0.1f;
                if (this.minigunSpeedPrimary > 1.0f) {
                    this.shoot(false);
                }
            }
            if (this.rightMouseHeld && this.getDriveableType().modeSecondary == EnumFireMode.MINIGUN) {
                this.minigunSpeedSecondary += 0.1f;
                if (this.minigunSpeedSecondary > 1.0f) {
                    this.shoot(true);
                }
            }
        }
        int fuelMultiplier = 2;
        if (this.getDriveableData().fuelInTank >= (float)type.fuelTankSize) {
            return;
        }
        for (int i4 = 0; i4 < this.getDriveableData().func_70302_i_(); ++i4) {
            ItemStack stack = this.getDriveableData().func_70301_a(i4);
            if (stack == null || stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (item instanceof ItemPart) {
                PartType part = ((ItemPart)item).type;
                if (part.category != EnumPartCategory.FUEL) continue;
                this.getDriveableData().fuelInTank += (float)fuelMultiplier;
                int damage = stack.func_77952_i();
                stack.func_77964_b(damage + 1);
                if (damage < stack.func_77958_k()) break;
                stack.func_77964_b(0);
                stack.func_190920_e(stack.func_190916_E() - 1);
                if (stack.func_190916_E() > 0) break;
                this.getDriveableData().func_70299_a(i4, null);
                break;
            }
            if (FlansMod.hooks.BuildCraftLoaded && stack.func_77969_a(FlansMod.hooks.BuildCraftOilBucket) && this.getDriveableData().fuelInTank + (float)(1000 * fuelMultiplier) <= (float)type.fuelTankSize) {
                this.getDriveableData().fuelInTank += (float)(1000 * fuelMultiplier);
                this.getDriveableData().func_70299_a(i4, new ItemStack(Items.field_151133_ar));
                continue;
            }
            if (!FlansMod.hooks.BuildCraftLoaded || !stack.func_77969_a(FlansMod.hooks.BuildCraftFuelBucket) || !(this.getDriveableData().fuelInTank + (float)(2000 * fuelMultiplier) <= (float)type.fuelTankSize)) continue;
            this.getDriveableData().fuelInTank += (float)(2000 * fuelMultiplier);
            this.getDriveableData().func_70299_a(i4, new ItemStack(Items.field_151133_ar));
        }
    }

    public void checkForCollisions() {
        boolean crashInWater = false;
        double speed = this.getSpeedXYZ();
        for (DriveablePosition p : this.getDriveableType().collisionPoints) {
            RayTraceResult hit;
            if (this.driveableData.parts.get((Object)((Object)p.part)).dead) continue;
            Vector3f lastRelPos = this.prevAxes.findLocalVectorGlobally(p.position);
            Vec3d lastPos = new Vec3d(this.field_70169_q + (double)lastRelPos.x, this.field_70167_r + (double)lastRelPos.y, this.field_70166_s + (double)lastRelPos.z);
            Vector3f currentRelPos = this.axes.findLocalVectorGlobally(p.position);
            Vec3d currentPos = new Vec3d(this.field_70165_t + (double)currentRelPos.x, this.field_70163_u + (double)currentRelPos.y, this.field_70161_v + (double)currentRelPos.z);
            if (FlansMod.DEBUG && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, new Vector3f(lastPos), Vector3f.sub(currentRelPos, lastRelPos, null), 10, 1.0f, 0.0f, 0.0f));
            }
            if ((hit = this.field_70170_p.func_72901_a(lastPos, currentPos, crashInWater)) == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            BlockPos pos = hit.func_178782_a();
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block blockHit = state.func_177230_c();
            float blockHardness = state.func_185887_b(this.field_70170_p, pos);
            if (!this.attackPart(p.part, DamageSource.field_76368_d, blockHardness * blockHardness * (float)speed) && TeamsManager.driveablesBreakBlocks) {
                if (this.field_70170_p.field_72995_K) continue;
                blockHit.func_176226_b(this.field_70170_p, pos, state, 1);
                this.field_70170_p.func_175698_g(pos);
                continue;
            }
            this.field_70170_p.func_72876_a((Entity)this, currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c, 1.0f, false);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (distance <= 0.0f) {
            return;
        }
        int i = MathHelper.func_76123_f((float)(distance - 10.0f));
        if (i > 0) {
            this.attackPart(EnumDriveablePart.core, DamageSource.field_76379_h, damageMultiplier * (float)i / 5.0f);
        }
    }

    public boolean attackPart(EnumDriveablePart ep, DamageSource source, float damage) {
        DriveablePart part = this.driveableData.parts.get((Object)ep);
        return part.attack(damage, source.func_76347_k());
    }

    public Vector3f rotate(Vector3f inVec) {
        return this.axes.findLocalVectorGlobally(inVec);
    }

    public Vector3f rotate(Vec3d inVec) {
        return this.rotate(inVec.field_72450_a, inVec.field_72448_b, inVec.field_72449_c);
    }

    public Vector3f rotate(double x, double y, double z) {
        return this.rotate(new Vector3f((float)x, (float)y, (float)z));
    }

    public void rotateYaw(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalYaw(rotateBy);
        this.updatePrevAngles();
    }

    public void rotatePitch(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalPitch(rotateBy);
        this.updatePrevAngles();
    }

    public void rotateRoll(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalRoll(rotateBy);
        this.updatePrevAngles();
    }

    public void updatePrevAngles() {
        double dRoll;
        double dPitch;
        double dYaw = this.axes.getYaw() - this.field_70126_B;
        if (dYaw > 180.0) {
            this.field_70126_B += 360.0f;
        }
        if (dYaw < -180.0) {
            this.field_70126_B -= 360.0f;
        }
        if ((dPitch = (double)(this.axes.getPitch() - this.field_70127_C)) > 180.0) {
            this.field_70127_C += 360.0f;
        }
        if (dPitch < -180.0) {
            this.field_70127_C -= 360.0f;
        }
        if ((dRoll = (double)(this.axes.getRoll() - this.prevRotationRoll)) > 180.0) {
            this.prevRotationRoll += 360.0f;
        }
        if (dRoll < -180.0) {
            this.prevRotationRoll -= 360.0f;
        }
    }

    public void setRotation(float rotYaw, float rotPitch, float rotRoll) {
        this.axes.setAngles(rotYaw, rotPitch, rotRoll);
    }

    public boolean isPartOfThis(Entity ent) {
        for (EntitySeat entitySeat : this.seats) {
            if (entitySeat == null) continue;
            if (ent == entitySeat) {
                return true;
            }
            if (entitySeat.func_184179_bs() != ent) continue;
            return true;
        }
        for (Entity entity : this.wheels) {
            if (ent != entity) continue;
            return true;
        }
        return ent == this;
    }

    public DriveableType getDriveableType() {
        return DriveableType.getDriveable(this.driveableType);
    }

    public DriveableData getDriveableData() {
        return this.driveableData;
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    @Override
    public Entity getControllingEntity() {
        return this.seats[0].getControllingEntity();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack(this.getDriveableType().item, 1, 0);
        NBTTagCompound tags = new NBTTagCompound();
        stack.func_77982_d(tags);
        this.driveableData.writeToNBT(tags);
        return stack;
    }

    public boolean hasFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].func_184179_bs() == null) {
            return false;
        }
        return this.driverIsCreative() || this.driveableData.fuelInTank > 0.0f;
    }

    public boolean hasEnoughFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].func_184179_bs() == null) {
            return false;
        }
        return this.driverIsCreative() || this.driveableData.fuelInTank > this.driveableData.engine.fuelConsumption * this.throttle;
    }

    public double getSpeedXYZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public boolean landVehicle() {
        return false;
    }

    public boolean gearDown() {
        return true;
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public ArrayList<FlansModRaytracer.BulletHit> attackFromBullet(Vector3f origin, Vector3f motion) {
        ArrayList<FlansModRaytracer.BulletHit> hits = new ArrayList<FlansModRaytracer.BulletHit>();
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            FlansModRaytracer.DriveableHit hit = part.rayTrace(this, rotatedPosVector, rotatedMotVector);
            if (hit == null) continue;
            hits.add(hit);
        }
        return hits;
    }

    public float bulletHit(BulletType bulletType, float damage, FlansModRaytracer.DriveableHit hit, float penetratingPower) {
        DriveablePart part = this.getDriveableData().parts.get((Object)hit.part);
        part.hitByBullet(bulletType, damage);
        if (!this.field_70170_p.field_72995_K) {
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, this.field_71093_bK);
        }
        return penetratingPower - 5.0f;
    }

    public DriveablePart raytraceParts(Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part.rayTrace(this, rotatedPosVector, rotatedMotVector) == null) continue;
            return part;
        }
        return null;
    }

    public boolean canHitPart(EnumDriveablePart part) {
        return true;
    }

    public void checkParts() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || part.health > 0 || part.maxHealth <= 0) continue;
            this.killPart(part);
        }
        for (EntitySeat entitySeat : this.seats) {
        }
        if (this.getDriveableData().parts.get((Object)((Object)EnumDriveablePart.core)).dead) {
            if (!this.field_70170_p.field_72995_K) {
                for (DriveablePart part : this.driveableData.parts.values()) {
                    if (part.health <= 0 || part.dead) continue;
                    this.killPart(part);
                }
            }
            this.func_70106_y();
        }
    }

    private void killPart(DriveablePart part) {
        if (part.dead) {
            return;
        }
        part.health = 0;
        part.dead = true;
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> drops;
            Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
            if (part.box != null) {
                pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x / 16.0f + part.box.w / 32.0f, part.box.y / 16.0f + part.box.h / 32.0f, part.box.z / 16.0f + part.box.d / 32.0f));
            }
            if ((drops = type.getItemsRequired(part, this.getDriveableData().engine)) != null) {
                for (ItemStack stack : drops) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, stack.func_77946_l()));
                }
            }
            this.dropItemsOnPartDeath(pos, part);
            if (part.type == EnumDriveablePart.core) {
                for (int i = 0; i < this.getDriveableData().func_70302_i_(); ++i) {
                    ItemStack stack;
                    stack = this.getDriveableData().func_70301_a(i);
                    if (stack == null || stack.func_190926_b()) continue;
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian(), stack));
                }
            }
        }
        for (EnumDriveablePart child : part.type.getChildren()) {
            this.killPart(this.getDriveableData().parts.get((Object)child));
        }
    }

    protected abstract void dropItemsOnPartDeath(Vector3f var1, DriveablePart var2);

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    public float getPrevPlayerRoll() {
        return this.prevAxes.getRoll();
    }

    @Override
    public void explode() {
    }

    @Override
    public float getCameraDistance() {
        return this.getDriveableType().cameraDistance;
    }

    public boolean isPartIntact(EnumDriveablePart part) {
        DriveablePart thisPart = this.getDriveableData().parts.get((Object)part);
        return thisPart.maxHealth == 0 || thisPart.health > 0;
    }

    public abstract boolean hasMouseControlMode();

    public abstract String getBombInventoryName();

    public abstract String getMissileInventoryName();

    public boolean rotateWithTurret(Seat seat) {
        return seat.part == EnumDriveablePart.turret;
    }

    public String func_70005_c_() {
        return this.getDriveableType().name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat != 0 || !FlansModClient.controlModeMouse;
    }

    public float getShootDelay(boolean secondary) {
        return secondary ? this.shootDelaySecondary : this.shootDelayPrimary;
    }

    public float getMinigunSpeed(boolean secondary) {
        return secondary ? this.minigunSpeedSecondary : this.minigunSpeedPrimary;
    }

    public int getCurrentGun(boolean secondary) {
        return secondary ? this.currentGunSecondary : this.currentGunPrimary;
    }

    public void setShootDelay(float f, boolean secondary) {
        if (secondary) {
            this.shootDelaySecondary = f;
        } else {
            this.shootDelayPrimary = f;
        }
    }

    public void setMinigunSpeed(float f, boolean secondary) {
        if (secondary) {
            this.minigunSpeedSecondary = f;
        } else {
            this.minigunSpeedPrimary = f;
        }
    }

    public void setCurrentGun(int i, boolean secondary) {
        if (secondary) {
            this.currentGunSecondary = i;
        } else {
            this.currentGunPrimary = i;
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        if (passenger instanceof EntitySeat || passenger instanceof EntityWheel) {
            return this.func_184188_bt().size() < this.getDriveableType().numPassengers + this.getDriveableType().wheelPositions.length + 1;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
    }

    public void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
    }

    @Override
    public EntitySeat getSeat(EntityLivingBase passenger) {
        for (EntitySeat seat : this.seats) {
            if (seat.getControllingEntity() != passenger) continue;
            return seat;
        }
        return null;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void registerSeat(EntitySeat seat) {
        this.seats[seat.getExpectedSeatID()] = seat;
    }

    public void registerWheel(EntityWheel wheel) {
        this.wheels[wheel.getExpectedWheelID()] = wheel;
    }

    public EntitySeat[] getSeats() {
        return this.seats;
    }

    public EntitySeat getSeat(int id) {
        if (this.seats[id] == null) {
            for (Entity passenger : this.func_184188_bt()) {
                EntitySeat seat;
                if (!(passenger instanceof EntitySeat) || (seat = (EntitySeat)passenger).getExpectedSeatID() != id) continue;
                this.seats[id] = seat;
                this.seats[id].driveable = this;
                break;
            }
        }
        return this.seats[id];
    }

    public EntityWheel getWheel(int id) {
        if (this.wheels[id] == null) {
            for (Entity passenger : this.func_184188_bt()) {
                EntityWheel wheel;
                if (!(passenger instanceof EntityWheel) || (wheel = (EntityWheel)passenger).getExpectedWheelID() != id) continue;
                this.wheels[id] = wheel;
                break;
            }
        }
        return this.wheels[id];
    }
}

