/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.nbt.NBTTagCompound;

public class DriveablePart {
    public EnumDriveablePart type;
    public CollisionBox box;
    public int maxHealth;
    public int health;
    public int fireTime;
    public boolean onFire;
    public boolean dead;

    public DriveablePart(EnumDriveablePart e, CollisionBox b) {
        this.type = e;
        this.box = b;
        this.maxHealth = b == null ? 0 : b.health;
        this.health = this.maxHealth;
    }

    public void update(EntityDriveable driveable) {
        if (this.fireTime > 0) {
            --this.fireTime;
        }
        if (this.fireTime == 0) {
            this.onFire = false;
        }
        if (this.onFire) {
            --this.health;
        }
        if (this.health <= 0 && this.maxHealth > 0) {
            this.dead = true;
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74768_a(this.type.getShortName() + "_Health", this.health);
        tags.func_74757_a(this.type.getShortName() + "_Fire", this.onFire);
    }

    public void readFromNBT(NBTTagCompound tags) {
        if (!tags.func_74764_b(this.type.getShortName() + "_Health")) {
            this.health = this.maxHealth;
            this.onFire = false;
            return;
        }
        this.health = tags.func_74762_e(this.type.getShortName() + "_Health");
        this.onFire = tags.func_74767_n(this.type.getShortName() + "_Fire");
    }

    public float smashIntoGround(EntityDriveable driveable, float damage) {
        if (this.box == null || this.dead) {
            return 0.0f;
        }
        if (!driveable.canHitPart(this.type)) {
            return 0.0f;
        }
        if (this.maxHealth == 0) {
            return damage;
        }
        this.health -= (int)(damage / 2.0f);
        return damage / 2.0f;
    }

    public FlansModRaytracer.DriveableHit rayTrace(EntityDriveable driveable, Vector3f origin, Vector3f motion) {
        float intersectX;
        float intersectZ;
        float intersectTime;
        if (this.box == null || this.health <= 0 || this.dead) {
            return null;
        }
        if (!driveable.canHitPart(this.type)) {
            return null;
        }
        if (motion.x != 0.0f) {
            float intersectY;
            if (origin.x < this.box.x) {
                intersectTime = (this.box.x - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.box.y && intersectY <= this.box.y + this.box.h && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d) {
                    return new FlansModRaytracer.DriveableHit(driveable, this.type, intersectTime);
                }
            } else if (origin.x > this.box.x + this.box.w) {
                intersectTime = (this.box.x + this.box.w - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.box.y && intersectY <= this.box.y + this.box.h && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d) {
                    return new FlansModRaytracer.DriveableHit(driveable, this.type, intersectTime);
                }
            }
        }
        if (motion.z != 0.0f) {
            float intersectY;
            if (origin.z < this.box.z) {
                intersectTime = (this.box.z - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectY >= this.box.y && intersectY <= this.box.y + this.box.h) {
                    return new FlansModRaytracer.DriveableHit(driveable, this.type, intersectTime);
                }
            } else if (origin.z > this.box.z + this.box.d) {
                intersectTime = (this.box.z + this.box.d - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectY >= this.box.y && intersectY <= this.box.y + this.box.h) {
                    return new FlansModRaytracer.DriveableHit(driveable, this.type, intersectTime);
                }
            }
        }
        if (motion.y != 0.0f) {
            if (origin.y < this.box.y) {
                intersectTime = (this.box.y - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d) {
                    return new FlansModRaytracer.DriveableHit(driveable, this.type, intersectTime);
                }
            } else if (origin.y > this.box.y + this.box.h) {
                intersectTime = (this.box.y + this.box.h - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d) {
                    return new FlansModRaytracer.DriveableHit(driveable, this.type, intersectTime);
                }
            }
        }
        return null;
    }

    public void hitByBullet(BulletType type, float damage) {
        this.health = (int)((float)this.health - damage * type.damageVsDriveable);
        if (type.setEntitiesOnFire) {
            this.fireTime = 20;
            this.onFire = true;
        }
    }

    private boolean coordIsEntering(float start, float end, float min, float max) {
        if (start < min && end >= min) {
            return true;
        }
        return start > max && end <= max;
    }

    private boolean coordIsIn(float start, float end, float min, float max) {
        if (start >= min && start <= max) {
            return true;
        }
        if (end >= min && end <= max) {
            return true;
        }
        if (start < min && end > max) {
            return true;
        }
        return end < min && start > max;
    }

    public boolean attack(float damage, boolean fireDamage) {
        this.health = (int)((float)this.health - damage);
        if (fireDamage) {
            this.fireTime = 20;
            this.onFire = true;
        }
        return this.health <= 0;
    }
}

