/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.EntityDamageSourceGun;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class FlansModExplosion
extends Explosion {
    private InfoType type;
    private double x;
    private double y;
    private double z;
    private float radius;
    private World world;
    private Entity explosive;
    private EntityPlayer detonator;
    private List affectedBlockPositions;
    private final Vec3d position;
    private final boolean isFlaming;
    private final boolean isSmoking;
    private final Random explosionRNG = new Random();
    private final Map playerMap;
    private boolean breaksBlocks;

    public FlansModExplosion(World world, Entity entity, EntityPlayer detonator, InfoType type, double x, double y, double z, float radius, boolean flaming, boolean smoking, boolean breaksBlocks) {
        super(world, entity, x, y, z, radius, flaming, smoking);
        this.affectedBlockPositions = Lists.newArrayList();
        this.playerMap = Maps.newHashMap();
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.world = world;
        this.explosive = entity;
        this.detonator = detonator;
        this.affectedBlockPositions = Lists.newArrayList();
        this.isFlaming = flaming;
        this.isSmoking = true;
        this.breaksBlocks = breaksBlocks && TeamsManager.explosions;
        this.position = new Vec3d(x, y, z);
        if (!ForgeEventFactory.onExplosionStart((World)world, (Explosion)this)) {
            this.func_77278_a();
            this.func_77279_a(true);
            for (EntityPlayer obj : world.field_73010_i) {
                FlansMod.getPacketHandler().sendTo((Packet)new SPacketExplosion(x, y, z, radius, this.affectedBlockPositions, (Vec3d)this.func_77277_b().get(obj)), (EntityPlayerMP)obj);
            }
        }
    }

    public void func_77278_a() {
        int k;
        int j;
        HashSet hashset = Sets.newHashSet();
        boolean flag = true;
        if (this.breaksBlocks) {
            for (int i = 0; i < 16; ++i) {
                for (j = 0; j < 16; ++j) {
                    for (k = 0; k < 16; ++k) {
                        if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                        double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.x;
                        double d6 = this.y;
                        double d8 = this.z;
                        float f1 = 0.3f;
                        for (float f = this.radius * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            IBlockState iblockstate = this.world.func_180495_p(blockpos);
                            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                                float f2 = this.explosive != null ? this.explosive.func_180428_a((Explosion)this, this.world, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, (Entity)null, (Explosion)this);
                                f -= (f2 + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && (this.explosive == null || this.explosive.func_174816_a((Explosion)this, this.world, blockpos, iblockstate, f))) {
                                hashset.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashset);
        float f3 = this.radius * 2.0f;
        j = MathHelper.func_76128_c((double)(this.x - (double)f3 - 1.0));
        k = MathHelper.func_76128_c((double)(this.x + (double)f3 + 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.y - (double)f3 - 1.0));
        int l = MathHelper.func_76128_c((double)(this.y + (double)f3 + 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.z - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.z + (double)f3 + 1.0));
        List list = this.world.func_72839_b(this.explosive, new AxisAlignedBB((double)j, (double)j1, (double)k1, (double)k, (double)l, (double)i1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3d Vec3d2 = new Vec3d(this.x, this.y, this.z);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(l1);
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.x, this.y, this.z) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.x) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * d7 + (d9 = entity.field_70161_v - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.world.func_72842_a(Vec3d2, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a((DamageSource)new EntityDamageSourceGun(this.type.shortName, this.explosive, this.detonator, this.type, false), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)f3 + 1.0)));
            double d11 = entity instanceof EntityLivingBase ? EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10) : 0.0;
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer)) continue;
            this.playerMap.put((EntityPlayer)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean p_77279_1_) {
        this.world.func_184148_a((EntityPlayer)null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.isSmoking) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.isSmoking) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                IBlockState state = this.world.func_180495_p(blockpos);
                Block block = state.func_177230_c();
                if (p_77279_1_) {
                    double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.radius + 0.1);
                    this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.x * 1.0) / 2.0, (d1 + this.y * 1.0) / 2.0, (d2 + this.z * 1.0) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (state.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.world, blockpos, this.world.func_180495_p(blockpos), 1.0f / this.radius, 0);
                }
                block.onBlockExploded(this.world, blockpos, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                if (this.world.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(blockpos.func_177977_b()).func_185913_b() || this.explosionRNG.nextInt(3) != 0) continue;
                this.world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public Map func_77277_b() {
        return this.playerMap;
    }

    public EntityLivingBase func_94613_c() {
        return this.detonator;
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

