/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.parts.EnumPartCategory;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.EnumType;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class GuiDriveableCrafting
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/driveableCrafting.png");
    private InventoryPlayer inventory;
    private Minecraft mc;
    private World world;
    private int x;
    private int y;
    private int z;
    private static RenderItem itemRenderer;
    private int guiOriginX;
    private int guiOriginY;
    private static int blueprintsScroll;
    private int recipeScroll = 0;
    private static int selectedBlueprint;
    private float spinner = 0.0f;
    private boolean canCraft = false;

    public GuiDriveableCrafting(InventoryPlayer playerinventory, World w, int i, int j, int k) {
        this.inventory = playerinventory;
        this.mc = FMLClientHandler.instance().getClient();
        itemRenderer = this.mc.func_175599_af();
        this.world = w;
        this.x = i;
        this.y = j;
        this.z = k;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 22, this.field_146295_m / 2 + 63, 40, 20, "Craft"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            FlansMod.proxy.craftDriveable(this.inventory.field_70458_d, DriveableType.types.get(selectedBlueprint));
        }
    }

    public void func_73863_a(int i, int j, float f) {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146276_q_();
        GL11.glEnable((int)3042);
        this.mc.field_71446_o.func_110577_a(texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - 88;
        this.guiOriginY = h / 2 - 99;
        this.func_73729_b(this.guiOriginX, this.guiOriginY, 0, 0, 176, 198);
        this.func_73731_b(this.field_146289_q, "Vehicle Crafting", this.guiOriginX + 6, this.guiOriginY + 6, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Requires", this.guiOriginX + 6, this.guiOriginY + 125, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Engine", this.guiOriginX + 114, this.guiOriginY + 141, 0xFFFFFF);
        for (int m = 0; m < 2; ++m) {
            for (int n = 0; n < 8; ++n) {
                int blueprintNumber = blueprintsScroll * 8 + 8 * m + n;
                if (blueprintNumber == selectedBlueprint) {
                    this.mc.field_71446_o.func_110577_a(texture);
                    this.func_73729_b(this.guiOriginX + 8 + n * 18, this.guiOriginY + 18 + m * 18, 213, 11, 16, 16);
                }
                if (blueprintNumber >= DriveableType.types.size()) continue;
                DriveableType type = DriveableType.types.get(blueprintNumber);
                this.drawSlotInventory(new ItemStack(type.item), this.guiOriginX + 8 + n * 18, this.guiOriginY + 18 + m * 18);
            }
        }
        this.spinner += 1.0f;
        if (selectedBlueprint >= DriveableType.types.size()) {
            return;
        }
        this.canCraft = true;
        DriveableType selectedType = DriveableType.types.get(selectedBlueprint);
        if (selectedType != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glTranslatef((float)(w / 2 - 46), (float)(h / 2 - 10), (float)100.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
            GlStateManager.func_179091_B();
            if (selectedType instanceof MechaType) {
                GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
            }
            GL11.glScalef((float)(-50.0f * selectedType.modelScale / selectedType.cameraDistance), (float)(50.0f * selectedType.modelScale / selectedType.cameraDistance), (float)(50.0f * selectedType.modelScale / selectedType.cameraDistance));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(this.spinner / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.mc.field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(selectedType));
            selectedType.model.render(selectedType);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            GL11.glPopMatrix();
            String recipeName = selectedType.name;
            if (recipeName.length() > 16) {
                recipeName = recipeName.substring(0, 15) + "...";
            }
            this.func_73731_b(this.field_146289_q, recipeName, this.guiOriginX + 82, this.guiOriginY + 64, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Cargo Slots : " + selectedType.numCargoSlots, this.guiOriginX + 82, this.guiOriginY + 74, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Bomb Slots : " + selectedType.numBombSlots, this.guiOriginX + 82, this.guiOriginY + 84, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Passengers : " + selectedType.numPassengers, this.guiOriginX + 82, this.guiOriginY + 94, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Guns : " + selectedType.ammoSlots(), this.guiOriginX + 82, this.guiOriginY + 104, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, selectedType.numEngines() + "x", this.guiOriginX + 100, this.guiOriginY + 141, 0xFFFFFF);
            InventoryPlayer temporaryInventory = new InventoryPlayer(null);
            for (int q = 0; q < this.inventory.func_70302_i_(); ++q) {
                temporaryInventory.func_70299_a(q, this.inventory.func_70301_a(q).func_77946_l());
            }
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 4; ++c) {
                    int recipeItemNumber = this.recipeScroll * 4 + r * 4 + c;
                    if (recipeItemNumber >= selectedType.driveableRecipe.size()) continue;
                    ItemStack recipeStack = selectedType.driveableRecipe.get(recipeItemNumber);
                    int totalAmountFound = 0;
                    for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
                        ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
                        if (stackInSlot == null || stackInSlot.func_77973_b() != recipeStack.func_77973_b() || stackInSlot.func_77952_i() != recipeStack.func_77952_i()) continue;
                        int amountFound = Math.min(stackInSlot.func_190916_E(), recipeStack.func_190916_E() - totalAmountFound);
                        stackInSlot.func_190920_e(stackInSlot.func_190916_E() - amountFound);
                        if (stackInSlot.func_190916_E() <= 0) {
                            stackInSlot = ItemStack.field_190927_a.func_77946_l();
                        }
                        temporaryInventory.func_70299_a(n, stackInSlot);
                        if ((totalAmountFound += amountFound) == recipeStack.func_190916_E()) break;
                    }
                    if (totalAmountFound < recipeStack.func_190916_E()) {
                        this.mc.field_71446_o.func_110577_a(texture);
                        this.func_73729_b(this.guiOriginX + 8 + c * 18, this.guiOriginY + 138 + r * 18, 195, 11, 16, 16);
                        this.canCraft = false;
                    }
                    this.drawSlotInventory(recipeStack, this.guiOriginX + 8 + c * 18, this.guiOriginY + 138 + r * 18);
                }
            }
            HashMap<PartType, ItemStack> engines = new HashMap<PartType, ItemStack>();
            for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
                ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
                if (stackInSlot == null || !(stackInSlot.func_77973_b() instanceof ItemPart)) continue;
                PartType partType = ((ItemPart)stackInSlot.func_77973_b()).type;
                if (partType.category != EnumPartCategory.ENGINE || !partType.worksWith.contains((Object)EnumType.getFromObject(selectedType))) continue;
                if (engines.containsKey(partType)) {
                    ((ItemStack)engines.get(partType)).func_190920_e(((ItemStack)engines.get(partType)).func_190916_E() + stackInSlot.func_190916_E());
                    continue;
                }
                engines.put(partType, stackInSlot);
            }
            float bestEngineSpeed = -1.0f;
            ItemStack bestEngineStack = ItemStack.field_190927_a;
            for (PartType part : engines.keySet()) {
                if (!(part.engineSpeed > bestEngineSpeed) || ((ItemStack)engines.get(part)).func_190916_E() < selectedType.numEngines()) continue;
                bestEngineSpeed = part.engineSpeed;
                bestEngineStack = (ItemStack)engines.get(part);
            }
            this.mc.field_71446_o.func_110577_a(texture);
            if (bestEngineStack == null || bestEngineStack.func_190926_b()) {
                this.func_73729_b(this.guiOriginX + 152, this.guiOriginY + 138, 195, 11, 16, 16);
                this.canCraft = false;
            } else {
                this.drawSlotInventory(bestEngineStack, this.guiOriginX + 152, this.guiOriginY + 138);
            }
        }
        if (!this.canCraft) {
            this.mc.field_71446_o.func_110577_a(texture);
            this.func_73729_b(this.guiOriginX + 108, this.guiOriginY + 160, 176, 28, 44, 24);
            this.func_73731_b(this.field_146289_q, "Craft", this.guiOriginX + 116, this.guiOriginY + 168, 0xA0A0A0);
        } else {
            super.func_73863_a(i, j, f);
        }
    }

    private void drawSlotInventory(ItemStack itemstack, int i, int j) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return;
        }
        itemRenderer.func_175042_a(itemstack, i, j);
        itemRenderer.func_180453_a(this.field_146289_q, itemstack, i, j, null);
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1 || i == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            this.mc.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int x = i - this.guiOriginX;
        int y = j - this.guiOriginY;
        if (k == 0 || k == 1) {
            DriveableType selectedType;
            for (int m = 0; m < 2; ++m) {
                for (int n = 0; n < 8; ++n) {
                    if (x < 8 + n * 18 || x > 26 + n * 18 || y < 18 + 18 * m || y > 42 + 18 * m) continue;
                    selectedBlueprint = blueprintsScroll * 8 + m * 8 + n;
                }
            }
            if (x >= 157 && x <= 167 && y >= 21 && y <= 31 && blueprintsScroll > 0) {
                --blueprintsScroll;
            }
            if (x >= 157 && x <= 167 && y >= 39 && y <= 49 && blueprintsScroll * 8 + 16 < DriveableType.types.size()) {
                ++blueprintsScroll;
            }
            if (selectedBlueprint >= DriveableType.types.size()) {
                return;
            }
            if (x >= 83 && x <= 93 && y >= 141 && y <= 151 && this.recipeScroll > 0) {
                --this.recipeScroll;
            }
            if (x >= 83 && x <= 93 && y >= 177 && y <= 187 && (selectedType = DriveableType.types.get(selectedBlueprint)) != null && this.recipeScroll * 4 + 12 < selectedType.driveableRecipe.size()) {
                ++this.recipeScroll;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        blueprintsScroll = 0;
        selectedBlueprint = 0;
    }
}

