/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common.world;

import com.flansmod.apocalypse.common.world.BiomeApocalypse;
import com.flansmod.apocalypse.common.world.GenLayerApocalypse;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderApocalypse
extends BiomeProvider {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache myBiomeCache = new BiomeCache((BiomeProvider)this);
    private List<Biome> myBiomesToSpawnIn = new ArrayList<Biome>();

    public BiomeProviderApocalypse() {
        this.myBiomesToSpawnIn.add(BiomeApocalypse.deepCanyon);
        this.myBiomesToSpawnIn.add(BiomeApocalypse.canyon);
        this.myBiomesToSpawnIn.add(BiomeApocalypse.desert);
        this.myBiomesToSpawnIn.add(BiomeApocalypse.plateau);
        this.myBiomesToSpawnIn.add(BiomeApocalypse.highPlateau);
    }

    public BiomeProviderApocalypse(long par1, WorldType worldType) {
        this();
        GenLayer[] agenlayer = GenLayerApocalypse.makeTheWorld(par1);
        this.unzoomedBiomes = agenlayer[0];
        this.zoomedBiomes = agenlayer[1];
    }

    public BiomeProviderApocalypse(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public List func_76932_a() {
        return this.myBiomesToSpawnIn;
    }

    public Biome func_180631_a(BlockPos pos) {
        Biome biome = this.myBiomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), (Biome)null);
        if (biome == null) {
            return BiomeApocalypse.desert;
        }
        return biome;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public Biome[] func_76937_a(Biome[] par1ArrayOfBiome, int x, int z, int length, int width) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < length * width) {
            par1ArrayOfBiome = new Biome[length * width];
        }
        int[] arrayOfInts = this.unzoomedBiomes.func_75904_a(x, z, length, width);
        for (int i = 0; i < length * width; ++i) {
            par1ArrayOfBiome[i] = arrayOfInts[i] >= 0 ? Biome.func_150568_d((int)arrayOfInts[i]) : BiomeApocalypse.desert;
        }
        return par1ArrayOfBiome;
    }

    public Biome[] func_76931_a(Biome[] par1ArrayOfBiome, int x, int y, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < width * length) {
            par1ArrayOfBiome = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            Biome[] aBiome = this.myBiomeCache.func_76839_e(x, y);
            System.arraycopy(aBiome, 0, par1ArrayOfBiome, 0, width * length);
            return par1ArrayOfBiome;
        }
        int[] ai = this.zoomedBiomes.func_75904_a(x, y, width, length);
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiome[i] = ai[i] >= 0 ? Biome.func_150568_d((int)ai[i]) : BiomeApocalypse.desert;
        }
        return par1ArrayOfBiome;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List biomes) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.unzoomedBiomes.func_75904_a(i, j, i1, j1);
        for (int k1 = 0; k1 < i1 * j1; ++k1) {
            Biome biome = Biome.func_150568_d((int)ai[k1]);
            if (biomes.contains(biome)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List biomes, Random par5Random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.unzoomedBiomes.func_75904_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < ai.length; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = Biome.func_150568_d((int)ai[l1]);
            if (!biomes.contains(biome) || blockpos != null && par5Random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.myBiomeCache.func_76838_a();
    }
}

